/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.mixin.extension;

import cn.solarmoon.spark_core.EntityPatch;
import cn.solarmoon.spark_core.entity.attack.HurtData;
import cn.solarmoon.spark_core.gas.AbilityHandle;
import cn.solarmoon.spark_core.gas.AbilitySpec;
import cn.solarmoon.spark_core.gas.AbilitySystemComponent;
import cn.solarmoon.spark_core.gas.ActivationContext;
import cn.solarmoon.spark_core.gas.GameplayTagContainer;
import cn.solarmoon.spark_core.gas.sync.CancelAbilityEntityPayload;
import cn.solarmoon.spark_core.gas.sync.ClearAbilityEntityPayload;
import cn.solarmoon.spark_core.gas.sync.EndAbilityEntityPayload;
import cn.solarmoon.spark_core.gas.sync.EndAllAbilitiesEntityPayload;
import cn.solarmoon.spark_core.gas.sync.GiveAbilityEntityPayload;
import cn.solarmoon.spark_core.gas.sync.TryActivateAbilityEntityPayload;
import cn.solarmoon.spark_core.physics.level.PhysicsLevel;
import cn.solarmoon.spark_core.registry.common.SparkSyncerTypes;
import cn.solarmoon.spark_core.state_machine.StateMachineHandler;
import cn.solarmoon.spark_core.sync.IntSyncData;
import cn.solarmoon.spark_core.sync.SyncData;
import cn.solarmoon.spark_core.sync.SyncerType;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Entity.class})
public class EntityMixin
implements EntityPatch {
    @Shadow
    private int id;
    @Shadow
    private Level level;
    private Entity entity = (Entity)this;
    private final HurtData data = new HurtData();
    private final ConcurrentHashMap<String, PhysicsCollisionObject> collisionObjects = new ConcurrentHashMap();
    private final HashMap<ResourceLocation, StateMachineHandler> stateMachineHandlers = new HashMap();
    private Vec3 lastPosO = Vec3.ZERO;
    private AbilitySystemComponent asc;
    private final GameplayTagContainer tags = new GameplayTagContainer();

    @Override
    @NotNull
    public @NotNull Map<@NotNull ResourceLocation, @NotNull StateMachineHandler> getStateMachineHandlers() {
        return this.stateMachineHandlers;
    }

    @Override
    @NotNull
    public PhysicsLevel getPhysicsLevel() {
        return this.level.getPhysicsLevel();
    }

    @Override
    @NotNull
    public @NotNull Map<@NotNull String, PhysicsCollisionObject> getAllPhysicsBodies() {
        return this.collisionObjects;
    }

    @Override
    public HurtData getHurtData() {
        return this.data;
    }

    @Override
    @NotNull
    public SyncerType getSyncerType() {
        return (SyncerType)SparkSyncerTypes.getENTITY().get();
    }

    @Override
    public SyncData getSyncData() {
        return new IntSyncData(this.id);
    }

    @Override
    @NotNull
    public Vec3 getLastPosO() {
        return this.lastPosO;
    }

    @Override
    public void setLastPosO(@NotNull Vec3 vec3) {
        this.lastPosO = vec3;
    }

    @Override
    @NotNull
    public AbilitySystemComponent getAbilitySystemComponent() {
        return this.asc;
    }

    @Override
    public void setAbilitySystemComponent(@NotNull AbilitySystemComponent abilitySystemComponent) {
        this.asc = abilitySystemComponent;
    }

    @Override
    public void syncGiveAbility(@NotNull AbilitySpec<?> spec) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new GiveAbilityEntityPayload(this.id, spec), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void syncClearAbility(@NotNull AbilityHandle handle) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ClearAbilityEntityPayload(this.id, handle), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void syncTryActivateAbility(@NotNull AbilityHandle handle, @NotNull ActivationContext context) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)this.entity, (CustomPacketPayload)new TryActivateAbilityEntityPayload(this.id, handle, context), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void syncCancelAbility(@NotNull AbilityHandle handle) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)this.entity, (CustomPacketPayload)new CancelAbilityEntityPayload(this.id, handle), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void syncEndAbility(@NotNull AbilityHandle handle) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)this.entity, (CustomPacketPayload)new EndAbilityEntityPayload(this.id, handle), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void syncEndAllAbilities() {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)this.entity, (CustomPacketPayload)new EndAllAbilitiesEntityPayload(this.id), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    @NotNull
    public GameplayTagContainer getGameplayTags() {
        return this.tags;
    }
}

