/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.mixin.sound;

import cn.solarmoon.spark_core.mixin_interface.ISoundEngineMixin;
import cn.solarmoon.spark_core.sound.SpreadingSoundInstance;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.audio.Listener;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SoundEngine.class})
public abstract class SoundEngineMixin
implements ISoundEngineMixin {
    @Shadow
    @Final
    private Listener listener;
    @Unique
    private final List<SpreadingSoundInstance> machine_Max$spreadingSounds = Lists.newArrayList();

    @Shadow
    public void play(SoundInstance soundInstance) {
    }

    @Inject(method={"tickNonPaused"}, at={@At(value="RETURN")})
    private void machine_Max$tickSpreadingSounds(CallbackInfo ci) {
        Iterator<SpreadingSoundInstance> iterator = this.machine_Max$spreadingSounds.iterator();
        Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        while (iterator.hasNext()) {
            SpreadingSoundInstance instance = iterator.next();
            instance.tick();
            boolean shouldPlay = false;
            for (Vec3 key : instance.spreadDistances.keySet()) {
                float spreadDistance = instance.spreadDistances.get(key).floatValue();
                double distance = pos.distanceToSqr(key);
                if (!(distance <= (double)(spreadDistance * spreadDistance))) continue;
                shouldPlay = true;
                break;
            }
            if (!shouldPlay) continue;
            instance.setVolume(this.machine_Max$calculateVolume(instance));
            instance.setPitch(this.machine_Max$calculatePitch(instance));
            this.play((SoundInstance)instance);
            instance.isPlaying = true;
            iterator.remove();
        }
    }

    @Inject(method={"calculatePitch"}, at={@At(value="RETURN")}, cancellable=true)
    private void calculatePitch(SoundInstance sound, CallbackInfoReturnable<Float> cir) {
        if (sound instanceof SpreadingSoundInstance) {
            SpreadingSoundInstance instance = (SpreadingSoundInstance)sound;
            float dopplerFactor = this.machine_Max$calculatePitch(instance);
            cir.setReturnValue((Object)Float.valueOf(Math.clamp((float)dopplerFactor, (float)0.25f, (float)4.0f)));
        }
    }

    @Inject(method={"calculateVolume*"}, at={@At(value="RETURN")}, cancellable=true)
    private void calculateVolume(SoundInstance sound, CallbackInfoReturnable<Float> cir) {
        if (sound instanceof SpreadingSoundInstance) {
            SpreadingSoundInstance instance = (SpreadingSoundInstance)sound;
            cir.setReturnValue((Object)Float.valueOf(Math.clamp((float)this.machine_Max$calculateVolume(instance), (float)0.0f, (float)1.0f)));
        }
    }

    @Override
    @Unique
    public void machine_Max$queueSpreadingSound(SpreadingSoundInstance sound) {
        this.machine_Max$spreadingSounds.add(sound);
    }

    @Unique
    public float machine_Max$calculateVolume(SpreadingSoundInstance sound) {
        Vec3 sourcePos = new Vec3(sound.getX(), sound.getY(), sound.getZ());
        float distance = (float)this.listener.getTransform().position().distanceTo(sourcePos);
        float range = sound.getRange(sourcePos);
        float volume = sound.getVolume();
        float rate = 1.0f - Math.min((float)(distance / range), (float)1.0f);
        return volume * rate * rate;
    }

    @Unique
    public float machine_Max$calculatePitch(SpreadingSoundInstance sound) {
        Vec3 listenerSpeed;
        Entity entity = Minecraft.getInstance().getCameraEntity();
        if (entity instanceof Entity) {
            Entity entity2 = entity;
            listenerSpeed = entity2.getDeltaMovement().scale(20.0);
        } else {
            listenerSpeed = Vec3.ZERO;
        }
        Vec3 sourcePos = new Vec3(sound.getX(), sound.getY(), sound.getZ());
        Vec3 sourceSpeed = sound.getSpeed(sourcePos);
        Vec3 toListener = this.listener.getTransform().position().subtract(sourcePos).normalize();
        float relativeSpeed = (float)sourceSpeed.dot(toListener) - (float)listenerSpeed.dot(toListener);
        return (1.0f + relativeSpeed / SpreadingSoundInstance.getSoundSpeed(sourcePos.scale(0.5).add(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().scale(0.5)), Minecraft.getInstance().level)) * sound.getPitch();
    }
}

