/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.pack;

import cn.solarmoon.spark_core.SparkCore;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.neoforgespi.language.IModFileInfo;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcn/solarmoon/spark_core/pack/NativeLoader;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "load", "", "moduleName", "", "libName", "SparkCore-1.21.1-neoforge"})
public final class NativeLoader {
    @NotNull
    public static final NativeLoader INSTANCE = new NativeLoader();
    @NotNull
    private static final Logger LOGGER = SparkCore.Companion.logger("Native\u52a0\u8f7d\u5668");

    private NativeLoader() {
    }

    @NotNull
    public final Logger getLOGGER() {
        return LOGGER;
    }

    @JvmStatic
    public static final void load(@NotNull String moduleName, @NotNull String libName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)libName, (String)"libName");
        IModFileInfo modFileInfo = ModList.get().getModFileById("spark_core");
        String[] stringArray = new String[]{"natives/" + moduleName};
        Path sourceDir = modFileInfo.getFile().findResource(stringArray);
        Path nativeFile = sourceDir.resolve(libName);
        if (!Files.exists(nativeFile, new LinkOption[0])) {
            throw new ModLoadingException(ModLoadingIssue.error((String)("\u672a\u627e\u5230Native\u6838\u5fc3\u6587\u4ef6: " + nativeFile), (Object[])new Object[0]));
        }
        File tempFile = Files.createTempFile("spark_core.", "", new FileAttribute[0]).toFile();
        tempFile.deleteOnExit();
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(nativeFile, tempFile.toPath(), copyOptionArray);
        System.load(tempFile.getAbsolutePath());
        LOGGER.info("\u5df2\u52a0\u8f7d\u5e93: " + tempFile.getAbsolutePath() + "." + moduleName + "/" + libName);
    }
}

