/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.pack;

import cn.solarmoon.spark_core.SparkCore;
import cn.solarmoon.spark_core.event.SparkPackageReaderRegisterEvent;
import cn.solarmoon.spark_core.pack.graph.SparkPackGraph;
import cn.solarmoon.spark_core.pack.graph.SparkPackMetaInfo;
import cn.solarmoon.spark_core.pack.graph.SparkPackage;
import cn.solarmoon.spark_core.pack.modules.ReadMode;
import cn.solarmoon.spark_core.pack.modules.SparkPackModule;
import cn.solarmoon.spark_core.pack.readable.ReadableDirectory;
import cn.solarmoon.spark_core.pack.readable.ReadablePathType;
import cn.solarmoon.spark_core.pack.readable.ReadableZip;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010 \u001a\u0004\u0018\u00010\u00162\u0006\u0010!\u001a\u00020\tJ\u0006\u0010\"\u001a\u00020\u001bJ\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0010J\u0014\u0010%\u001a\u00020\u001b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020$0\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R6\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00160\u00152\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00160\u0015@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lcn/solarmoon/spark_core/pack/SparkPackLoader;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "MODULE_NAME", "", "META_PATH", "graph", "Lcn/solarmoon/spark_core/pack/graph/SparkPackGraph;", "getGraph", "()Lcn/solarmoon/spark_core/pack/graph/SparkPackGraph;", "readablePathTypes", "", "Lcn/solarmoon/spark_core/pack/readable/ReadablePathType;", "getReadablePathTypes", "()Ljava/util/List;", "value", "", "Lcn/solarmoon/spark_core/pack/modules/SparkPackModule;", "modules", "getModules", "()Ljava/util/Map;", "initialize", "", "isClientSide", "", "readPackageGraph", "readPackageContent", "getModule", "id", "reset", "collectRemote", "Lcn/solarmoon/spark_core/pack/graph/SparkPackage;", "acceptRemote", "packs", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nSparkPackLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SparkPackLoader.kt\ncn/solarmoon/spark_core/pack/SparkPackLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,123:1\n1869#2,2:124\n1869#2:128\n1870#2:133\n1869#2:136\n1870#2:144\n1869#2,2:145\n295#2,2:147\n216#3,2:126\n216#3:129\n216#3,2:130\n217#3:132\n216#3,2:134\n538#4:137\n523#4,6:138\n*S KotlinDebug\n*F\n+ 1 SparkPackLoader.kt\ncn/solarmoon/spark_core/pack/SparkPackLoader\n*L\n31#1:124,2\n74#1:128\n74#1:133\n100#1:136\n100#1:144\n110#1:145,2\n48#1:147,2\n73#1:126,2\n75#1:129\n76#1:130,2\n75#1:132\n89#1:134,2\n101#1:137\n101#1:138,6\n*E\n"})
public final class SparkPackLoader {
    @NotNull
    public static final SparkPackLoader INSTANCE = new SparkPackLoader();
    @NotNull
    private static final Logger LOGGER = SparkCore.Companion.logger("\u62d3\u5c55\u5305\u52a0\u8f7d\u5668");
    @NotNull
    public static final String MODULE_NAME = "spark_modules";
    @NotNull
    public static final String META_PATH = "meta.json";
    @NotNull
    private static final SparkPackGraph graph = new SparkPackGraph(null, 1, null);
    @NotNull
    private static final List<ReadablePathType> readablePathTypes;
    private static Map<String, ? extends SparkPackModule> modules;

    private SparkPackLoader() {
    }

    @NotNull
    public final Logger getLOGGER() {
        return LOGGER;
    }

    @NotNull
    public final SparkPackGraph getGraph() {
        return graph;
    }

    @NotNull
    public final List<ReadablePathType> getReadablePathTypes() {
        return readablePathTypes;
    }

    @NotNull
    public final Map<String, SparkPackModule> getModules() {
        Map<String, SparkPackModule> map = modules;
        if (map != null) {
            return map;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
        return null;
    }

    public final void initialize(boolean isClientSide) {
        Map readers = new LinkedHashMap();
        ModLoader.postEvent((Event)new SparkPackageReaderRegisterEvent(readers));
        modules = readers;
        Iterable $this$forEach$iv = this.getModules().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SparkPackModule it = (SparkPackModule)element$iv;
            boolean bl = false;
            it.onInitialize(isClientSide);
        }
        LOGGER.info("\u5df2\u6ce8\u518c " + this.getModules().size() + " \u4e2a\u62d3\u5c55\u5305\u6a21\u5757: " + this.getModules().keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readPackageGraph(boolean isClientSide) {
        this.reset();
        Path sparkModulesDir = FMLPaths.GAMEDIR.get().resolve(MODULE_NAME);
        Files.createDirectories(sparkModulesDir, new FileAttribute[0]);
        AutoCloseable autoCloseable = Files.list(sparkModulesDir);
        Throwable throwable = null;
        try {
            Stream paths = (Stream)autoCloseable;
            boolean bl = false;
            paths.forEach(arg_0 -> SparkPackLoader.readPackageGraph$lambda$5$lambda$4(arg_0 -> SparkPackLoader.readPackageGraph$lambda$5$lambda$3(isClientSide, arg_0), arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void readPackageContent(boolean isClientSide) {
        Map.Entry<String, SparkPackModule> it;
        Map.Entry<String, SparkPackModule> element$iv;
        List<SparkPackage> list;
        try {
            list = graph.resolveLoadOrder();
        }
        catch (Exception e) {
            LOGGER.error("\u4f9d\u8d56\u68c0\u67e5\u5931\u8d25: " + e.getMessage());
            return;
        }
        List<SparkPackage> orderedPacks = list;
        Map<String, SparkPackModule> $this$forEach$iv = this.getModules();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, SparkPackModule>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl = false;
            it.getValue().onStart(isClientSide);
        }
        $this$forEach$iv = orderedPacks;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            SparkPackage pack = (SparkPackage)((Object)element$iv);
            boolean bl = false;
            Map<String, SparkPackModule> $this$forEach$iv2 = INSTANCE.getModules();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, SparkPackModule>> iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map<String, byte[]> $this$forEach$iv3;
                Map.Entry<String, SparkPackModule> element$iv2;
                Map.Entry<String, SparkPackModule> entry = element$iv2 = iterator2.next();
                boolean bl2 = false;
                String id = entry.getKey();
                SparkPackModule module = entry.getValue();
                if (pack.getEntries().get(id) == null) continue;
                boolean $i$f$forEach3 = false;
                Iterator<Map.Entry<String, byte[]>> iterator3 = $this$forEach$iv3.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry<String, byte[]> element$iv3;
                    Map.Entry<String, byte[]> entry2 = element$iv3 = iterator3.next();
                    boolean bl3 = false;
                    String path = entry2.getKey();
                    byte[] content = entry2.getValue();
                    String[] stringArray = new String[]{"/"};
                    List parts = StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    String fileName = (String)CollectionsKt.last((List)parts);
                    List pathSegments = parts.size() > 1 ? CollectionsKt.dropLast((List)parts, (int)1) : CollectionsKt.emptyList();
                    try {
                        module.read(pathSegments, fileName, content, pack, isClientSide);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u5305 " + pack.getMeta().getId() + " \u8bfb\u53d6 " + module.getId() + " \u6a21\u5757\u5931\u8d25: " + e);
                    }
                }
            }
            LOGGER.info("\u62d3\u5c55\u5305 " + pack.getMeta().getId() + " \u5df2\u52a0\u8f7d\u5b8c\u6bd5");
        }
        $this$forEach$iv = this.getModules();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl = false;
            it.getValue().onFinish(isClientSide);
        }
    }

    @Nullable
    public final SparkPackModule getModule(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getModules().get(id);
    }

    public final void reset() {
        graph.getOriginNodes().clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SparkPackage> collectRemote() {
        List results = new ArrayList();
        Iterable $this$forEach$iv = graph.getOriginNodes().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            SparkPackage oPack = (SparkPackage)element$iv;
            boolean bl = false;
            Map<String, Map<String, byte[]>> map = oPack.getEntries();
            SparkPackMetaInfo sparkPackMetaInfo = oPack.getMeta();
            List list = results;
            boolean $i$f$filter = false;
            void var12_12 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl2 = false;
                Object object = INSTANCE.getModule((String)it.getKey());
                boolean bl3 = object != null && (object = object.getMode()) != null ? ((ReadMode)((Object)object)).shouldSend() : false;
                if (!bl3) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map map2 = destination$iv$iv;
            Map map3 = MapsKt.toMutableMap((Map)map2);
            SparkPackMetaInfo sparkPackMetaInfo2 = sparkPackMetaInfo;
            list.add(new SparkPackage(sparkPackMetaInfo2, map3));
        }
        return CollectionsKt.toList((Iterable)results);
    }

    public final void acceptRemote(@NotNull List<SparkPackage> packs) {
        Intrinsics.checkNotNullParameter(packs, (String)"packs");
        Iterable $this$forEach$iv = packs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SparkPackage newPack = (SparkPackage)element$iv;
            boolean bl = false;
            ResourceLocation id = newPack.getMeta().getId();
            SparkPackage existing = graph.getOriginNodes().get(id);
            if (existing != null) {
                existing.getEntries().putAll(newPack.getEntries());
                continue;
            }
            graph.getOriginNodes().put(id, newPack);
        }
    }

    private static final Unit readPackageGraph$lambda$5$lambda$3(boolean $isClientSide, Path path) {
        try {
            Object v0;
            block4: {
                Iterable $this$firstOrNull$iv = readablePathTypes;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ReadablePathType it = (ReadablePathType)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)path);
                    if (!it.match(path)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            ReadablePathType readablePathType = v0;
            if (readablePathType != null) {
                ReadablePathType it = readablePathType;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)path);
                SparkPackage pack = it.readAsPackage(path, $isClientSide);
                graph.addNode(pack);
                LOGGER.info("\u6210\u529f\u8bfb\u53d6\u62d3\u5c55\u5305 " + pack.getMeta().getId() + ", \u5305\u542b\u6a21\u5757: " + pack.getModules());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u62d3\u5c55\u5305\u8bfb\u53d6\u5931\u8d25: " + path + " - " + e.getMessage());
        }
        return Unit.INSTANCE;
    }

    private static final void readPackageGraph$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new ReadablePathType[]{ReadableZip.INSTANCE, ReadableDirectory.INSTANCE};
        readablePathTypes = CollectionsKt.listOf((Object[])objectArray);
    }
}

