/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.pack;

import cn.solarmoon.spark_core.SparkCore;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0007J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\nJ\u0006\u0010\u0011\u001a\u00020\u000eJ\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcn/solarmoon/spark_core/pack/SparkPackResourceLoader;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "registry", "", "", "getRegistry", "()Ljava/util/List;", "loadAllModules", "", "loadModule", "modId", "reload", "copyDirectory", "source", "Ljava/nio/file/Path;", "target", "zipModule", "sourceDir", "zipPath", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nSparkPackResourceLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SparkPackResourceLoader.kt\ncn/solarmoon/spark_core/pack/SparkPackResourceLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1869#2,2:95\n1869#2,2:97\n*S KotlinDebug\n*F\n+ 1 SparkPackResourceLoader.kt\ncn/solarmoon/spark_core/pack/SparkPackResourceLoader\n*L\n24#1:95,2\n66#1:97,2\n*E\n"})
public final class SparkPackResourceLoader {
    @NotNull
    public static final SparkPackResourceLoader INSTANCE = new SparkPackResourceLoader();
    @NotNull
    private static final Logger LOGGER = SparkCore.Companion.logger("\u62d3\u5c55\u5305\u8bfb\u53d6\u5668");
    @NotNull
    private static final List<String> registry = new ArrayList();

    private SparkPackResourceLoader() {
    }

    @NotNull
    public final Logger getLOGGER() {
        return LOGGER;
    }

    @NotNull
    public final List<String> getRegistry() {
        return registry;
    }

    @JvmStatic
    public static final void loadAllModules() {
        List list = ModList.get().getMods();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMods(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IModInfo it = (IModInfo)element$iv;
            boolean bl = false;
            String string = it.getModId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getModId(...)");
            registry.add(string);
            String string2 = it.getModId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getModId(...)");
            INSTANCE.loadModule(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadModule(@NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        Path runModulesDir = FMLPaths.GAMEDIR.get().resolve("spark_modules");
        Files.createDirectories(runModulesDir, new FileAttribute[0]);
        IModFileInfo modFileInfo = ModList.get().getModFileById(modId);
        Object object = new String[]{"spark_modules/"};
        Path sourceDir = modFileInfo.getFile().findResource(object);
        try {
            object = Files.list(sourceDir);
            Throwable throwable = null;
            try {
                Stream modules = (Stream)object;
                boolean bl = false;
                modules.filter(arg_0 -> SparkPackResourceLoader.loadModule$lambda$5$lambda$2(SparkPackResourceLoader::loadModule$lambda$5$lambda$1, arg_0)).forEach(arg_0 -> SparkPackResourceLoader.loadModule$lambda$5$lambda$4(arg_0 -> SparkPackResourceLoader.loadModule$lambda$5$lambda$3(runModulesDir, modId, sourceDir, arg_0), arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u65e0\u6cd5\u6253\u5305 Mod " + modId + " \u7684\u8d44\u6e90\u62d3\u5c55\u5230\u6838\u5fc3\u62d3\u5c55\u6587\u4ef6\u5939: " + e);
            return;
        }
    }

    public final void reload() {
        Iterable $this$forEach$iv = registry;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            INSTANCE.loadModule(it);
        }
    }

    private final void copyDirectory(Path source, Path target) {
        Files.walk(source, new FileVisitOption[0]).forEach(arg_0 -> SparkPackResourceLoader.copyDirectory$lambda$8(arg_0 -> SparkPackResourceLoader.copyDirectory$lambda$7(target, source, arg_0), arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zipModule(Path sourceDir, Path zipPath) {
        AutoCloseable autoCloseable = new ZipOutputStream(Files.newOutputStream(zipPath, new OpenOption[0]));
        Throwable throwable = null;
        try {
            ZipOutputStream zos = (ZipOutputStream)autoCloseable;
            boolean bl = false;
            Files.walk(sourceDir, new FileVisitOption[0]).filter(arg_0 -> SparkPackResourceLoader.zipModule$lambda$13$lambda$10(SparkPackResourceLoader::zipModule$lambda$13$lambda$9, arg_0)).forEach(arg_0 -> SparkPackResourceLoader.zipModule$lambda$13$lambda$12(arg_0 -> SparkPackResourceLoader.zipModule$lambda$13$lambda$11(sourceDir, zos, arg_0), arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final boolean loadModule$lambda$5$lambda$1(Path it) {
        return Files.isDirectory(it, new LinkOption[0]);
    }

    private static final boolean loadModule$lambda$5$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit loadModule$lambda$5$lambda$3(Path $runModulesDir, String $modId, Path $sourceDir, Path moduleDir) {
        Path docsDir;
        Path metaFile = moduleDir.resolve("meta.json");
        if (Files.exists(metaFile, new LinkOption[0]) && Files.isRegularFile(metaFile, new LinkOption[0])) {
            Path zipPath = $runModulesDir.resolve(moduleDir.getFileName() + ".zip");
            Intrinsics.checkNotNull((Object)moduleDir);
            Intrinsics.checkNotNull((Object)zipPath);
            INSTANCE.zipModule(moduleDir, zipPath);
            LOGGER.info("\u5df2\u6253\u5305 Mod " + $modId + " \u7684\u8d44\u6e90\u62d3\u5c55\u5230\u6838\u5fc3\u62d3\u5c55\u6587\u4ef6\u5939");
        }
        if (Files.exists(docsDir = $sourceDir.resolve(".docs"), new LinkOption[0]) && Files.isDirectory(docsDir, new LinkOption[0])) {
            Path targetDocsDir = $runModulesDir.resolve(".docs").resolve($modId);
            Intrinsics.checkNotNull((Object)docsDir);
            Intrinsics.checkNotNull((Object)targetDocsDir);
            INSTANCE.copyDirectory(docsDir, targetDocsDir);
            LOGGER.info("\u5df2\u590d\u5236 Mod " + $modId + " \u7684 .docs \u6587\u4ef6\u5939\u5230 " + targetDocsDir);
        }
        return Unit.INSTANCE;
    }

    private static final void loadModule$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit copyDirectory$lambda$7(Path $target, Path $source, Path path) {
        Path targetPath = $target.resolve(((Object)$source.relativize(path)).toString());
        if (Files.isDirectory(path, new LinkOption[0])) {
            v0 = Files.createDirectories(targetPath, new FileAttribute[0]);
        } else {
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            v0 = Files.copy(path, targetPath, copyOptionArray);
        }
        return Unit.INSTANCE;
    }

    private static final void copyDirectory$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean zipModule$lambda$13$lambda$9(Path it) {
        return Files.isRegularFile(it, new LinkOption[0]);
    }

    private static final boolean zipModule$lambda$13$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit zipModule$lambda$13$lambda$11(Path $sourceDir, ZipOutputStream $zos, Path file) {
        String entryName = StringsKt.replace$default((String)((Object)$sourceDir.relativize(file)).toString(), (String)"\\", (String)"/", (boolean)false, (int)4, null);
        $zos.putNextEntry(new ZipEntry(entryName));
        Files.copy(file, $zos);
        $zos.closeEntry();
        return Unit.INSTANCE;
    }

    private static final void zipModule$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

