/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.pack.modules;

import cn.solarmoon.spark_core.SparkCore;
import cn.solarmoon.spark_core.pack.graph.SparkPackage;
import cn.solarmoon.spark_core.pack.modules.SparkPackModule;
import cn.solarmoon.spark_core.registry.common.SparkPackModuleRegister;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 /2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001/B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J6\u0010\u0018\u001a\u00020\u00032\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J%\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014\u00a2\u0006\u0002\u0010(J*\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+2\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00120\u001aH\u0002J\u001e\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010-2\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u0014H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcn/solarmoon/spark_core/pack/modules/RecipeModule;", "Lcn/solarmoon/spark_core/pack/modules/SparkPackModule;", "Lnet/minecraft/server/packs/resources/SimplePreparableReloadListener;", "", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "count", "", "getCount", "()I", "setCount", "(I)V", "recipes", "", "Lcom/mojang/datafixers/util/Pair;", "Lnet/minecraft/resources/ResourceLocation;", "Lcom/google/gson/JsonElement;", "onStart", "isClientSide", "", "read", "pathSegments", "", "fileName", "content", "", "pack", "Lcn/solarmoon/spark_core/pack/graph/SparkPackage;", "onFinish", "prepare", "resourceManager", "Lnet/minecraft/server/packs/resources/ResourceManager;", "profiler", "Lnet/minecraft/util/profiling/ProfilerFiller;", "apply", "void", "(Lkotlin/Unit;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V", "registerRecipes", "manager", "Lnet/minecraft/world/item/crafting/RecipeManager;", "parseRecipe", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "json", "Companion", "SparkCore-1.21.1-neoforge"})
public final class RecipeModule
extends SimplePreparableReloadListener<Unit>
implements SparkPackModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private int count;
    @NotNull
    private final List<Pair<ResourceLocation, JsonElement>> recipes = new ArrayList();
    @Nullable
    private static ReloadableServerResources serverResources;

    public RecipeModule() {
        this.id = "recipes";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    public final int getCount() {
        return this.count;
    }

    public final void setCount(int n) {
        this.count = n;
    }

    @Override
    public void onStart(boolean isClientSide) {
        this.count = 0;
        this.recipes.clear();
        SparkCore.LOGGER.info("\u5f00\u59cb\u6ce8\u5165\u5916\u90e8\u5305\u914d\u65b9\u2026");
    }

    @Override
    public void read(@NotNull List<String> pathSegments, @NotNull String fileName, @NotNull byte[] content, @NotNull SparkPackage pack, boolean isClientSide) {
        Intrinsics.checkNotNullParameter(pathSegments, (String)"pathSegments");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
        if (StringsKt.endsWith$default((String)fileName, (String)".json", (boolean)false, (int)2, null)) {
            String nameSpace = pathSegments.size() > 1 ? pathSegments.get(0) : "spark_core";
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)StringsKt.substringBeforeLast$default((String)fileName, (String)".json", null, (int)2, null));
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            JsonElement json = JsonParser.parseString((String)new String(content, charset2));
            Pair pair = Pair.of((Object)id, (Object)json);
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"of(...)");
            this.recipes.add((Pair<ResourceLocation, JsonElement>)pair);
            int n = this.count;
            this.count = n + 1;
        }
    }

    @Override
    public void onFinish(boolean isClientSide) {
        SparkCore.LOGGER.info("\u4ece\u5916\u90e8\u5305\u6ce8\u5165\u4e86{}\u4e2a\u914d\u65b9", (Object)this.count);
        if (serverResources != null && !((Collection)this.recipes).isEmpty()) {
            ReloadableServerResources reloadableServerResources = serverResources;
            Intrinsics.checkNotNull((Object)reloadableServerResources);
            RecipeManager recipeManager = reloadableServerResources.getRecipeManager();
            Intrinsics.checkNotNull((Object)recipeManager);
            this.registerRecipes(recipeManager, this.recipes);
        }
    }

    protected void prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
        Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
    }

    protected void apply(@NotNull Unit unit, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"void");
        Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
        Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
        if (serverResources != null && !((Collection)this.recipes).isEmpty()) {
            ReloadableServerResources reloadableServerResources = serverResources;
            Intrinsics.checkNotNull((Object)reloadableServerResources);
            RecipeManager recipeManager = reloadableServerResources.getRecipeManager();
            Intrinsics.checkNotNull((Object)recipeManager);
            this.registerRecipes(recipeManager, this.recipes);
        }
    }

    private final void registerRecipes(RecipeManager manager, List<? extends Pair<ResourceLocation, JsonElement>> recipes) {
        try {
            Field byNameField = RecipeManager.class.getDeclaredField("byName");
            byNameField.setAccessible(true);
            Field byTypeField = RecipeManager.class.getDeclaredField("byType");
            byTypeField.setAccessible(true);
            Object object = byNameField.get(manager);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<net.minecraft.resources.ResourceLocation, net.minecraft.world.item.crafting.RecipeHolder<*>>");
            Map currentByName = (Map)object;
            Object object2 = byTypeField.get(manager);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.google.common.collect.Multimap<net.minecraft.world.item.crafting.RecipeType<*>, net.minecraft.world.item.crafting.RecipeHolder<*>>");
            Multimap currentByType = (Multimap)object2;
            Map newByName = new HashMap(currentByName);
            ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)arrayListMultimap, (String)"create(...)");
            Multimap newByType = (Multimap)arrayListMultimap;
            Map map = currentByType.asMap();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"asMap(...)");
            for (Map.Entry entry : map.entrySet()) {
                RecipeType key = (RecipeType)entry.getKey();
                Collection value = (Collection)entry.getValue();
                newByType.putAll((Object)key, (Iterable)value);
            }
            for (Pair pair : recipes) {
                ResourceLocation id = (ResourceLocation)pair.getFirst();
                JsonElement json = (JsonElement)pair.getSecond();
                Intrinsics.checkNotNull((Object)id);
                Intrinsics.checkNotNull((Object)json);
                RecipeHolder<?> recipeHolder = this.parseRecipe(id, json);
                if (recipeHolder == null) continue;
                newByName.put(id, recipeHolder);
                Iterator iterator = newByType.get((Object)recipeHolder.value().getType()).iterator();
                while (iterator.hasNext()) {
                    RecipeHolder value = (RecipeHolder)iterator.next();
                    if (!Intrinsics.areEqual((Object)value.id(), (Object)id)) continue;
                    iterator.remove();
                }
                newByType.put((Object)recipeHolder.value().getType(), recipeHolder);
            }
            ImmutableMap immutableMap = ImmutableMap.copyOf((Map)newByName);
            Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"copyOf(...)");
            Map immutableByName = (Map)immutableMap;
            ImmutableMultimap immutableMultimap = ImmutableMultimap.copyOf((Multimap)newByType);
            Intrinsics.checkNotNullExpressionValue((Object)immutableMultimap, (String)"copyOf(...)");
            Multimap multimap = (Multimap)immutableMultimap;
            byNameField.set(manager, immutableByName);
            byTypeField.set(manager, multimap);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Failed to register external recipes", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to register external recipes", e);
        }
    }

    private final RecipeHolder<?> parseRecipe(ResourceLocation id, JsonElement json) {
        try {
            Recipe recipe = (Recipe)Recipe.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(RecipeModule::parseRecipe$lambda$0);
            return new RecipeHolder(id, recipe);
        }
        catch (Exception e) {
            SparkCore.LOGGER.error("An error occurred while reading recipe {}, skipped. Reason: {}", (Object)id, (Object)e.getMessage());
            return null;
        }
    }

    private static final JsonParseException parseRecipe$lambda$0(String msg) {
        return new JsonParseException(msg);
    }

    @SubscribeEvent
    @JvmStatic
    public static final void registerServerReloadListeners(@NotNull AddReloadListenerEvent event) {
        Companion.registerServerReloadListeners(event);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\u000b"}, d2={"Lcn/solarmoon/spark_core/pack/modules/RecipeModule$Companion;", "", "<init>", "()V", "serverResources", "Lnet/minecraft/server/ReloadableServerResources;", "getServerResources$annotations", "registerServerReloadListeners", "", "event", "Lnet/neoforged/neoforge/event/AddReloadListenerEvent;", "SparkCore-1.21.1-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getServerResources$annotations() {
        }

        @SubscribeEvent
        @JvmStatic
        public final void registerServerReloadListeners(@NotNull AddReloadListenerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            event.addListener((PreparableReloadListener)SparkPackModuleRegister.INSTANCE.getRecipe());
            serverResources = event.getServerResources();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

