/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.particle;

import cn.solarmoon.spark_core.particle.SpaceWarpParticle;
import cn.solarmoon.spark_core.particle.SparkParticleRenderType;
import cn.solarmoon.spark_core.registry.common.SparkParticles;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty1;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002 !BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003J\u0010\u0010\u001f\u001a\u00020\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcn/solarmoon/spark_core/particle/SpaceWarpParticle;", "Lnet/minecraft/client/particle/Particle;", "minRadius", "", "maxRadius", "baseStrength", "lifeTime", "", "level", "Lnet/minecraft/client/multiplayer/ClientLevel;", "x", "", "y", "z", "<init>", "(FFFILnet/minecraft/client/multiplayer/ClientLevel;DDD)V", "getMinRadius", "()F", "getMaxRadius", "getBaseStrength", "partialTicks", "render", "", "buffer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "camera", "Lnet/minecraft/client/Camera;", "getRenderType", "Lnet/minecraft/client/particle/ParticleRenderType;", "getRadius", "getStrength", "getProgress", "Option", "Provider", "SparkCore-1.21.1-neoforge"})
public final class SpaceWarpParticle
extends Particle {
    private final float minRadius;
    private final float maxRadius;
    private final float baseStrength;
    private float partialTicks;

    public SpaceWarpParticle(float minRadius, float maxRadius, float baseStrength, int lifeTime, @NotNull ClientLevel level, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(level, x, y, z);
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        this.baseStrength = baseStrength;
        this.setLifetime(lifeTime);
    }

    public final float getMinRadius() {
        return this.minRadius;
    }

    public final float getMaxRadius() {
        return this.maxRadius;
    }

    public final float getBaseStrength() {
        return this.baseStrength;
    }

    public void render(@NotNull VertexConsumer buffer, @NotNull Camera camera, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        this.partialTicks = partialTicks;
        Vector3f rPos = this.getPos().subtract(camera.getPosition()).toVector3f();
        float cx = rPos.x;
        float cy = rPos.y;
        float cz = rPos.z;
        float r = this.getRadius(partialTicks);
        buffer.addVertex(cx - r, cy - r, cz - r);
        buffer.addVertex(cx + r, cy - r, cz - r);
        buffer.addVertex(cx + r, cy + r, cz - r);
        buffer.addVertex(cx - r, cy + r, cz - r);
        buffer.addVertex(cx + r, cy - r, cz + r);
        buffer.addVertex(cx - r, cy - r, cz + r);
        buffer.addVertex(cx - r, cy + r, cz + r);
        buffer.addVertex(cx + r, cy + r, cz + r);
        buffer.addVertex(cx - r, cy - r, cz + r);
        buffer.addVertex(cx - r, cy - r, cz - r);
        buffer.addVertex(cx - r, cy + r, cz - r);
        buffer.addVertex(cx - r, cy + r, cz + r);
        buffer.addVertex(cx + r, cy - r, cz - r);
        buffer.addVertex(cx + r, cy - r, cz + r);
        buffer.addVertex(cx + r, cy + r, cz + r);
        buffer.addVertex(cx + r, cy + r, cz - r);
        buffer.addVertex(cx - r, cy + r, cz - r);
        buffer.addVertex(cx + r, cy + r, cz - r);
        buffer.addVertex(cx + r, cy + r, cz + r);
        buffer.addVertex(cx - r, cy + r, cz + r);
        buffer.addVertex(cx - r, cy - r, cz + r);
        buffer.addVertex(cx + r, cy - r, cz + r);
        buffer.addVertex(cx + r, cy - r, cz - r);
        buffer.addVertex(cx - r, cy - r, cz - r);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return SparkParticleRenderType.INSTANCE.distort(this.getProgress(this.partialTicks), this.getStrength(this.partialTicks));
    }

    public final float getRadius(float partialTicks) {
        float p = this.getProgress(partialTicks);
        return Mth.lerp((float)p, (float)this.minRadius, (float)this.maxRadius);
    }

    public final float getStrength(float partialTicks) {
        float p = this.getProgress(partialTicks);
        float s = this.baseStrength * (1.0f - p * 0.85f);
        return RangesKt.coerceAtLeast((float)s, (float)0.0f);
    }

    public final float getProgress(float partialTicks) {
        return RangesKt.coerceIn((float)(((float)this.age + partialTicks) / (float)this.lifetime), (float)0.0f, (float)1.0f);
    }

    public static /* synthetic */ float getProgress$default(SpaceWarpParticle spaceWarpParticle, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        return spaceWarpParticle.getProgress(f);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\u0004\b\n\u0010\u000bB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\fJ\f\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcn/solarmoon/spark_core/particle/SpaceWarpParticle$Option;", "Lnet/minecraft/core/particles/ParticleOptions;", "minRadius", "", "maxRadius", "baseStrength", "lifeTime", "", "type", "Lnet/minecraft/core/particles/ParticleType;", "<init>", "(FFFILnet/minecraft/core/particles/ParticleType;)V", "(FFFI)V", "getMinRadius", "()F", "getMaxRadius", "getBaseStrength", "getLifeTime", "()I", "getType", "Companion", "SparkCore-1.21.1-neoforge"})
    public static final class Option
    implements ParticleOptions {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final float minRadius;
        private final float maxRadius;
        private final float baseStrength;
        private final int lifeTime;
        @NotNull
        private final ParticleType<Option> type;

        private Option(float minRadius, float maxRadius, float baseStrength, int lifeTime, ParticleType<Option> type) {
            this.minRadius = minRadius;
            this.maxRadius = maxRadius;
            this.baseStrength = baseStrength;
            this.lifeTime = lifeTime;
            this.type = type;
        }

        public final float getMinRadius() {
            return this.minRadius;
        }

        public final float getMaxRadius() {
            return this.maxRadius;
        }

        public final float getBaseStrength() {
            return this.baseStrength;
        }

        public final int getLifeTime() {
            return this.lifeTime;
        }

        public Option(float minRadius, float maxRadius, float baseStrength, int lifeTime) {
            Object object = SparkParticles.INSTANCE.getSPACE_WARP().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            this(minRadius, maxRadius, baseStrength, lifeTime, (ParticleType<Option>)((ParticleType)object));
        }

        @NotNull
        public ParticleType<?> getType() {
            return this.type;
        }

        public /* synthetic */ Option(float minRadius, float maxRadius, float baseStrength, int lifeTime, ParticleType type, DefaultConstructorMarker $constructor_marker) {
            this(minRadius, maxRadius, baseStrength, lifeTime, (ParticleType<Option>)type);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\u0002\u0010\nJY\u0010\u000b\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\f0\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcn/solarmoon/spark_core/particle/SpaceWarpParticle$Option$Companion;", "", "<init>", "()V", "codec", "Lcom/mojang/serialization/MapCodec;", "Lcn/solarmoon/spark_core/particle/SpaceWarpParticle$Option;", "kotlin.jvm.PlatformType", "type", "Lnet/minecraft/core/particles/ParticleType;", "(Lnet/minecraft/core/particles/ParticleType;)Lcom/mojang/serialization/MapCodec;", "streamCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lio/netty/buffer/ByteBuf;", "(Lnet/minecraft/core/particles/ParticleType;)Lnet/minecraft/network/codec/StreamCodec;", "SparkCore-1.21.1-neoforge"})
        public static final class Companion {
            private Companion() {
            }

            public final MapCodec<Option> codec(@NotNull ParticleType<Option> type) {
                Intrinsics.checkNotNullParameter(type, (String)"type");
                return RecordCodecBuilder.mapCodec(arg_0 -> Companion.codec$lambda$5(type, arg_0));
            }

            public final StreamCodec<ByteBuf, Option> streamCodec(@NotNull ParticleType<Option> type) {
                Intrinsics.checkNotNullParameter(type, (String)"type");
                return StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, arg_0 -> Companion.streamCodec$lambda$6((KProperty1)streamCodec.1.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.FLOAT, arg_0 -> Companion.streamCodec$lambda$7((KProperty1)streamCodec.2.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.FLOAT, arg_0 -> Companion.streamCodec$lambda$8((KProperty1)streamCodec.3.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.INT, arg_0 -> Companion.streamCodec$lambda$9((KProperty1)streamCodec.4.INSTANCE, arg_0), (arg_0, arg_1, arg_2, arg_3) -> Companion.streamCodec$lambda$10(type, arg_0, arg_1, arg_2, arg_3));
            }

            private static final Float codec$lambda$5$lambda$0(KProperty1 $tmp0, Option p0) {
                return (Float)((Function1)$tmp0).invoke((Object)p0);
            }

            private static final Float codec$lambda$5$lambda$1(KProperty1 $tmp0, Option p0) {
                return (Float)((Function1)$tmp0).invoke((Object)p0);
            }

            private static final Float codec$lambda$5$lambda$2(KProperty1 $tmp0, Option p0) {
                return (Float)((Function1)$tmp0).invoke((Object)p0);
            }

            private static final Integer codec$lambda$5$lambda$3(KProperty1 $tmp0, Option p0) {
                return (Integer)((Function1)$tmp0).invoke((Object)p0);
            }

            private static final Option codec$lambda$5$lambda$4(ParticleType $type, Float t, Float d, Float c, Integer l) {
                Intrinsics.checkNotNull((Object)t);
                float f = t.floatValue();
                Intrinsics.checkNotNull((Object)d);
                float f2 = d.floatValue();
                Intrinsics.checkNotNull((Object)c);
                float f3 = c.floatValue();
                Intrinsics.checkNotNull((Object)l);
                return new Option(f, f2, f3, l, $type, null);
            }

            private static final App codec$lambda$5(ParticleType $type, RecordCodecBuilder.Instance it) {
                return it.group((App)Codec.FLOAT.fieldOf("min_radius").forGetter(arg_0 -> Companion.codec$lambda$5$lambda$0((KProperty1)codec.1.1.INSTANCE, arg_0)), (App)Codec.FLOAT.fieldOf("max_radius").forGetter(arg_0 -> Companion.codec$lambda$5$lambda$1((KProperty1)codec.1.2.INSTANCE, arg_0)), (App)Codec.FLOAT.fieldOf("strength").forGetter(arg_0 -> Companion.codec$lambda$5$lambda$2((KProperty1)codec.1.3.INSTANCE, arg_0)), (App)Codec.INT.fieldOf("life_time").forGetter(arg_0 -> Companion.codec$lambda$5$lambda$3((KProperty1)codec.1.4.INSTANCE, arg_0))).apply((Applicative)it, (arg_0, arg_1, arg_2, arg_3) -> Companion.codec$lambda$5$lambda$4($type, arg_0, arg_1, arg_2, arg_3));
            }

            private static final Float streamCodec$lambda$6(KProperty1 $tmp0, Option p0) {
                return (Float)((Function1)$tmp0).invoke((Object)p0);
            }

            private static final Float streamCodec$lambda$7(KProperty1 $tmp0, Option p0) {
                return (Float)((Function1)$tmp0).invoke((Object)p0);
            }

            private static final Float streamCodec$lambda$8(KProperty1 $tmp0, Option p0) {
                return (Float)((Function1)$tmp0).invoke((Object)p0);
            }

            private static final Integer streamCodec$lambda$9(KProperty1 $tmp0, Option p0) {
                return (Integer)((Function1)$tmp0).invoke((Object)p0);
            }

            private static final Option streamCodec$lambda$10(ParticleType $type, Float syncerType, Float syncData, Float c, Integer l) {
                Intrinsics.checkNotNull((Object)syncerType);
                float f = syncerType.floatValue();
                Intrinsics.checkNotNull((Object)syncData);
                float f2 = syncData.floatValue();
                Intrinsics.checkNotNull((Object)c);
                float f3 = c.floatValue();
                Intrinsics.checkNotNull((Object)l);
                return new Option(f, f2, f3, l, $type, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004JH\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lcn/solarmoon/spark_core/particle/SpaceWarpParticle$Provider;", "Lnet/minecraft/client/particle/ParticleProvider;", "Lcn/solarmoon/spark_core/particle/SpaceWarpParticle$Option;", "<init>", "()V", "createParticle", "Lnet/minecraft/client/particle/Particle;", "type", "level", "Lnet/minecraft/client/multiplayer/ClientLevel;", "x", "", "y", "z", "xSpeed", "ySpeed", "zSpeed", "SparkCore-1.21.1-neoforge"})
    public static final class Provider
    implements ParticleProvider<Option> {
        @NotNull
        public Particle createParticle(@NotNull Option type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            return new SpaceWarpParticle(type.getMinRadius(), type.getMaxRadius(), type.getBaseStrength(), type.getLifeTime(), level, x, y, z);
        }
    }
}

