/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.physics.level;

import cn.solarmoon.spark_core.physics.level.PhysicsLevel;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcn/solarmoon/spark_core/physics/level/ClientPhysicsLevel;", "Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;", "mcLevel", "Lnet/minecraft/client/multiplayer/ClientLevel;", "<init>", "(Lnet/minecraft/client/multiplayer/ClientLevel;)V", "getMcLevel", "()Lnet/minecraft/client/multiplayer/ClientLevel;", "requestEntities", "", "Lnet/minecraft/world/entity/Entity;", "partialTicks", "", "getPartialTicks", "()F", "SparkCore-1.21.1-neoforge"})
public final class ClientPhysicsLevel
extends PhysicsLevel {
    @NotNull
    private final ClientLevel mcLevel;

    public ClientPhysicsLevel(@NotNull ClientLevel mcLevel) {
        Intrinsics.checkNotNullParameter((Object)mcLevel, (String)"mcLevel");
        super("Client PhysicsThread", (Level)mcLevel);
        this.mcLevel = mcLevel;
    }

    @NotNull
    public ClientLevel getMcLevel() {
        return this.mcLevel;
    }

    @Override
    @NotNull
    public List<Entity> requestEntities() {
        Minecraft mc = Minecraft.getInstance();
        float renderDistance = mc.gameRenderer.getRenderDistance();
        Entity entity = mc.cameraEntity;
        if (entity != null) {
            Entity player = entity;
            boolean bl = false;
            ClientLevel clientLevel = mc.level;
            if (clientLevel != null) {
                ClientLevel level = clientLevel;
                List list = level.getEntities(null, player.getBoundingBox().inflate((double)renderDistance), EntitySelector.ENTITY_STILL_ALIVE);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
                return list;
            }
        }
        return CollectionsKt.emptyList();
    }

    public final float getPartialTicks() {
        long currentTime = System.nanoTime();
        float elapsedSinceLastTick = (float)(currentTime - this.getLastPhysicsTickTime()) / 1.0E9f;
        return RangesKt.coerceIn((float)(elapsedSinceLastTick * (float)20), (float)0.0f, (float)1.0f);
    }
}

