/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.physics.level;

import cn.solarmoon.spark_core.SparkCore;
import cn.solarmoon.spark_core.event.PhysicsEntityTickEvent;
import cn.solarmoon.spark_core.event.PhysicsLevelTickEvent;
import cn.solarmoon.spark_core.physics.PhysicsHost;
import cn.solarmoon.spark_core.physics.body.PhysicsBodyEvent;
import cn.solarmoon.spark_core.physics.body.PhysicsBodyExtensionKt;
import cn.solarmoon.spark_core.physics.body.RigidBodyEntity;
import cn.solarmoon.spark_core.physics.level.PhysicsLevel;
import cn.solarmoon.spark_core.physics.level.PhysicsLevelState;
import cn.solarmoon.spark_core.physics.level.PhysicsWorld;
import cn.solarmoon.spark_core.physics.terrain.BlockShapeManager;
import cn.solarmoon.spark_core.physics.terrain.PhysicsChunkManager;
import cn.solarmoon.spark_core.physics.terrain.PhysicsChunkSection;
import cn.solarmoon.spark_core.util.InlineEvent;
import cn.solarmoon.spark_core.util.InlineEventConsumer;
import cn.solarmoon.spark_core.util.InlineEventHandler;
import cn.solarmoon.spark_core.util.PPhase;
import cn.solarmoon.spark_core.util.SparkMathKt;
import cn.solarmoon.spark_core.util.TaskSubmitOffice;
import com.jme3.bounding.BoundingBox;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.PhysicsTickListener;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.joints.New6Dof;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.util.NativeLibrary;
import com.jme3.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\b&\u0018\u0000 m2\u00060\u0001j\u0002`\u00022\u00020\u00032\u00020\u0004:\u0001mB\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010Z\u001a\u00020(*\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010[J\u0006\u0010\\\u001a\u00020(J\u0018\u0010]\u001a\u00020(2\u0010\b\u0002\u0010^\u001a\n\u0012\u0004\u0012\u00020(\u0018\u000108J\b\u0010_\u001a\u00020(H\u0016J\u0006\u0010`\u001a\u00020(J\u0018\u0010a\u001a\u00020(2\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020eH\u0016J\u0018\u0010f\u001a\u00020(2\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020eH\u0016J\u0018\u0010g\u001a\u00020(2\u0006\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020kH\u0004J\u000e\u0010l\u001a\b\u0012\u0004\u0012\u00020J0IH&R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010,\u001a\u00020+2\u0006\u0010*\u001a\u00020+@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R)\u0010/\u001a\u001a\u0012\u0004\u0012\u000201\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002030200\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R2\u00106\u001a \u0012\u0004\u0012\u000207\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020(080000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00105R,\u0010:\u001a\u001a\u0012\u0004\u0012\u000207\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(080;00X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u00105R\u001a\u0010=\u001a\u00020>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001a\u0010C\u001a\u00020>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010@\"\u0004\bE\u0010BR\u001a\u0010F\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010#\"\u0004\bH\u0010%R*\u0010K\u001a\b\u0012\u0004\u0012\u00020J0I2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020J0I@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010MR\u001a\u0010N\u001a\u00020OX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010SR\u001a\u0010T\u001a\u00020UX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010W\"\u0004\bX\u0010Y\u00a8\u0006n"}, d2={"Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "Lcn/solarmoon/spark_core/util/TaskSubmitOffice;", "Lcom/jme3/bullet/PhysicsTickListener;", "name", "", "mcLevel", "Lnet/minecraft/world/level/Level;", "<init>", "(Ljava/lang/String;Lnet/minecraft/world/level/Level;)V", "getName", "()Ljava/lang/String;", "getMcLevel", "()Lnet/minecraft/world/level/Level;", "dispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "getDispatcher", "()Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "stateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcn/solarmoon/spark_core/physics/level/PhysicsLevelState;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "crashCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "tickCount", "", "getTickCount", "()I", "setTickCount", "(I)V", "physicsTickChannel", "Lkotlinx/coroutines/channels/Channel;", "", "stepCompletedChannel", "value", "Lcn/solarmoon/spark_core/physics/level/PhysicsWorld;", "world", "getWorld", "()Lcn/solarmoon/spark_core/physics/level/PhysicsWorld;", "hostManager", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcn/solarmoon/spark_core/physics/PhysicsHost;", "", "Lcom/jme3/bullet/collision/PhysicsCollisionObject;", "getHostManager", "()Ljava/util/concurrent/ConcurrentHashMap;", "taskMap", "Lcn/solarmoon/spark_core/util/PPhase;", "Lkotlin/Function0;", "getTaskMap", "immediateQueue", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "getImmediateQueue", "lastPhysicsTickTime", "", "getLastPhysicsTickTime", "()J", "setLastPhysicsTickTime", "(J)V", "lastStepTickTime", "getLastStepTickTime", "setLastStepTickTime", "overloadWarnCooldown", "getOverloadWarnCooldown", "setOverloadWarnCooldown", "", "Lnet/minecraft/world/entity/Entity;", "entities", "getEntities", "()Ljava/util/List;", "terrainManager", "Lcn/solarmoon/spark_core/physics/terrain/PhysicsChunkManager;", "getTerrainManager", "()Lcn/solarmoon/spark_core/physics/terrain/PhysicsChunkManager;", "setTerrainManager", "(Lcn/solarmoon/spark_core/physics/terrain/PhysicsChunkManager;)V", "blockShapeManager", "Lcn/solarmoon/spark_core/physics/terrain/BlockShapeManager;", "getBlockShapeManager", "()Lcn/solarmoon/spark_core/physics/terrain/BlockShapeManager;", "setBlockShapeManager", "(Lcn/solarmoon/spark_core/physics/terrain/BlockShapeManager;)V", "run", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "requestStep", "start", "onInitialized", "close", "restart", "prePhysicsTick", "space", "Lcom/jme3/bullet/PhysicsSpace;", "timeStep", "", "physicsTick", "handleException", "context", "Lkotlin/coroutines/CoroutineContext;", "exception", "", "requestEntities", "Companion", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nPhysicsLevel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicsLevel.kt\ncn/solarmoon/spark_core/physics/level/PhysicsLevel\n+ 2 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 InlineEventHandler.kt\ncn/solarmoon/spark_core/util/InlineEventHandlerKt\n*L\n1#1,241:1\n47#2,4:242\n1869#3:246\n1869#3,2:248\n1870#3:251\n1869#3:252\n1869#3,2:254\n1870#3:257\n1869#3,2:258\n1869#3:260\n1869#3,2:262\n1870#3:265\n24#4:247\n25#4:250\n24#4:253\n25#4:256\n24#4:261\n25#4:264\n*S KotlinDebug\n*F\n+ 1 PhysicsLevel.kt\ncn/solarmoon/spark_core/physics/level/PhysicsLevel\n*L\n45#1:242,4\n125#1:246\n126#1:248,2\n125#1:251\n205#1:252\n207#1:254,2\n205#1:257\n213#1:258,2\n219#1:260\n220#1:262,2\n219#1:265\n126#1:247\n126#1:250\n207#1:253\n207#1:256\n220#1:261\n220#1:264\n*E\n"})
public abstract class PhysicsLevel
implements AutoCloseable,
TaskSubmitOffice,
PhysicsTickListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Level mcLevel;
    @NotNull
    private final ExecutorCoroutineDispatcher dispatcher;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final MutableStateFlow<PhysicsLevelState> stateFlow;
    @NotNull
    private final StateFlow<PhysicsLevelState> state;
    @NotNull
    private final AtomicInteger crashCount;
    private int tickCount;
    @NotNull
    private final Channel<Unit> physicsTickChannel;
    @NotNull
    private final Channel<Unit> stepCompletedChannel;
    private PhysicsWorld world;
    @NotNull
    private final ConcurrentHashMap<PhysicsHost, Map<String, PhysicsCollisionObject>> hostManager;
    @NotNull
    private final ConcurrentHashMap<PPhase, ConcurrentHashMap<String, Function0<Unit>>> taskMap;
    @NotNull
    private final ConcurrentHashMap<PPhase, ConcurrentLinkedDeque<Function0<Unit>>> immediateQueue;
    private long lastPhysicsTickTime;
    private long lastStepTickTime;
    private int overloadWarnCooldown;
    @NotNull
    private List<? extends Entity> entities;
    public PhysicsChunkManager terrainManager;
    public BlockShapeManager blockShapeManager;
    public static final int TPS = 60;

    public PhysicsLevel(@NotNull String name, @NotNull Level mcLevel) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)mcLevel, (String)"mcLevel");
        this.name = name;
        this.mcLevel = mcLevel;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        this.dispatcher = ExecutorsKt.from((ExecutorService)executorService);
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key key = CoroutineExceptionHandler.Key;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)this.dispatcher.plus((CoroutineContext)new CoroutineName(this.name)).plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)).plus((CoroutineContext)new CoroutineExceptionHandler(key, this){
            final /* synthetic */ PhysicsLevel $receiver$inlined;
            {
                this.$receiver$inlined = physicsLevel;
                super((CoroutineContext.Key)$super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            public void handleException(CoroutineContext context, Throwable exception) {
                void p1;
                Throwable throwable = exception;
                CoroutineContext p0 = context;
                boolean $i$f$scope$stub_for_inlining = false;
                boolean bl = false;
                this.$receiver$inlined.handleException(p0, (Throwable)p1);
            }
        }));
        this.stateFlow = StateFlowKt.MutableStateFlow((Object)((Object)PhysicsLevelState.IDLE));
        this.state = FlowKt.asStateFlow(this.stateFlow);
        this.crashCount = new AtomicInteger(0);
        this.physicsTickChannel = ChannelKt.Channel$default((int)-1, null, null, (int)6, null);
        this.stepCompletedChannel = ChannelKt.Channel$default((int)-1, null, null, (int)6, null);
        this.hostManager = new ConcurrentHashMap();
        this.taskMap = new ConcurrentHashMap();
        this.immediateQueue = new ConcurrentHashMap();
        this.lastPhysicsTickTime = System.nanoTime();
        this.entities = CollectionsKt.emptyList();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public Level getMcLevel() {
        return this.mcLevel;
    }

    @NotNull
    public final ExecutorCoroutineDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @NotNull
    public final StateFlow<PhysicsLevelState> getState() {
        return this.state;
    }

    public final int getTickCount() {
        return this.tickCount;
    }

    public final void setTickCount(int n) {
        this.tickCount = n;
    }

    @NotNull
    public final PhysicsWorld getWorld() {
        PhysicsWorld physicsWorld = this.world;
        if (physicsWorld != null) {
            return physicsWorld;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"world");
        return null;
    }

    @NotNull
    public final ConcurrentHashMap<PhysicsHost, Map<String, PhysicsCollisionObject>> getHostManager() {
        return this.hostManager;
    }

    @Override
    @NotNull
    public ConcurrentHashMap<PPhase, ConcurrentHashMap<String, Function0<Unit>>> getTaskMap() {
        return this.taskMap;
    }

    @Override
    @NotNull
    public ConcurrentHashMap<PPhase, ConcurrentLinkedDeque<Function0<Unit>>> getImmediateQueue() {
        return this.immediateQueue;
    }

    public final long getLastPhysicsTickTime() {
        return this.lastPhysicsTickTime;
    }

    public final void setLastPhysicsTickTime(long l) {
        this.lastPhysicsTickTime = l;
    }

    public final long getLastStepTickTime() {
        return this.lastStepTickTime;
    }

    public final void setLastStepTickTime(long l) {
        this.lastStepTickTime = l;
    }

    public final int getOverloadWarnCooldown() {
        return this.overloadWarnCooldown;
    }

    public final void setOverloadWarnCooldown(int n) {
        this.overloadWarnCooldown = n;
    }

    @NotNull
    public final List<Entity> getEntities() {
        return this.entities;
    }

    @NotNull
    public final PhysicsChunkManager getTerrainManager() {
        PhysicsChunkManager physicsChunkManager = this.terrainManager;
        if (physicsChunkManager != null) {
            return physicsChunkManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"terrainManager");
        return null;
    }

    public final void setTerrainManager(@NotNull PhysicsChunkManager physicsChunkManager) {
        Intrinsics.checkNotNullParameter((Object)physicsChunkManager, (String)"<set-?>");
        this.terrainManager = physicsChunkManager;
    }

    @NotNull
    public final BlockShapeManager getBlockShapeManager() {
        BlockShapeManager blockShapeManager = this.blockShapeManager;
        if (blockShapeManager != null) {
            return blockShapeManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"blockShapeManager");
        return null;
    }

    public final void setBlockShapeManager(@NotNull BlockShapeManager blockShapeManager) {
        Intrinsics.checkNotNullParameter((Object)blockShapeManager, (String)"<set-?>");
        this.blockShapeManager = blockShapeManager;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object run(@NotNull CoroutineScope var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof run.1)) ** GOTO lbl-1000
        var11_3 = $completion;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                float F$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ PhysicsLevel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.run(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                fixedStep = 0.016666668f;
                repeat = 3;
lbl14:
                // 3 sources

                while (CoroutineScopeKt.isActive((CoroutineScope)$this$run)) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = $this$run;
                    $continuation.F$0 = fixedStep;
                    $continuation.I$0 = repeat;
                    $continuation.label = 1;
                    v0 = this.physicsTickChannel.receive((Continuation)$continuation);
                    if (v0 == var12_5) {
                        return var12_5;
                    }
                    ** GOTO lbl32
                }
                break;
            }
            case 1: {
                repeat = $continuation.I$0;
                fixedStep = $continuation.F$0;
                $this$run = (CoroutineScope)$continuation.L$1;
                this = (PhysicsLevel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                ticker = System.nanoTime();
                this.stateFlow.setValue((Object)PhysicsLevelState.RUNNING);
                for (var7_9 = 0; var7_9 < repeat; ++var7_9) {
                    $i$a$-repeat-PhysicsLevel$run$2 = false;
                    var9_11 = this.tickCount;
                    this.tickCount = var9_11 + 1;
                    this.getWorld().update(fixedStep, 0, false, true, false);
                }
                this.stateFlow.setValue((Object)PhysicsLevelState.IDLE);
                this.lastStepTickTime = System.nanoTime() - ticker;
                this.lastPhysicsTickTime = System.nanoTime();
                $continuation.L$0 = this;
                $continuation.L$1 = $this$run;
                $continuation.F$0 = fixedStep;
                $continuation.I$0 = repeat;
                $continuation.label = 2;
                v1 = this.stepCompletedChannel.send((Object)Unit.INSTANCE, (Continuation)$continuation);
                if (v1 != var12_5) ** GOTO lbl14
                return var12_5;
            }
            case 2: {
                repeat = $continuation.I$0;
                fixedStep = $continuation.F$0;
                $this$run = (CoroutineScope)$continuation.L$1;
                this = (PhysicsLevel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                ** GOTO lbl14
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    public final void requestStep() {
        if (this.world == null) {
            return;
        }
        this.entities = this.requestEntities();
        if (this.overloadWarnCooldown > 0) {
            int n = this.overloadWarnCooldown;
            this.overloadWarnCooldown = n + -1;
        }
        if (this.stateFlow.getValue() == PhysicsLevelState.RUNNING) {
            if (this.overloadWarnCooldown <= 0) {
                Object[] objectArray = new Object[]{this.name, (int)(this.lastStepTickTime / (long)1000000), this.getWorld().getPcoList().size(), this.getTerrainManager().getStats(), this.getMcLevel().getChunkSource().getLoadedChunksCount()};
                SparkCore.LOGGER.warn("{} overloaded, last tick time: {}ms, rigid body in world: {} with {}, while {} chunks loaded.", objectArray);
                this.overloadWarnCooldown = 40;
            }
            return;
        }
        List activationBoxes = new ArrayList();
        Collection<PhysicsCollisionObject> collection = this.getWorld().getPcoList();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getPcoList(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$triggerEvent$iv;
            PhysicsCollisionObject it = (PhysicsCollisionObject)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            InlineEventHandler inlineEventHandler = it;
            InlineEvent event$iv = PhysicsBodyEvent.Tick.INSTANCE;
            boolean $i$f$triggerEvent = false;
            List list = $this$triggerEvent$iv.getEventHandlers().get(Reflection.getOrCreateKotlinClass(PhysicsBodyEvent.Tick.class));
            if (list != null) {
                Iterable $this$forEach$iv$iv = list;
                boolean $i$f$forEach2 = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    InlineEventConsumer it$iv = (InlineEventConsumer)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it$iv, (String)"null cannot be cast to non-null type cn.solarmoon.spark_core.util.InlineEventConsumer<E of cn.solarmoon.spark_core.util.InlineEventHandlerKt.triggerEvent>");
                    it$iv.invoke(event$iv);
                }
            }
            PhysicsBodyExtensionKt.stateOf(it).update();
            PhysicsHost owner = PhysicsBodyExtensionKt.getOwner(it);
            if (it.isStatic() || owner instanceof PhysicsChunkSection || (it.getCollideWithGroups() & 1) == 0 || owner instanceof RigidBodyEntity && !((RigidBodyEntity)((Object)owner)).isActive().booleanValue()) continue;
            BoundingBox boundingBox = PhysicsBodyExtensionKt.stateOf(it).getCachedBoundingBox();
            Intrinsics.checkNotNullExpressionValue((Object)boundingBox, (String)"<get-cachedBoundingBox>(...)");
            AABB aabb = SparkMathKt.toAABB(boundingBox);
            if (it instanceof PhysicsRigidBody) {
                Vector3f vector3f = ((PhysicsRigidBody)it).getLinearVelocity(null);
                Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"getLinearVelocity(...)");
                Vec3 delta = SparkMathKt.toVec3(vector3f).scale(0.025);
                if (delta.length() < 5.0) {
                    aabb.expandTowards(delta);
                }
            }
            activationBoxes.add(aabb);
        }
        this.getTerrainManager().updateDirtySections();
        this.getTerrainManager().updateBuildAndActivation(activationBoxes);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ PhysicsLevel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = PhysicsLevel.access$getPhysicsTickChannel$p(this.this$0).send((Object)Unit.INSTANCE, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void start(@Nullable Function0<Unit> onInitialized) {
        PhysicsRigidBody.logger2.setLevel(java.util.logging.Level.WARNING);
        New6Dof.logger2.setLevel(java.util.logging.Level.WARNING);
        Object[] objectArray = new Object[]{this.name, Runtime.getRuntime().availableProcessors(), NativeLibrary.countThreads(), NativeLibrary.isThreadSafe()};
        SparkCore.LOGGER.info("\u542f\u52a8\u7269\u7406\u7ebf\u7a0b\uff1a{}\uff0c\u7ebf\u7a0b\u6570\uff1a{}/{}, threadSafe:{}", objectArray);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, onInitialized, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PhysicsLevel this$0;
            final /* synthetic */ Function0<Unit> $onInitialized;
            {
                this.this$0 = $receiver;
                this.$onInitialized = $onInitialized;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        PhysicsLevel.access$setWorld$p(this.this$0, new PhysicsWorld(this.this$0));
                        this.this$0.setTerrainManager(new PhysicsChunkManager(this.this$0));
                        this.this$0.setBlockShapeManager(new BlockShapeManager(this.this$0));
                        Function0<Unit> function0 = this.$onInitialized;
                        if (function0 != null) {
                            function0.invoke();
                        }
                        this.label = 1;
                        Object object3 = this.this$0.run($this$launch, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void start$default(PhysicsLevel physicsLevel, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: start");
        }
        if ((n & 1) != 0) {
            function0 = null;
        }
        physicsLevel.start((Function0<Unit>)function0);
    }

    @Override
    public void close() {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ PhysicsLevel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (this.this$0.terrainManager != null) {
                            this.this$0.getTerrainManager().destroy();
                        }
                        if (this.this$0.blockShapeManager != null) {
                            this.this$0.getBlockShapeManager().getSHAPE_CACHE().clear();
                            this.this$0.getBlockShapeManager().getSTATE_CACHE().clear();
                        }
                        if (PhysicsLevel.access$getWorld$p(this.this$0) != null) {
                            this.this$0.getWorld().destroy();
                        }
                        this.this$0.getHostManager().clear();
                        CoroutineScopeKt.cancel$default((CoroutineScope)this.this$0.getScope(), (String)"\u7269\u7406\u7ebf\u7a0b\u5df2\u5173\u95ed", null, (int)2, null);
                        this.this$0.getDispatcher().close();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public final void restart() {
        this.close();
        PhysicsLevel.start$default(this, null, 1, null);
        this.crashCount.set(0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void prePhysicsTick(@NotNull PhysicsSpace space, float timeStep) {
        Intrinsics.checkNotNullParameter((Object)space, (String)"space");
        Collection<PhysicsCollisionObject> collection = this.getWorld().getPcoList();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getPcoList(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$triggerEvent$iv;
            PhysicsCollisionObject pco = (PhysicsCollisionObject)element$iv;
            boolean bl = false;
            pco.isColliding = false;
            Intrinsics.checkNotNull((Object)pco);
            InlineEventHandler inlineEventHandler = pco;
            InlineEvent event$iv = new PhysicsBodyEvent.PhysicsTick.Pre();
            boolean $i$f$triggerEvent = false;
            List list = $this$triggerEvent$iv.getEventHandlers().get(Reflection.getOrCreateKotlinClass(PhysicsBodyEvent.PhysicsTick.Pre.class));
            if (list == null) continue;
            Iterable $this$forEach$iv$iv = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                InlineEventConsumer it$iv = (InlineEventConsumer)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it$iv, (String)"null cannot be cast to non-null type cn.solarmoon.spark_core.util.InlineEventConsumer<E of cn.solarmoon.spark_core.util.InlineEventHandlerKt.triggerEvent>");
                it$iv.invoke(event$iv);
            }
        }
        NeoForge.EVENT_BUS.post((Event)new PhysicsLevelTickEvent.Pre(this));
        this.processTasks(PPhase.ALL);
        this.processTasks(PPhase.PRE);
        $this$forEach$iv = this.entities;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            NeoForge.EVENT_BUS.post((Event)new PhysicsEntityTickEvent(it));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void physicsTick(@NotNull PhysicsSpace space, float timeStep) {
        Intrinsics.checkNotNullParameter((Object)space, (String)"space");
        Collection<PhysicsCollisionObject> collection = this.getWorld().getPcoList();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getPcoList(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$triggerEvent$iv;
            PhysicsCollisionObject pco = (PhysicsCollisionObject)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)pco);
            InlineEventHandler inlineEventHandler = pco;
            InlineEvent event$iv = new PhysicsBodyEvent.PhysicsTick.Post();
            boolean $i$f$triggerEvent = false;
            List list = $this$triggerEvent$iv.getEventHandlers().get(Reflection.getOrCreateKotlinClass(PhysicsBodyEvent.PhysicsTick.Post.class));
            if (list == null) continue;
            Iterable $this$forEach$iv$iv = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                InlineEventConsumer it$iv = (InlineEventConsumer)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it$iv, (String)"null cannot be cast to non-null type cn.solarmoon.spark_core.util.InlineEventConsumer<E of cn.solarmoon.spark_core.util.InlineEventHandlerKt.triggerEvent>");
                it$iv.invoke(event$iv);
            }
        }
        NeoForge.EVENT_BUS.post((Event)new PhysicsLevelTickEvent.Post(this));
        this.processTasks(PPhase.ALL);
        this.processTasks(PPhase.POST);
    }

    protected final void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        SparkCore.LOGGER.error("\u7269\u7406\u7ebf\u7a0b\u5d29\u6e83\uff01\u5c1d\u8bd5\u91cd\u542f...", exception);
        if (this.crashCount.incrementAndGet() < 3) {
            this.restart();
        } else {
            SparkCore.LOGGER.error("\u7269\u7406\u7ebf\u7a0b\u8fde\u7eed\u5d29\u6e83\uff0c\u505c\u6b62\u6062\u590d\uff01");
        }
    }

    @NotNull
    public abstract List<Entity> requestEntities();

    public static final /* synthetic */ Channel access$getPhysicsTickChannel$p(PhysicsLevel $this) {
        return $this.physicsTickChannel;
    }

    public static final /* synthetic */ void access$setWorld$p(PhysicsLevel $this, PhysicsWorld physicsWorld) {
        $this.world = physicsWorld;
    }

    public static final /* synthetic */ PhysicsWorld access$getWorld$p(PhysicsLevel $this) {
        return $this.world;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcn/solarmoon/spark_core/physics/level/PhysicsLevel$Companion;", "", "<init>", "()V", "TPS", "", "SparkCore-1.21.1-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

