/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.physics.level;

import cn.solarmoon.spark_core.event.PhysicsLevelInitEvent;
import cn.solarmoon.spark_core.physics.level.PhysicsLevel;
import cn.solarmoon.spark_core.physics.terrain.PhysicsChunkManager;
import cn.solarmoon.spark_core.util.PPhase;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.ChunkTicketLevelUpdatedEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0003J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0003J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0003J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0003J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fH\u0003J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0011H\u0003J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0013H\u0003\u00a8\u0006\u0014"}, d2={"Lcn/solarmoon/spark_core/physics/level/PhysicsLevelApplier;", "", "<init>", "()V", "load", "", "event", "Lnet/neoforged/neoforge/event/level/LevelEvent$Load;", "unLoad", "Lnet/neoforged/neoforge/event/level/LevelEvent$Unload;", "mainUpdate", "Lnet/neoforged/neoforge/event/tick/LevelTickEvent$Pre;", "mcLevelTask", "Lnet/neoforged/neoforge/event/tick/LevelTickEvent$Post;", "chunkLoad", "Lnet/neoforged/neoforge/event/level/ChunkEvent$Load;", "chunkUnload", "Lnet/neoforged/neoforge/event/level/ChunkEvent$Unload;", "chunkTicketUpdate", "Lnet/neoforged/neoforge/event/level/ChunkTicketLevelUpdatedEvent;", "SparkCore-1.21.1-neoforge"})
public final class PhysicsLevelApplier {
    @NotNull
    public static final PhysicsLevelApplier INSTANCE = new PhysicsLevelApplier();

    private PhysicsLevelApplier() {
    }

    @SubscribeEvent
    private final void load(LevelEvent.Load event) {
        LevelAccessor level = event.getLevel();
        if (level instanceof Level) {
            ((Level)level).getPhysicsLevel().start((Function0<Unit>)((Function0)() -> PhysicsLevelApplier.load$lambda$0(level)));
        }
    }

    @SubscribeEvent
    private final void unLoad(LevelEvent.Unload event) {
        LevelAccessor level = event.getLevel();
        if (level instanceof Level) {
            ((Level)level).getPhysicsLevel().close();
        }
    }

    @SubscribeEvent
    private final void mainUpdate(LevelTickEvent.Pre event) {
        event.getLevel().getPhysicsLevel().requestStep();
    }

    @SubscribeEvent
    private final void mcLevelTask(LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        level.processTasks(PPhase.ALL);
        level.processTasks(PPhase.PRE);
    }

    @SubscribeEvent
    private final void mcLevelTask(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        level.processTasks(PPhase.ALL);
        level.processTasks(PPhase.POST);
    }

    @SubscribeEvent
    private final void chunkLoad(ChunkEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        Intrinsics.checkNotNull((Object)levelAccessor, (String)"null cannot be cast to non-null type net.minecraft.world.level.Level");
        Level level = (Level)levelAccessor;
        PhysicsLevel physLevel = level.getPhysicsLevel();
        PhysicsChunkManager physicsChunkManager = physLevel.getTerrainManager();
        ChunkPos chunkPos = event.getChunk().getPos();
        Intrinsics.checkNotNullExpressionValue((Object)chunkPos, (String)"getPos(...)");
        ChunkAccess chunkAccess = event.getChunk();
        Intrinsics.checkNotNull((Object)chunkAccess, (String)"null cannot be cast to non-null type net.minecraft.world.level.chunk.LevelChunk");
        physicsChunkManager.onChunkLoaded(chunkPos, (LevelChunk)chunkAccess);
    }

    @SubscribeEvent
    private final void chunkUnload(ChunkEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        Intrinsics.checkNotNull((Object)levelAccessor, (String)"null cannot be cast to non-null type net.minecraft.world.level.Level");
        Level level = (Level)levelAccessor;
        PhysicsLevel physLevel = level.getPhysicsLevel();
        PhysicsChunkManager physicsChunkManager = physLevel.getTerrainManager();
        ChunkPos chunkPos = event.getChunk().getPos();
        Intrinsics.checkNotNullExpressionValue((Object)chunkPos, (String)"getPos(...)");
        physicsChunkManager.onChunkUnloaded(chunkPos);
    }

    @SubscribeEvent
    private final void chunkTicketUpdate(ChunkTicketLevelUpdatedEvent event) {
        ServerLevel serverLevel = event.getLevel();
        Intrinsics.checkNotNull((Object)serverLevel, (String)"null cannot be cast to non-null type net.minecraft.world.level.Level");
        Level level = (Level)serverLevel;
        PhysicsLevel physLevel = level.getPhysicsLevel();
        ChunkPos chunkPos = new ChunkPos(event.getChunkPos());
        if (event.getNewTicketLevel() > 33 && physLevel.getTickCount() > 0 && physLevel.getTerrainManager().loaded(chunkPos)) {
            physLevel.getTerrainManager().onChunkUnloaded(chunkPos);
        }
    }

    private static final Unit load$lambda$0(LevelAccessor $level) {
        NeoForge.EVENT_BUS.post((Event)new PhysicsLevelInitEvent(((Level)$level).getPhysicsLevel()));
        return Unit.INSTANCE;
    }
}

