/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.physics.level;

import cn.solarmoon.spark_core.event.NeedsCollisionEvent;
import cn.solarmoon.spark_core.event.PhysicsContactEvent;
import cn.solarmoon.spark_core.physics.body.ManifoldPoint;
import cn.solarmoon.spark_core.physics.body.PhysicsBodyEvent;
import cn.solarmoon.spark_core.physics.body.PhysicsBodyExtensionKt;
import cn.solarmoon.spark_core.physics.level.PhysicsLevel;
import cn.solarmoon.spark_core.util.InlineEvent;
import cn.solarmoon.spark_core.util.InlineEventConsumer;
import cn.solarmoon.spark_core.util.InlineEventHandler;
import com.jme3.bullet.CollisionConfiguration;
import com.jme3.bullet.PhysicsSoftSpace;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.math.Vector3f;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcn/solarmoon/spark_core/physics/level/PhysicsWorld;", "Lcom/jme3/bullet/PhysicsSoftSpace;", "level", "Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;", "<init>", "(Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;)V", "getLevel", "()Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;", "needsCollision", "", "pcoA", "Lcom/jme3/bullet/collision/PhysicsCollisionObject;", "pcoB", "onContactProcessed", "", "manifoldPointId", "", "addCollisionObject", "pco", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nPhysicsWorld.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicsWorld.kt\ncn/solarmoon/spark_core/physics/level/PhysicsWorld\n+ 2 InlineEventHandler.kt\ncn/solarmoon/spark_core/util/InlineEventHandlerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n24#2:78\n25#2:81\n24#2:82\n25#2:85\n24#2:86\n25#2:89\n1869#3,2:79\n1869#3,2:83\n1869#3,2:87\n*S KotlinDebug\n*F\n+ 1 PhysicsWorld.kt\ncn/solarmoon/spark_core/physics/level/PhysicsWorld\n*L\n64#1:78\n64#1:81\n67#1:82\n67#1:85\n74#1:86\n74#1:89\n64#1:79,2\n67#1:83,2\n74#1:87,2\n*E\n"})
public final class PhysicsWorld
extends PhysicsSoftSpace {
    @NotNull
    private final PhysicsLevel level;

    public PhysicsWorld(@NotNull PhysicsLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(new Vector3f(-2.1474836E9f, -1000.0f, -2.1474836E9f), new Vector3f(2.1474836E9f, 15000.0f, 2.1474836E9f), PhysicsSpace.BroadphaseType.DBVT, new CollisionConfiguration(8192, 0));
        this.level = level;
        this.setGravity(new Vector3f(0.0f, -9.81f, 0.0f));
        PhysicsBody.setDeactivationDeadline(3.0f);
        this.addTickListener(this.level);
        this.setForceUpdateAllAabbs(false);
        this.getSolverInfo().setMode(5028);
    }

    @NotNull
    public final PhysicsLevel getLevel() {
        return this.level;
    }

    @Override
    public boolean needsCollision(@NotNull PhysicsCollisionObject pcoA, @NotNull PhysicsCollisionObject pcoB) {
        Intrinsics.checkNotNullParameter((Object)pcoA, (String)"pcoA");
        Intrinsics.checkNotNullParameter((Object)pcoB, (String)"pcoB");
        if (pcoA.isStatic() && pcoB.isStatic()) {
            return false;
        }
        boolean r = true;
        if (PhysicsBodyExtensionKt.getOwner(pcoA) != null && PhysicsBodyExtensionKt.getOwner(pcoB) != null && Intrinsics.areEqual((Object)PhysicsBodyExtensionKt.getOwner(pcoA), (Object)PhysicsBodyExtensionKt.getOwner(pcoB)) && (pcoA.collideWithOwnerGroups & pcoB.collideWithOwnerGroups) == 0) {
            r = false;
        }
        return ((NeedsCollisionEvent)NeoForge.EVENT_BUS.post((Event)new NeedsCollisionEvent(pcoA, pcoB, r))).getShouldCollide();
    }

    @Override
    public void onContactProcessed(@NotNull PhysicsCollisionObject pcoA, @NotNull PhysicsCollisionObject pcoB, long manifoldPointId) {
        boolean bl;
        InlineEventConsumer it$iv;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv$iv;
        InlineEventHandler $this$triggerEvent$iv;
        Intrinsics.checkNotNullParameter((Object)pcoA, (String)"pcoA");
        Intrinsics.checkNotNullParameter((Object)pcoB, (String)"pcoB");
        ManifoldPoint o1Point = new ManifoldPoint(manifoldPointId, 0);
        ManifoldPoint o2Point = new ManifoldPoint(manifoldPointId, 1);
        pcoA.isColliding = true;
        InlineEventHandler inlineEventHandler = pcoA;
        InlineEvent event$iv = new PhysicsBodyEvent.Collide.Processed(pcoA, pcoB, o1Point, o2Point);
        boolean $i$f$triggerEvent = false;
        List list = $this$triggerEvent$iv.getEventHandlers().get(Reflection.getOrCreateKotlinClass(PhysicsBodyEvent.Collide.Processed.class));
        if (list != null) {
            $this$forEach$iv$iv = list;
            $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                it$iv = (InlineEventConsumer)element$iv$iv;
                bl = false;
                Intrinsics.checkNotNull((Object)it$iv, (String)"null cannot be cast to non-null type cn.solarmoon.spark_core.util.InlineEventConsumer<E of cn.solarmoon.spark_core.util.InlineEventHandlerKt.triggerEvent>");
                it$iv.invoke(event$iv);
            }
        }
        pcoB.isColliding = true;
        $this$triggerEvent$iv = pcoB;
        event$iv = new PhysicsBodyEvent.Collide.Processed(pcoB, pcoA, o2Point, o1Point);
        $i$f$triggerEvent = false;
        List list2 = $this$triggerEvent$iv.getEventHandlers().get(Reflection.getOrCreateKotlinClass(PhysicsBodyEvent.Collide.Processed.class));
        if (list2 != null) {
            $this$forEach$iv$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                it$iv = (InlineEventConsumer)element$iv$iv;
                bl = false;
                Intrinsics.checkNotNull((Object)it$iv, (String)"null cannot be cast to non-null type cn.solarmoon.spark_core.util.InlineEventConsumer<E of cn.solarmoon.spark_core.util.InlineEventHandlerKt.triggerEvent>");
                it$iv.invoke(event$iv);
            }
        }
        NeoForge.EVENT_BUS.post((Event)new PhysicsContactEvent.Process(pcoA, pcoB, o1Point, o2Point, manifoldPointId));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addCollisionObject(@NotNull PhysicsCollisionObject pco) {
        block1: {
            void $this$triggerEvent$iv;
            Intrinsics.checkNotNullParameter((Object)pco, (String)"pco");
            super.addCollisionObject(pco);
            InlineEventHandler inlineEventHandler = pco;
            InlineEvent event$iv = new PhysicsBodyEvent.AddToWorld();
            boolean $i$f$triggerEvent = false;
            List list = $this$triggerEvent$iv.getEventHandlers().get(Reflection.getOrCreateKotlinClass(PhysicsBodyEvent.AddToWorld.class));
            if (list == null) break block1;
            Iterable $this$forEach$iv$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                InlineEventConsumer it$iv = (InlineEventConsumer)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it$iv, (String)"null cannot be cast to non-null type cn.solarmoon.spark_core.util.InlineEventConsumer<E of cn.solarmoon.spark_core.util.InlineEventHandlerKt.triggerEvent>");
                it$iv.invoke(event$iv);
            }
        }
    }
}

