/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.physics.terrain;

import cn.solarmoon.spark_core.physics.level.PhysicsLevel;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\nJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\u000bJ\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcn/solarmoon/spark_core/physics/terrain/BlockShapeManager;", "", "physicsLevel", "Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;", "<init>", "(Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;)V", "getPhysicsLevel", "()Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;", "SHAPE_CACHE", "", "Lnet/minecraft/world/level/block/state/BlockState;", "Lcom/jme3/bullet/collision/shapes/CollisionShape;", "getSHAPE_CACHE", "()Ljava/util/Map;", "STATE_CACHE", "getSTATE_CACHE", "DEFAULT_SHAPE", "Lcom/jme3/bullet/collision/shapes/BoxCollisionShape;", "generateShapeCache", "blockState", "getCollisionShape", "state", "getBlockState", "shape", "convertVoxelToCollisionShape", "SparkCore-1.21.1-neoforge"})
public final class BlockShapeManager {
    @NotNull
    private final PhysicsLevel physicsLevel;
    @NotNull
    private final Map<BlockState, CollisionShape> SHAPE_CACHE;
    @NotNull
    private final Map<CollisionShape, BlockState> STATE_CACHE;
    @NotNull
    private final BoxCollisionShape DEFAULT_SHAPE;

    public BlockShapeManager(@NotNull PhysicsLevel physicsLevel) {
        Intrinsics.checkNotNullParameter((Object)physicsLevel, (String)"physicsLevel");
        this.physicsLevel = physicsLevel;
        this.SHAPE_CACHE = new ConcurrentHashMap();
        this.STATE_CACHE = new ConcurrentHashMap();
        this.DEFAULT_SHAPE = new BoxCollisionShape(0.5f);
    }

    @NotNull
    public final PhysicsLevel getPhysicsLevel() {
        return this.physicsLevel;
    }

    @NotNull
    public final Map<BlockState, CollisionShape> getSHAPE_CACHE() {
        return this.SHAPE_CACHE;
    }

    @NotNull
    public final Map<CollisionShape, BlockState> getSTATE_CACHE() {
        return this.STATE_CACHE;
    }

    private final CollisionShape generateShapeCache(BlockState blockState) {
        CollisionShape shape = this.convertVoxelToCollisionShape(blockState);
        return shape;
    }

    @NotNull
    public final CollisionShape getCollisionShape(@NotNull BlockState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        CollisionShape collisionShape = this.SHAPE_CACHE.computeIfAbsent(state2, arg_0 -> BlockShapeManager.getCollisionShape$lambda$1(arg_0 -> BlockShapeManager.getCollisionShape$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)collisionShape, (String)"computeIfAbsent(...)");
        return collisionShape;
    }

    @Nullable
    public final BlockState getBlockState(@NotNull CollisionShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return shape instanceof CompoundCollisionShape ? this.STATE_CACHE.get(((CompoundCollisionShape)shape).listChildren()[0].getShape()) : this.STATE_CACHE.get(shape);
    }

    private final CollisionShape convertVoxelToCollisionShape(BlockState blockState) {
        VoxelShape voxel = blockState.getCollisionShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO, CollisionContext.empty());
        try {
            AABB aabb = voxel.bounds();
            Vector3f halfExtents = new Vector3f((float)(aabb.getXsize() / (double)2), (float)(aabb.getYsize() / (double)2), (float)(aabb.getZsize() / (double)2));
            BoxCollisionShape box = new BoxCollisionShape(halfExtents);
            this.STATE_CACHE.put(box, blockState);
            if (aabb.getCenter().x == 0.5 && aabb.getCenter().y == 0.5 && aabb.getCenter().z == 0.5) {
                return box;
            }
            CompoundCollisionShape compound = new CompoundCollisionShape();
            Transform transform = new Transform(new Vector3f((float)aabb.getCenter().x - 0.5f, (float)aabb.getCenter().y - 0.5f, (float)aabb.getCenter().z - 0.5f), Quaternion.IDENTITY);
            compound.addChildShape((CollisionShape)box, transform);
            return compound;
        }
        catch (Exception e) {
            return this.DEFAULT_SHAPE;
        }
    }

    private static final CollisionShape getCollisionShape$lambda$0(BlockShapeManager this$0, BlockState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.generateShapeCache(it);
    }

    private static final CollisionShape getCollisionShape$lambda$1(Function1 $tmp0, Object p0) {
        return (CollisionShape)$tmp0.invoke(p0);
    }
}

