/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.physics.terrain;

import cn.solarmoon.spark_core.physics.level.PhysicsLevel;
import cn.solarmoon.spark_core.physics.terrain.PhysicsChunkSection;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0014\u0010\u0019\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0014\u0010\u001d\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0006\u0010\u001e\u001a\u00020\u0017J\u0006\u0010\u001f\u001a\u00020\u0017J\u0010\u0010 \u001a\u0004\u0018\u00010\u00132\u0006\u0010!\u001a\u00020\u0012J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0012J\u0006\u0010&\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcn/solarmoon/spark_core/physics/terrain/PhysicsChunk;", "", "chunkPos", "Lnet/minecraft/world/level/ChunkPos;", "physicsLevel", "Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;", "chunk", "Lnet/minecraft/world/level/chunk/LevelChunk;", "<init>", "(Lnet/minecraft/world/level/ChunkPos;Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;Lnet/minecraft/world/level/chunk/LevelChunk;)V", "getChunkPos", "()Lnet/minecraft/world/level/ChunkPos;", "getPhysicsLevel", "()Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;", "getChunk", "()Lnet/minecraft/world/level/chunk/LevelChunk;", "sections", "", "", "Lcn/solarmoon/spark_core/physics/terrain/PhysicsChunkSection;", "isLoaded", "", "load", "", "unload", "activateSectionsInRanges", "ranges", "", "Lkotlin/ranges/IntRange;", "deactivateSectionsInRanges", "activateAll", "deactivateAll", "getSection", "sectionY", "getSectionForBlockPos", "blockPos", "Lnet/minecraft/core/BlockPos;", "getActiveSectionCount", "getTotalSectionCount", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nPhysicsChunk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicsChunk.kt\ncn/solarmoon/spark_core/physics/terrain/PhysicsChunk\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1869#2,2:125\n1869#2:127\n1761#2,3:128\n1870#2:131\n1869#2:132\n1761#2,3:133\n1870#2:136\n1869#2,2:137\n1869#2,2:139\n1788#2,4:141\n*S KotlinDebug\n*F\n+ 1 PhysicsChunk.kt\ncn/solarmoon/spark_core/physics/terrain/PhysicsChunk\n*L\n50#1:125,2\n59#1:127\n61#1:128,3\n59#1:131\n78#1:132\n80#1:133,3\n78#1:136\n92#1:137,2\n99#1:139,2\n118#1:141,4\n*E\n"})
public final class PhysicsChunk {
    @NotNull
    private final ChunkPos chunkPos;
    @NotNull
    private final PhysicsLevel physicsLevel;
    @NotNull
    private final LevelChunk chunk;
    @NotNull
    private final Map<Integer, PhysicsChunkSection> sections;
    private boolean isLoaded;

    public PhysicsChunk(@NotNull ChunkPos chunkPos, @NotNull PhysicsLevel physicsLevel, @NotNull LevelChunk chunk) {
        Intrinsics.checkNotNullParameter((Object)chunkPos, (String)"chunkPos");
        Intrinsics.checkNotNullParameter((Object)physicsLevel, (String)"physicsLevel");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        this.chunkPos = chunkPos;
        this.physicsLevel = physicsLevel;
        this.chunk = chunk;
        this.sections = new LinkedHashMap();
    }

    @NotNull
    public final ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    @NotNull
    public final PhysicsLevel getPhysicsLevel() {
        return this.physicsLevel;
    }

    @NotNull
    public final LevelChunk getChunk() {
        return this.chunk;
    }

    public final void load() {
        if (this.isLoaded) {
            return;
        }
        int minSection = this.physicsLevel.getMcLevel().getMinSection();
        int maxSection = this.physicsLevel.getMcLevel().getMaxSection();
        for (int sectionY = minSection; sectionY < maxSection; ++sectionY) {
            SectionPos sectionPos = SectionPos.of((ChunkPos)this.chunkPos, (int)sectionY);
            Intrinsics.checkNotNull((Object)sectionPos);
            PhysicsChunkSection physicsSection = new PhysicsChunkSection(sectionPos, this.physicsLevel, this.chunk);
            physicsSection.startAsyncBuild(this.physicsLevel.getTerrainManager());
            Integer n = sectionY;
            this.sections.put(n, physicsSection);
        }
        this.isLoaded = true;
    }

    public final void unload() {
        Iterable $this$forEach$iv = this.sections.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PhysicsChunkSection it = (PhysicsChunkSection)element$iv;
            boolean bl = false;
            it.destroy();
        }
        this.sections.clear();
        this.isLoaded = false;
    }

    public final void activateSectionsInRanges(@NotNull List<IntRange> ranges) {
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        Iterable $this$forEach$iv = this.sections.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean shouldActivate;
            PhysicsChunkSection section;
            block5: {
                section = (PhysicsChunkSection)element$iv;
                boolean bl = false;
                int sectionY = section.getSectionPos().getY();
                Iterable $this$any$iv = ranges;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        IntRange range = (IntRange)element$iv2;
                        boolean bl2 = false;
                        int n = range.getFirst();
                        boolean bl3 = sectionY <= range.getLast() ? n <= sectionY : false;
                        if (!bl3) continue;
                        v0 = true;
                        break block5;
                    }
                    v0 = shouldActivate = false;
                }
            }
            if (shouldActivate) {
                section.activate();
                continue;
            }
            if (!section.isActive()) continue;
            section.deactivate();
        }
    }

    public final void deactivateSectionsInRanges(@NotNull List<IntRange> ranges) {
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        Iterable $this$forEach$iv = this.sections.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean shouldDeactivate;
            boolean bl;
            PhysicsChunkSection section;
            block4: {
                section = (PhysicsChunkSection)element$iv;
                boolean bl2 = false;
                int sectionY = section.getSectionPos().getY();
                Iterable $this$any$iv = ranges;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        IntRange range = (IntRange)element$iv2;
                        boolean bl3 = false;
                        int n = range.getFirst();
                        boolean bl4 = sectionY <= range.getLast() ? n <= sectionY : false;
                        if (!bl4) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!(shouldDeactivate = bl) || !section.isActive()) continue;
            section.deactivate();
        }
    }

    public final void activateAll() {
        Iterable $this$forEach$iv = this.sections.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PhysicsChunkSection it = (PhysicsChunkSection)element$iv;
            boolean bl = false;
            it.activate();
        }
    }

    public final void deactivateAll() {
        Iterable $this$forEach$iv = this.sections.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PhysicsChunkSection it = (PhysicsChunkSection)element$iv;
            boolean bl = false;
            it.deactivate();
        }
    }

    @Nullable
    public final PhysicsChunkSection getSection(int sectionY) {
        return this.sections.get(sectionY);
    }

    @Nullable
    public final PhysicsChunkSection getSectionForBlockPos(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        int sectionY = SectionPos.blockToSectionCoord((int)blockPos.getY());
        return this.sections.get(sectionY);
    }

    /*
     * WARNING - void declaration
     */
    public final int getActiveSectionCount() {
        int n;
        Iterable $this$count$iv = this.sections.values();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                PhysicsChunkSection it = (PhysicsChunkSection)element$iv;
                boolean bl = false;
                if (!(it.isActive() && !it.isEmpty()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    public final int getTotalSectionCount() {
        return this.sections.size();
    }
}

