/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.physics.terrain;

import cn.solarmoon.spark_core.SparkCore;
import cn.solarmoon.spark_core.physics.level.PhysicsLevel;
import cn.solarmoon.spark_core.physics.terrain.PhysicsChunk;
import cn.solarmoon.spark_core.physics.terrain.PhysicsChunkSection;
import cn.solarmoon.spark_core.physics.terrain.SectionSnapshot;
import cn.solarmoon.spark_core.physics.terrain.TerrainUpdatePayload;
import com.jme3.math.Vector3f;
import io.netty.util.internal.ConcurrentSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.SupervisorKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\u0014\u0010\"\u001a\u00020\u001e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0'2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u0016\u0010(\u001a\u00020\u001e2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\b0'H\u0002J\u0010\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-J\u0016\u0010.\u001a\u00020\u001e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u001c\u0010/\u001a\b\u0012\u0004\u0012\u0002000$2\f\u00101\u001a\b\u0012\u0004\u0012\u0002000'H\u0002J\u000e\u0010.\u001a\u00020\u001e2\u0006\u00102\u001a\u000203J\u0010\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020-J\u0016\u00107\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u000bJ\u000e\u00108\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bJ\u0014\u00109\u001a\u00020\u001e2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020-0'J\u0014\u0010;\u001a\u00020\u001e2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000e0'J\u0006\u0010=\u001a\u00020\u001eJ\u000e\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\bJ\u0006\u0010A\u001a\u00020BJ\u0006\u0010C\u001a\u00020\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006D"}, d2={"Lcn/solarmoon/spark_core/physics/terrain/PhysicsChunkManager;", "", "physicsLevel", "Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;", "<init>", "(Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;)V", "loadedChunks", "", "Lnet/minecraft/world/level/ChunkPos;", "Lcn/solarmoon/spark_core/physics/terrain/PhysicsChunk;", "mcLoadedChunks", "Lnet/minecraft/world/level/chunk/LevelChunk;", "dirtySections", "Lio/netty/util/internal/ConcurrentSet;", "Lnet/minecraft/core/SectionPos;", "terrainBuilderExecutor", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "terrainBuilderScope", "Lkotlinx/coroutines/CoroutineScope;", "getTerrainBuilderScope", "()Lkotlinx/coroutines/CoroutineScope;", "buildRadius", "", "activationRadius", "totalSections", "getTotalSections", "()I", "activeSections", "getActiveSections", "loadChunk", "", "chunkPos", "chunk", "unloadChunk", "updateBuildAndActivation", "boundingBoxes", "", "Lnet/minecraft/world/phys/AABB;", "collectChunksToBuild", "", "startBuildingChunks", "chunksToBuild", "getBlockSnapshotAt", "Lcn/solarmoon/spark_core/physics/terrain/SectionSnapshot$BlockSnapshot;", "worldPos", "Lnet/minecraft/core/BlockPos;", "updateActivation", "mergeRanges", "Lkotlin/ranges/IntRange;", "ranges", "focusPos", "Lcom/jme3/math/Vector3f;", "getSectionForBlockPos", "Lcn/solarmoon/spark_core/physics/terrain/PhysicsChunkSection;", "blockPos", "onChunkLoaded", "onChunkUnloaded", "onBlockUpdated", "blockPositions", "markDirtySections", "sections", "updateDirtySections", "loaded", "", "pos", "getStats", "", "destroy", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nPhysicsChunkManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicsChunkManager.kt\ncn/solarmoon/spark_core/physics/terrain/PhysicsChunkManager\n+ 2 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,349:1\n47#2,4:350\n1#3:354\n1869#4,2:355\n1869#4,2:357\n1869#4,2:359\n1869#4:361\n1870#4:369\n1869#4,2:370\n1056#4:372\n1869#4,2:373\n1869#4,2:375\n1869#4,2:377\n384#5,7:362\n*S KotlinDebug\n*F\n+ 1 PhysicsChunkManager.kt\ncn/solarmoon/spark_core/physics/terrain/PhysicsChunkManager\n*L\n45#1:350,4\n104#1:355,2\n133#1:357,2\n163#1:359,2\n171#1:361\n171#1:369\n196#1:370,2\n218#1:372\n277#1:373,2\n315#1:375,2\n341#1:377,2\n191#1:362,7\n*E\n"})
public final class PhysicsChunkManager {
    @NotNull
    private final PhysicsLevel physicsLevel;
    @NotNull
    private final Map<ChunkPos, PhysicsChunk> loadedChunks;
    @NotNull
    private final Map<ChunkPos, LevelChunk> mcLoadedChunks;
    @NotNull
    private final ConcurrentSet<SectionPos> dirtySections;
    @NotNull
    private final ExecutorCoroutineDispatcher terrainBuilderExecutor;
    @NotNull
    private final CoroutineScope terrainBuilderScope;
    private final int buildRadius;
    private final int activationRadius;

    public PhysicsChunkManager(@NotNull PhysicsLevel physicsLevel) {
        Intrinsics.checkNotNullParameter((Object)physicsLevel, (String)"physicsLevel");
        this.physicsLevel = physicsLevel;
        this.loadedChunks = new LinkedHashMap();
        this.mcLoadedChunks = new LinkedHashMap();
        this.dirtySections = new ConcurrentSet();
        ExecutorService executorService = Executors.newFixedThreadPool(RangesKt.coerceAtLeast((int)Runtime.getRuntime().availableProcessors(), (int)2), arg_0 -> PhysicsChunkManager.terrainBuilderExecutor$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newFixedThreadPool(...)");
        this.terrainBuilderExecutor = ExecutorsKt.from((ExecutorService)executorService);
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key key = CoroutineExceptionHandler.Key;
        this.terrainBuilderScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)this.terrainBuilderExecutor.plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)).plus((CoroutineContext)new CoroutineExceptionHandler(key){

            public void handleException(CoroutineContext context, Throwable exception) {
                Throwable exception2 = exception;
                boolean bl = false;
                SparkCore.LOGGER.error("\u5730\u5f62\u6784\u5efa\u7ebf\u7a0b\u5f02\u5e38", exception2);
            }
        }));
        this.buildRadius = 2;
        this.activationRadius = 8;
    }

    @NotNull
    public final CoroutineScope getTerrainBuilderScope() {
        return this.terrainBuilderScope;
    }

    /*
     * WARNING - void declaration
     */
    private final int getTotalSections() {
        Iterable iterable = this.loadedChunks.values();
        int n = 0;
        for (Object t : iterable) {
            void it;
            PhysicsChunk physicsChunk = (PhysicsChunk)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getTotalSectionCount();
            n = n2 + n3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final int getActiveSections() {
        Iterable iterable = this.loadedChunks.values();
        int n = 0;
        for (Object t : iterable) {
            void it;
            PhysicsChunk physicsChunk = (PhysicsChunk)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getActiveSectionCount();
            n = n2 + n3;
        }
        return n;
    }

    private final void loadChunk(ChunkPos chunkPos, LevelChunk chunk) {
        if (this.mcLoadedChunks.containsKey(chunkPos)) {
            return;
        }
        this.mcLoadedChunks.put(chunkPos, chunk);
    }

    private final void unloadChunk(ChunkPos chunkPos) {
        this.mcLoadedChunks.remove(chunkPos);
        PhysicsChunk physicsChunk = this.loadedChunks.get(chunkPos);
        if (physicsChunk == null) {
            return;
        }
        PhysicsChunk chunk = physicsChunk;
        CollectionsKt.removeAll((Iterable)((Iterable)this.dirtySections), arg_0 -> PhysicsChunkManager.unloadChunk$lambda$4(chunkPos, arg_0));
        chunk.unload();
        this.loadedChunks.remove(chunkPos);
    }

    public final void updateBuildAndActivation(@NotNull List<? extends AABB> boundingBoxes) {
        Intrinsics.checkNotNullParameter(boundingBoxes, (String)"boundingBoxes");
        Set<ChunkPos> chunksToBuild = this.collectChunksToBuild(boundingBoxes);
        this.startBuildingChunks(chunksToBuild);
        this.updateActivation(boundingBoxes);
    }

    private final Set<ChunkPos> collectChunksToBuild(List<? extends AABB> boundingBoxes) {
        Set chunksToBuild = new LinkedHashSet();
        Iterable $this$forEach$iv = boundingBoxes;
        boolean $i$f$forEach = false;
        block0: for (Object element$iv : $this$forEach$iv) {
            AABB aabb = (AABB)element$iv;
            boolean bl = false;
            int minY = SectionPos.blockToSectionCoord((int)((int)aabb.minY));
            int maxY = SectionPos.blockToSectionCoord((int)((int)aabb.maxY));
            if (minY > this.physicsLevel.getMcLevel().getMaxSection() + 1 || maxY < this.physicsLevel.getMcLevel().getMinSection() - 1) continue;
            int minBuildX = SectionPos.blockToSectionCoord((int)((int)aabb.minX)) - this.buildRadius;
            int maxBuildX = SectionPos.blockToSectionCoord((int)((int)aabb.maxX)) + this.buildRadius;
            int minBuildZ = SectionPos.blockToSectionCoord((int)((int)aabb.minZ)) - this.buildRadius;
            int maxBuildZ = SectionPos.blockToSectionCoord((int)((int)aabb.maxZ)) + this.buildRadius;
            int chunkX = minBuildX;
            if (chunkX > maxBuildX) continue;
            while (true) {
                int chunkZ;
                if ((chunkZ = minBuildZ) <= maxBuildZ) {
                    while (true) {
                        ChunkPos chunkPos;
                        if (this.mcLoadedChunks.containsKey(chunkPos = new ChunkPos(chunkX, chunkZ))) {
                            chunksToBuild.add(chunkPos);
                        }
                        if (chunkZ == maxBuildZ) break;
                        ++chunkZ;
                    }
                }
                if (chunkX == maxBuildX) continue block0;
                ++chunkX;
            }
        }
        return chunksToBuild;
    }

    private final void startBuildingChunks(Set<? extends ChunkPos> chunksToBuild) {
        Iterable $this$forEach$iv = chunksToBuild;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LevelChunk mcChunk;
            ChunkPos chunkPos = (ChunkPos)element$iv;
            boolean bl = false;
            if (this.loadedChunks.containsKey(chunkPos) || this.mcLoadedChunks.get(chunkPos) == null) continue;
            PhysicsChunk chunk = new PhysicsChunk(chunkPos, this.physicsLevel, mcChunk);
            chunk.load();
            this.loadedChunks.put(chunkPos, chunk);
        }
    }

    @Nullable
    public final SectionSnapshot.BlockSnapshot getBlockSnapshotAt(@NotNull BlockPos worldPos) {
        Intrinsics.checkNotNullParameter((Object)worldPos, (String)"worldPos");
        PhysicsChunkSection physicsChunkSection = this.getSectionForBlockPos(worldPos);
        if (physicsChunkSection == null) {
            return null;
        }
        PhysicsChunkSection section = physicsChunkSection;
        return section.getBlockSnapshot(worldPos);
    }

    private final void updateActivation(List<? extends AABB> boundingBoxes) {
        if (boundingBoxes.isEmpty()) {
            Iterable $this$forEach$iv = this.loadedChunks.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PhysicsChunk it = (PhysicsChunk)element$iv;
                boolean bl = false;
                it.deactivateAll();
            }
            return;
        }
        Map activationMap = new LinkedHashMap();
        Iterable $this$forEach$iv = boundingBoxes;
        boolean $i$f$forEach = false;
        block1: for (Object element$iv : $this$forEach$iv) {
            AABB aabb = (AABB)element$iv;
            boolean bl = false;
            int minY = SectionPos.blockToSectionCoord((int)((int)(aabb.minY - (double)this.activationRadius)));
            int maxY = SectionPos.blockToSectionCoord((int)((int)(aabb.maxY + (double)this.activationRadius)));
            if (minY > this.physicsLevel.getMcLevel().getMaxSection() || maxY < this.physicsLevel.getMcLevel().getMinSection()) continue;
            int minChunkX = SectionPos.blockToSectionCoord((int)((int)(aabb.minX - (double)this.activationRadius)));
            int maxChunkX = SectionPos.blockToSectionCoord((int)((int)(aabb.maxX + (double)this.activationRadius)));
            int minChunkZ = SectionPos.blockToSectionCoord((int)((int)(aabb.minZ - (double)this.activationRadius)));
            int maxChunkZ = SectionPos.blockToSectionCoord((int)((int)(aabb.maxZ + (double)this.activationRadius)));
            int minSectionY = SectionPos.blockToSectionCoord((int)((int)(aabb.minY - (double)this.activationRadius)));
            int maxSectionY = SectionPos.blockToSectionCoord((int)((int)(aabb.maxY + (double)this.activationRadius)));
            IntRange sectionRange = new IntRange(minSectionY, maxSectionY);
            int chunkX = minChunkX;
            if (chunkX > maxChunkX) continue;
            while (true) {
                int chunkZ;
                if ((chunkZ = minChunkZ) <= maxChunkZ) {
                    while (true) {
                        Object object;
                        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
                        Map $this$getOrPut$iv = activationMap;
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(chunkPos);
                        if (value$iv == null) {
                            boolean bl2 = false;
                            Set answer$iv = new LinkedHashSet();
                            $this$getOrPut$iv.put(chunkPos, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        ((Set)object).add(sectionRange);
                        if (chunkZ == maxChunkZ) break;
                        ++chunkZ;
                    }
                }
                if (chunkX == maxChunkX) continue block1;
                ++chunkX;
            }
        }
        $this$forEach$iv = this.loadedChunks.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PhysicsChunk chunk = (PhysicsChunk)element$iv;
            boolean bl = false;
            ChunkPos chunkPos = chunk.getChunkPos();
            Set activationRanges = (Set)activationMap.get(chunkPos);
            Collection minChunkX = activationRanges;
            if (!(minChunkX == null || minChunkX.isEmpty())) {
                List<IntRange> mergedRanges = this.mergeRanges(activationRanges);
                chunk.activateSectionsInRanges(mergedRanges);
                continue;
            }
            chunk.deactivateAll();
        }
    }

    private final List<IntRange> mergeRanges(Set<IntRange> ranges) {
        if (ranges.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$sortedBy$iv = ranges;
        boolean $i$f$sortedBy = false;
        List sortedRanges = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IntRange it = (IntRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getFirst());
                it = (IntRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getFirst()));
            }
        });
        List merged = new ArrayList();
        IntRange currentRange = (IntRange)CollectionsKt.first((List)sortedRanges);
        for (IntRange range : CollectionsKt.drop((Iterable)sortedRanges, (int)1)) {
            if (range.getFirst() <= currentRange.getLast() + 1) {
                currentRange = new IntRange(currentRange.getFirst(), Math.max(currentRange.getLast(), range.getLast()));
                continue;
            }
            merged.add(currentRange);
            currentRange = range;
        }
        merged.add(currentRange);
        return merged;
    }

    public final void updateActivation(@NotNull Vector3f focusPos) {
        Intrinsics.checkNotNullParameter((Object)focusPos, (String)"focusPos");
        double halfSize = 16.0;
        AABB aabb = new AABB((double)focusPos.x - halfSize, (double)focusPos.y - halfSize, (double)focusPos.z - halfSize, (double)focusPos.x + halfSize, (double)focusPos.y + halfSize, (double)focusPos.z + halfSize);
        this.updateActivation(CollectionsKt.listOf((Object)aabb));
    }

    @Nullable
    public final PhysicsChunkSection getSectionForBlockPos(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        ChunkPos chunkPos = new ChunkPos(blockPos);
        PhysicsChunk physicsChunk = this.loadedChunks.get(chunkPos);
        return physicsChunk != null ? physicsChunk.getSectionForBlockPos(blockPos) : null;
    }

    public final void onChunkLoaded(@NotNull ChunkPos chunkPos, @NotNull LevelChunk chunk) {
        Intrinsics.checkNotNullParameter((Object)chunkPos, (String)"chunkPos");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        this.loadChunk(chunkPos, chunk);
    }

    public final void onChunkUnloaded(@NotNull ChunkPos chunkPos) {
        Intrinsics.checkNotNullParameter((Object)chunkPos, (String)"chunkPos");
        this.unloadChunk(chunkPos);
    }

    public final void onBlockUpdated(@NotNull Set<? extends BlockPos> blockPositions) {
        Intrinsics.checkNotNullParameter(blockPositions, (String)"blockPositions");
        Set dirtySections = new LinkedHashSet();
        Iterable $this$forEach$iv = blockPositions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockPos blockPos = (BlockPos)element$iv;
            boolean bl = false;
            SectionPos sectionPos = SectionPos.of((BlockPos)blockPos);
            Intrinsics.checkNotNull((Object)sectionPos);
            dirtySections.add(sectionPos);
        }
        this.markDirtySections(dirtySections);
    }

    public final void markDirtySections(@NotNull Set<? extends SectionPos> sections) {
        Intrinsics.checkNotNullParameter(sections, (String)"sections");
        this.dirtySections.addAll((Collection)sections);
    }

    public final void updateDirtySections() {
        if (this.dirtySections.isEmpty()) {
            return;
        }
        Set sectionsToUpdate = CollectionsKt.toSet((Iterable)((Iterable)this.dirtySections));
        this.dirtySections.clear();
        if (!this.physicsLevel.getMcLevel().isClientSide && !((Collection)sectionsToUpdate).isEmpty()) {
            Level level = this.physicsLevel.getMcLevel();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            PacketDistributor.sendToPlayersInDimension((ServerLevel)((ServerLevel)level), (CustomPacketPayload)new TerrainUpdatePayload(sectionsToUpdate), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        Iterable $this$forEach$iv = sectionsToUpdate;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PhysicsChunkSection physicsSection;
            int sectionY;
            PhysicsChunk physicsChunk;
            SectionPos sectionPos = (SectionPos)element$iv;
            boolean bl = false;
            ChunkPos chunkPos = new ChunkPos(sectionPos.x(), sectionPos.z());
            if (this.loadedChunks.get(chunkPos) == null || physicsChunk.getSection(sectionY = sectionPos.y()) == null) continue;
            physicsSection.startAsyncUpdate(this);
        }
    }

    public final boolean loaded(@NotNull ChunkPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.loadedChunks.containsKey(pos);
    }

    @NotNull
    public final String getStats() {
        return "\u7269\u7406\u533a\u5757: " + this.loadedChunks.size() + ", Section\u603b\u6570: " + this.getTotalSections() + ", \u6d3b\u8dc3Section: " + this.getActiveSections();
    }

    public final void destroy() {
        block1: {
            Iterable $this$forEach$iv = this.loadedChunks.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PhysicsChunk it = (PhysicsChunk)element$iv;
                boolean bl = false;
                it.unload();
            }
            this.loadedChunks.clear();
            CoroutineScopeKt.cancel$default((CoroutineScope)this.terrainBuilderScope, null, (int)1, null);
            Executor executor = this.terrainBuilderExecutor.getExecutor();
            ExecutorService executorService = executor instanceof ExecutorService ? (ExecutorService)executor : null;
            if (executorService == null) break block1;
            executorService.shutdownNow();
        }
    }

    private static final Thread terrainBuilderExecutor$lambda$0(PhysicsChunkManager this$0, Runnable r) {
        return new Thread(r, "TerrainShapeBuilder-" + this$0.physicsLevel.getName());
    }

    private static final boolean unloadChunk$lambda$4(ChunkPos $chunkPos, SectionPos it) {
        return Intrinsics.areEqual((Object)it, (Object)$chunkPos);
    }
}

