/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.physics.terrain;

import cn.solarmoon.spark_core.SparkCore;
import cn.solarmoon.spark_core.physics.PhysicsHost;
import cn.solarmoon.spark_core.physics.body.PhysicsBodyExtensionKt;
import cn.solarmoon.spark_core.physics.level.PhysicsLevel;
import cn.solarmoon.spark_core.physics.terrain.BlockShapeManagerKt;
import cn.solarmoon.spark_core.physics.terrain.PhysicsChunkManager;
import cn.solarmoon.spark_core.physics.terrain.SectionSnapshot;
import cn.solarmoon.spark_core.util.TaskSubmitOffice;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.lang.invoke.LambdaMetafactory;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jme3utilities.math.MyMath;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Job;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001CB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001e0&2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020\u001eH\u0002J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\b\u0010/\u001a\u00020\u001eH\u0002J\u0006\u00100\u001a\u00020+J\u0006\u00101\u001a\u00020\u001eJ\u0006\u00102\u001a\u00020\u001eJ\u0006\u00103\u001a\u00020+J\u0006\u00104\u001a\u00020+J\u0010\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u000208J\u0010\u00109\u001a\u0004\u0018\u00010:2\u0006\u00107\u001a\u000208J\u000e\u0010;\u001a\u0002082\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020+2\u0006\u00107\u001a\u000208J\u000e\u0010?\u001a\u00020\u001e2\u0006\u00107\u001a\u000208J\u0006\u0010@\u001a\u00020+J\b\u0010A\u001a\u00020+H\u0002J\u0006\u0010B\u001a\u00020\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcn/solarmoon/spark_core/physics/terrain/PhysicsChunkSection;", "Lcn/solarmoon/spark_core/physics/PhysicsHost;", "sectionPos", "Lnet/minecraft/core/SectionPos;", "physicsLevel", "Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;", "chunk", "Lnet/minecraft/world/level/chunk/LevelChunk;", "<init>", "(Lnet/minecraft/core/SectionPos;Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;Lnet/minecraft/world/level/chunk/LevelChunk;)V", "getSectionPos", "()Lnet/minecraft/core/SectionPos;", "getPhysicsLevel", "()Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;", "getChunk", "()Lnet/minecraft/world/level/chunk/LevelChunk;", "snapshotForBuild", "Lcn/solarmoon/spark_core/physics/terrain/SectionSnapshot;", "snapshotForCollision", "collisionShape", "Lcom/jme3/bullet/collision/shapes/CompoundCollisionShape;", "physicsBody", "Lcom/jme3/bullet/objects/PhysicsRigidBody;", "allPhysicsBodies", "", "", "Lcom/jme3/bullet/collision/PhysicsCollisionObject;", "getAllPhysicsBodies", "()Ljava/util/Map;", "value", "", "isActive", "()Z", "buildState", "Lcn/solarmoon/spark_core/physics/terrain/PhysicsChunkSection$BuildState;", "buildJob", "Lkotlinx/coroutines/Job;", "buildCollisionShapeAsync", "Lkotlinx/coroutines/Deferred;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "buildCollisionShape", "startAsyncBuild", "", "manager", "Lcn/solarmoon/spark_core/physics/terrain/PhysicsChunkManager;", "startAsyncUpdate", "createPhysicsBody", "cancelBuild", "isBuilding", "isBuilt", "activate", "deactivate", "getBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "worldPos", "Lnet/minecraft/core/BlockPos;", "getBlockSnapshot", "Lcn/solarmoon/spark_core/physics/terrain/SectionSnapshot$BlockSnapshot;", "getBlockPosForChildShape", "childIndex", "", "markRemoved", "isRemoved", "destroy", "destroyPhysicsBody", "isEmpty", "BuildState", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nPhysicsChunkSection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicsChunkSection.kt\ncn/solarmoon/spark_core/physics/terrain/PhysicsChunkSection\n+ 2 SectionSnapshot.kt\ncn/solarmoon/spark_core/physics/terrain/SectionSnapshot\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,342:1\n206#2,10:343\n1#3:353\n*S KotlinDebug\n*F\n+ 1 PhysicsChunkSection.kt\ncn/solarmoon/spark_core/physics/terrain/PhysicsChunkSection\n*L\n97#1:343,10\n*E\n"})
public final class PhysicsChunkSection
implements PhysicsHost {
    @NotNull
    private final SectionPos sectionPos;
    @NotNull
    private final PhysicsLevel physicsLevel;
    @NotNull
    private final LevelChunk chunk;
    @Nullable
    private SectionSnapshot snapshotForBuild;
    @Nullable
    private SectionSnapshot snapshotForCollision;
    @Nullable
    private CompoundCollisionShape collisionShape;
    @Nullable
    private PhysicsRigidBody physicsBody;
    @NotNull
    private final Map<String, PhysicsCollisionObject> allPhysicsBodies;
    private boolean isActive;
    @NotNull
    private BuildState buildState;
    @Nullable
    private Job buildJob;

    public PhysicsChunkSection(@NotNull SectionPos sectionPos, @NotNull PhysicsLevel physicsLevel, @NotNull LevelChunk chunk) {
        Intrinsics.checkNotNullParameter((Object)sectionPos, (String)"sectionPos");
        Intrinsics.checkNotNullParameter((Object)physicsLevel, (String)"physicsLevel");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        this.sectionPos = sectionPos;
        this.physicsLevel = physicsLevel;
        this.chunk = chunk;
        this.allPhysicsBodies = new LinkedHashMap();
        this.buildState = BuildState.IDLE;
    }

    @NotNull
    public final SectionPos getSectionPos() {
        return this.sectionPos;
    }

    @Override
    @NotNull
    public PhysicsLevel getPhysicsLevel() {
        return this.physicsLevel;
    }

    @NotNull
    public final LevelChunk getChunk() {
        return this.chunk;
    }

    @Override
    @NotNull
    public Map<String, PhysicsCollisionObject> getAllPhysicsBodies() {
        return this.allPhysicsBodies;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    private final Deferred<Boolean> buildCollisionShapeAsync(CoroutineScope scope) {
        return BuildersKt.async$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, null){
            int label;
            final /* synthetic */ PhysicsChunkSection this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean bl;
                        ResultKt.throwOnFailure((Object)object);
                        if (PhysicsChunkSection.access$getBuildState$p(this.this$0) == BuildState.BUILDING) {
                            return Boxing.boxBoolean((boolean)false);
                        }
                        PhysicsChunkSection.access$setBuildState$p(this.this$0, BuildState.BUILDING);
                        try {
                            boolean result = PhysicsChunkSection.access$buildCollisionShape(this.this$0);
                            PhysicsChunkSection.access$setBuildState$p(this.this$0, result ? BuildState.BUILT : BuildState.IDLE);
                        }
                        catch (Exception e) {
                            PhysicsChunkSection.access$setBuildState$p(this.this$0, BuildState.FAILED);
                            SparkCore.LOGGER.error("\u6784\u5efasection " + this.this$0.getSectionPos() + " \u78b0\u649e\u5f62\u72b6\u5931\u8d25", (Throwable)e);
                            bl = false;
                        }
                        return Boxing.boxBoolean((bl ? 1 : 0) != 0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean buildCollisionShape() {
        CompoundCollisionShape compoundShape = new CompoundCollisionShape();
        boolean hasCollision = false;
        SectionSnapshot snapshot = this.snapshotForBuild;
        if (snapshot == null) {
            this.collisionShape = null;
            return false;
        }
        SectionSnapshot this_$iv = snapshot;
        boolean $i$f$forEachBlock = false;
        if (!this_$iv.isEmpty()) {
            Iterator<Integer> iterator = this_$iv.getChildShapeIndexes().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<Integer> iterator2 = iterator;
            while (iterator2.hasNext()) {
                void blockSnapshot;
                Integer n = iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"next(...)");
                int index$iv = ((Number)n).intValue();
                SectionSnapshot.BlockSnapshot snapshot$iv = this_$iv.getBlockSnapshots()[index$iv];
                if (snapshot$iv == null) continue;
                BlockPos relativePos$iv = SectionSnapshot.Companion.getRelativePosFromIndex(index$iv);
                SectionSnapshot.BlockSnapshot blockSnapshot2 = snapshot$iv;
                BlockPos blockPos = relativePos$iv;
                boolean bl = false;
                CollisionShape blockShape = BlockShapeManagerKt.getBulletCollisionShape(blockSnapshot.getState(), this.getPhysicsLevel());
                Vector3f relativePos = new Vector3f((float)blockPos.getX() + 0.5f - 8.0f, (float)blockPos.getY() + 0.5f - 8.0f, (float)blockPos.getZ() + 0.5f - 8.0f);
                if (blockShape instanceof CompoundCollisionShape) {
                    Object[] children = ((CompoundCollisionShape)blockShape).listChildren();
                    Iterator iterator3 = ArrayIteratorKt.iterator((Object[])children);
                    while (iterator3.hasNext()) {
                        ChildCollisionShape childShape = (ChildCollisionShape)iterator3.next();
                        CollisionShape shape = childShape.getShape();
                        Transform childTransform = childShape.copyTransform(null);
                        Transform combinedTransform = MyMath.combine(new Transform(relativePos, Quaternion.IDENTITY), childTransform, null);
                        compoundShape.addChildShape(shape, combinedTransform);
                    }
                } else {
                    compoundShape.addChildShape(blockShape, new Transform(relativePos, Quaternion.IDENTITY));
                }
                hasCollision = true;
            }
        }
        if (hasCollision) {
            this.collisionShape = compoundShape;
            return true;
        }
        return false;
    }

    public final void startAsyncBuild(@NotNull PhysicsChunkManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Job job = this.buildJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.snapshotForBuild = SectionSnapshot.Companion.snapshotFromChunk(this.getPhysicsLevel().getMcLevel(), this.chunk, this.sectionPos);
        this.buildJob = BuildersKt.launch$default((CoroutineScope)manager.getTerrainBuilderScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PhysicsChunkSection this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        this.label = 1;
                        v0 = PhysicsChunkSection.access$buildCollisionShapeAsync(this.this$0, $this$launch).await((Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        if (buildResult = ((Boolean)v0).booleanValue()) {
                            TaskSubmitOffice.submitImmediateTask$default(this.this$0.getPhysicsLevel(), null, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(cn.solarmoon.spark_core.physics.terrain.PhysicsChunkSection ), ()Lkotlin/Unit;)((PhysicsChunkSection)this.this$0), 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(PhysicsChunkSection this$0) {
                PhysicsChunkSection.access$createPhysicsBody(this$0);
                return Unit.INSTANCE;
            }
        }), (int)3, null);
    }

    public final void startAsyncUpdate(@NotNull PhysicsChunkManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Job job = this.buildJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.snapshotForBuild = SectionSnapshot.Companion.snapshotFromChunk(this.getPhysicsLevel().getMcLevel(), this.chunk, this.sectionPos);
        this.buildJob = BuildersKt.launch$default((CoroutineScope)manager.getTerrainBuilderScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            boolean Z$0;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PhysicsChunkSection this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        wasActive = CoroutineScopeKt.isActive((CoroutineScope)$this$launch);
                        hadBody = PhysicsChunkSection.access$getPhysicsBody$p(this.this$0) != null ? 1 : 0;
                        this.Z$0 = wasActive;
                        this.I$0 = hadBody;
                        this.label = 1;
                        v0 = PhysicsChunkSection.access$buildCollisionShapeAsync(this.this$0, $this$launch).await((Continuation)this);
                        if (v0 == var12_2) {
                            return var12_2;
                        }
                        ** GOTO lbl20
                    }
                    case 1: {
                        hadBody = this.I$0;
                        wasActive = this.Z$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl20:
                        // 2 sources

                        if (hasCollisionNow = ((Boolean)v0).booleanValue()) {
                            if (hadBody != 0) {
                                v1 = PhysicsChunkSection.access$getPhysicsBody$p(this.this$0);
                                if (v1 != null) {
                                    var6_7 = v1;
                                    var7_8 = this.this$0;
                                    body = var6_7;
                                    $i$a$-let-PhysicsChunkSection$startAsyncUpdate$1$1 = false;
                                    v2 = PhysicsChunkSection.access$getCollisionShape$p(var7_8);
                                    if (v2 != null) {
                                        newShape = v2;
                                        $i$a$-let-PhysicsChunkSection$startAsyncUpdate$1$1$1 = false;
                                        TaskSubmitOffice.submitImmediateTask$default(var7_8.getPhysicsLevel(), null, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$2$lambda$1$lambda$0(cn.solarmoon.spark_core.physics.terrain.PhysicsChunkSection com.jme3.bullet.objects.PhysicsRigidBody com.jme3.bullet.collision.shapes.CompoundCollisionShape ), ()Lkotlin/Unit;)((PhysicsChunkSection)var7_8, (PhysicsRigidBody)body, (CompoundCollisionShape)newShape), 1, null);
                                    }
                                }
                            } else {
                                TaskSubmitOffice.submitImmediateTask$default(this.this$0.getPhysicsLevel(), null, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$3(cn.solarmoon.spark_core.physics.terrain.PhysicsChunkSection boolean ), ()Lkotlin/Unit;)((PhysicsChunkSection)this.this$0, (boolean)(wasActive != false)), 1, null);
                            }
                        } else if (hadBody != 0) {
                            TaskSubmitOffice.submitImmediateTask$default(this.this$0.getPhysicsLevel(), null, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$4(cn.solarmoon.spark_core.physics.terrain.PhysicsChunkSection ), ()Lkotlin/Unit;)((PhysicsChunkSection)this.this$0), 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$2$lambda$1$lambda$0(PhysicsChunkSection this$0, PhysicsRigidBody $body, CompoundCollisionShape $newShape) {
                SectionSnapshot sectionSnapshot = PhysicsChunkSection.access$getSnapshotForBuild$p(this$0);
                PhysicsChunkSection.access$setSnapshotForCollision$p(this$0, sectionSnapshot != null ? sectionSnapshot.copy() : null);
                $body.setCollisionShape($newShape);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$3(PhysicsChunkSection this$0, boolean $wasActive) {
                PhysicsChunkSection.access$createPhysicsBody(this$0);
                if ($wasActive) {
                    this$0.activate();
                }
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$4(PhysicsChunkSection this$0) {
                PhysicsChunkSection.access$destroyPhysicsBody(this$0);
                return Unit.INSTANCE;
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean createPhysicsBody() {
        void $this$createPhysicsBody_u24lambda_u241;
        PhysicsRigidBody physicsRigidBody;
        CompoundCollisionShape compoundCollisionShape = this.collisionShape;
        if (compoundCollisionShape == null) {
            return false;
        }
        CompoundCollisionShape shape = compoundCollisionShape;
        SectionSnapshot sectionSnapshot = this.snapshotForBuild;
        this.snapshotForCollision = sectionSnapshot != null ? sectionSnapshot.copy() : null;
        PhysicsRigidBody physicsRigidBody2 = physicsRigidBody = new PhysicsRigidBody(shape, 0.0f);
        PhysicsChunkSection physicsChunkSection = this;
        boolean bl = false;
        $this$createPhysicsBody_u24lambda_u241.name = "section_" + this.sectionPos;
        PhysicsBodyExtensionKt.setOwner((PhysicsCollisionObject)$this$createPhysicsBody_u24lambda_u241, (PhysicsHost)this.getPhysicsLevel().getMcLevel());
        physicsChunkSection.physicsBody = physicsRigidBody;
        PhysicsRigidBody physicsRigidBody3 = this.physicsBody;
        Intrinsics.checkNotNull((Object)physicsRigidBody3);
        physicsRigidBody3.setPhysicsLocation(new Vector3f((float)this.sectionPos.minBlockX() + 8.0f, (float)this.sectionPos.minBlockY() + 8.0f, (float)this.sectionPos.minBlockZ() + 8.0f));
        PhysicsRigidBody physicsRigidBody4 = this.physicsBody;
        Intrinsics.checkNotNull((Object)physicsRigidBody4);
        physicsRigidBody4.setCollisionGroup(1);
        PhysicsRigidBody physicsRigidBody5 = this.physicsBody;
        Intrinsics.checkNotNull((Object)physicsRigidBody5);
        physicsRigidBody5.setCollideWithGroups(0);
        return true;
    }

    public final void cancelBuild() {
        Job job = this.buildJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.buildJob = null;
        if (this.buildState == BuildState.BUILDING) {
            this.buildState = BuildState.IDLE;
        }
    }

    public final boolean isBuilding() {
        return this.buildState == BuildState.BUILDING;
    }

    public final boolean isBuilt() {
        return this.buildState == BuildState.BUILT;
    }

    public final void activate() {
        if (this.isActive || this.physicsBody == null) {
            return;
        }
        PhysicsRigidBody physicsRigidBody = this.physicsBody;
        Intrinsics.checkNotNull((Object)physicsRigidBody);
        if (physicsRigidBody.isInWorld()) {
            this.isActive = true;
            return;
        }
        Level level = this.getPhysicsLevel().getMcLevel();
        PhysicsRigidBody physicsRigidBody2 = this.physicsBody;
        Intrinsics.checkNotNull((Object)physicsRigidBody2);
        PhysicsBodyExtensionKt.addPhysicsBody(level, physicsRigidBody2);
        this.isActive = true;
    }

    public final void deactivate() {
        if (!this.isActive || this.physicsBody == null) {
            this.isActive = false;
            return;
        }
        PhysicsRigidBody physicsRigidBody = this.physicsBody;
        Intrinsics.checkNotNull((Object)physicsRigidBody);
        if (!physicsRigidBody.isInWorld()) {
            this.isActive = false;
            return;
        }
        Level level = this.getPhysicsLevel().getMcLevel();
        PhysicsRigidBody physicsRigidBody2 = this.physicsBody;
        Intrinsics.checkNotNull((Object)physicsRigidBody2);
        PhysicsBodyExtensionKt.removePhysicsBody(level, physicsRigidBody2);
        this.isActive = false;
    }

    @Nullable
    public final BlockState getBlockState(@NotNull BlockPos worldPos) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)worldPos, (String)"worldPos");
                if (this.isEmpty() || this.snapshotForCollision == null) break block3;
                SectionSnapshot sectionSnapshot = this.snapshotForCollision;
                boolean bl = sectionSnapshot != null ? sectionSnapshot.isEmpty() : false;
                if (!bl) break block4;
            }
            return null;
        }
        SectionSnapshot.BlockSnapshot blockSnapshot = this.getBlockSnapshot(worldPos);
        return blockSnapshot != null ? blockSnapshot.getState() : null;
    }

    @Nullable
    public final SectionSnapshot.BlockSnapshot getBlockSnapshot(@NotNull BlockPos worldPos) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)worldPos, (String)"worldPos");
                if (this.isEmpty() || this.snapshotForCollision == null) break block3;
                SectionSnapshot sectionSnapshot = this.snapshotForCollision;
                boolean bl = sectionSnapshot != null ? sectionSnapshot.isEmpty() : false;
                if (!bl) break block4;
            }
            return null;
        }
        SectionSnapshot sectionSnapshot = this.snapshotForCollision;
        Intrinsics.checkNotNull((Object)sectionSnapshot);
        return sectionSnapshot.getBlockSnapshotFromWorld(worldPos);
    }

    @NotNull
    public final BlockPos getBlockPosForChildShape(int childIndex) {
        block5: {
            block4: {
                if (childIndex < 0 || childIndex >= 4096) {
                    throw new IndexOutOfBoundsException("childIndex out of range, should be in [0, 4095]");
                }
                if (this.snapshotForCollision == null) break block4;
                SectionSnapshot sectionSnapshot = this.snapshotForCollision;
                boolean bl = sectionSnapshot != null ? sectionSnapshot.isEmpty() : false;
                if (!bl) break block5;
            }
            throw new NullPointerException("snapshotForCollision is null or empty");
        }
        SectionSnapshot sectionSnapshot = this.snapshotForCollision;
        Intrinsics.checkNotNull((Object)sectionSnapshot);
        return sectionSnapshot.getWorldPos(childIndex);
    }

    public final void markRemoved(@NotNull BlockPos worldPos) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)worldPos, (String)"worldPos");
                if (this.isEmpty() || this.snapshotForCollision == null) break block4;
                SectionSnapshot sectionSnapshot = this.snapshotForCollision;
                boolean bl = sectionSnapshot != null ? sectionSnapshot.isEmpty() : false;
                if (!bl) break block5;
            }
            return;
        }
        if (this.isRemoved(worldPos)) {
            return;
        }
        SectionSnapshot sectionSnapshot = this.snapshotForCollision;
        Intrinsics.checkNotNull((Object)sectionSnapshot);
        BlockPos pos = sectionSnapshot.getRelativePos(worldPos);
        int index = SectionSnapshot.Companion.getIndexFromRelativePos(pos.getX(), pos.getY(), pos.getZ());
        SectionSnapshot sectionSnapshot2 = this.snapshotForCollision;
        Intrinsics.checkNotNull((Object)sectionSnapshot2);
        sectionSnapshot2.getBlockSnapshots()[index] = null;
    }

    public final boolean isRemoved(@NotNull BlockPos worldPos) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)worldPos, (String)"worldPos");
                if (this.isEmpty() || this.snapshotForCollision == null) break block3;
                SectionSnapshot sectionSnapshot = this.snapshotForCollision;
                boolean bl = sectionSnapshot != null ? sectionSnapshot.isEmpty() : false;
                if (!bl) break block4;
            }
            return true;
        }
        SectionSnapshot sectionSnapshot = this.snapshotForCollision;
        Intrinsics.checkNotNull((Object)sectionSnapshot);
        return sectionSnapshot.getBlockSnapshotFromWorld(worldPos) == null;
    }

    public final void destroy() {
        this.cancelBuild();
        this.destroyPhysicsBody();
        this.snapshotForBuild = null;
        this.snapshotForCollision = null;
    }

    private final void destroyPhysicsBody() {
        PhysicsRigidBody physicsRigidBody = this.physicsBody;
        if (physicsRigidBody != null) {
            PhysicsRigidBody it = physicsRigidBody;
            boolean bl = false;
            if (it.isInWorld()) {
                PhysicsBodyExtensionKt.removePhysicsBody(this.getPhysicsLevel().getMcLevel(), it);
            }
        }
        this.collisionShape = null;
        this.isActive = false;
    }

    public final boolean isEmpty() {
        return this.collisionShape == null;
    }

    public static final /* synthetic */ BuildState access$getBuildState$p(PhysicsChunkSection $this) {
        return $this.buildState;
    }

    public static final /* synthetic */ void access$setBuildState$p(PhysicsChunkSection $this, BuildState buildState) {
        $this.buildState = buildState;
    }

    public static final /* synthetic */ boolean access$buildCollisionShape(PhysicsChunkSection $this) {
        return $this.buildCollisionShape();
    }

    public static final /* synthetic */ Deferred access$buildCollisionShapeAsync(PhysicsChunkSection $this, CoroutineScope scope) {
        return $this.buildCollisionShapeAsync(scope);
    }

    public static final /* synthetic */ boolean access$createPhysicsBody(PhysicsChunkSection $this) {
        return $this.createPhysicsBody();
    }

    public static final /* synthetic */ PhysicsRigidBody access$getPhysicsBody$p(PhysicsChunkSection $this) {
        return $this.physicsBody;
    }

    public static final /* synthetic */ void access$setSnapshotForCollision$p(PhysicsChunkSection $this, SectionSnapshot sectionSnapshot) {
        $this.snapshotForCollision = sectionSnapshot;
    }

    public static final /* synthetic */ SectionSnapshot access$getSnapshotForBuild$p(PhysicsChunkSection $this) {
        return $this.snapshotForBuild;
    }

    public static final /* synthetic */ CompoundCollisionShape access$getCollisionShape$p(PhysicsChunkSection $this) {
        return $this.collisionShape;
    }

    public static final /* synthetic */ void access$destroyPhysicsBody(PhysicsChunkSection $this) {
        $this.destroyPhysicsBody();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcn/solarmoon/spark_core/physics/terrain/PhysicsChunkSection$BuildState;", "", "<init>", "(Ljava/lang/String;I)V", "IDLE", "BUILDING", "BUILT", "FAILED", "SparkCore-1.21.1-neoforge"})
    public static final class BuildState
    extends Enum<BuildState> {
        public static final /* enum */ BuildState IDLE = new BuildState();
        public static final /* enum */ BuildState BUILDING = new BuildState();
        public static final /* enum */ BuildState BUILT = new BuildState();
        public static final /* enum */ BuildState FAILED = new BuildState();
        private static final /* synthetic */ BuildState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static BuildState[] values() {
            return (BuildState[])$VALUES.clone();
        }

        public static BuildState valueOf(String value) {
            return Enum.valueOf(BuildState.class, value);
        }

        @NotNull
        public static EnumEntries<BuildState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = buildStateArray = new BuildState[]{BuildState.IDLE, BuildState.BUILDING, BuildState.BUILT, BuildState.FAILED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

