/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.physics.terrain;

import cn.solarmoon.spark_core.util.BlockCollisionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0002()B9\b\u0002\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0007J \u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0015J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001f\u001a\u00020\u0015J\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\u0007J&\u0010#\u001a\u00020$2\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020$0&H\u0086\b\u00f8\u0001\u0000J\u0006\u0010'\u001a\u00020\u0000R\u001b\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006*"}, d2={"Lcn/solarmoon/spark_core/physics/terrain/SectionSnapshot;", "", "blockSnapshots", "", "Lcn/solarmoon/spark_core/physics/terrain/SectionSnapshot$BlockSnapshot;", "childShapeIndexes", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "pos", "Lnet/minecraft/core/SectionPos;", "<init>", "([Lcn/solarmoon/spark_core/physics/terrain/SectionSnapshot$BlockSnapshot;Ljava/util/ArrayList;Lnet/minecraft/core/SectionPos;)V", "getBlockSnapshots", "()[Lcn/solarmoon/spark_core/physics/terrain/SectionSnapshot$BlockSnapshot;", "[Lcn/solarmoon/spark_core/physics/terrain/SectionSnapshot$BlockSnapshot;", "getChildShapeIndexes", "()Ljava/util/ArrayList;", "getPos", "()Lnet/minecraft/core/SectionPos;", "getRelativePos", "Lnet/minecraft/core/BlockPos;", "blockPos", "getWorldPos", "relativePos", "childShapeIndex", "getBlockSnapshot", "relativeX", "relativeY", "relativeZ", "getBlockSnapshotFromWorld", "worldPos", "isEmpty", "", "getBlockCount", "forEachBlock", "", "action", "Lkotlin/Function2;", "copy", "Companion", "BlockSnapshot", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nSectionSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SectionSnapshot.kt\ncn/solarmoon/spark_core/physics/terrain/SectionSnapshot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,220:1\n1#2:221\n12797#3,3:222\n*S KotlinDebug\n*F\n+ 1 SectionSnapshot.kt\ncn/solarmoon/spark_core/physics/terrain/SectionSnapshot\n*L\n199#1:222,3\n*E\n"})
public final class SectionSnapshot {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockSnapshot[] blockSnapshots;
    @NotNull
    private final ArrayList<Integer> childShapeIndexes;
    @NotNull
    private final SectionPos pos;
    @NotNull
    private static final SectionSnapshot EMPTY;

    private SectionSnapshot(BlockSnapshot[] blockSnapshots, ArrayList<Integer> childShapeIndexes, SectionPos pos) {
        this.blockSnapshots = blockSnapshots;
        this.childShapeIndexes = childShapeIndexes;
        this.pos = pos;
    }

    @NotNull
    public final BlockSnapshot[] getBlockSnapshots() {
        return this.blockSnapshots;
    }

    @NotNull
    public final ArrayList<Integer> getChildShapeIndexes() {
        return this.childShapeIndexes;
    }

    @NotNull
    public final SectionPos getPos() {
        return this.pos;
    }

    @NotNull
    public final BlockPos getRelativePos(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        BlockPos blockPos2 = blockPos.subtract((Vec3i)this.pos.origin());
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"subtract(...)");
        return blockPos2;
    }

    @NotNull
    public final BlockPos getWorldPos(@NotNull BlockPos relativePos) {
        Intrinsics.checkNotNullParameter((Object)relativePos, (String)"relativePos");
        BlockPos blockPos = relativePos.offset((Vec3i)this.pos.origin());
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
        return blockPos;
    }

    @NotNull
    public final BlockPos getRelativePos(int childShapeIndex) {
        if (!(0 <= childShapeIndex ? childShapeIndex < 4096 : false)) {
            boolean $i$a$-require-SectionSnapshot$getRelativePos$22 = false;
            String $i$a$-require-SectionSnapshot$getRelativePos$22 = "Index must be in range 0-4095, got " + childShapeIndex;
            throw new IllegalArgumentException($i$a$-require-SectionSnapshot$getRelativePos$22.toString());
        }
        Integer n = this.childShapeIndexes.get(childShapeIndex);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
        int index = ((Number)n).intValue();
        int x = index & 0xF;
        int y = index >> 4 & 0xF;
        int z = index >> 8 & 0xF;
        return new BlockPos(x, y, z);
    }

    @NotNull
    public final BlockPos getWorldPos(int childShapeIndex) {
        if (!(0 <= childShapeIndex ? childShapeIndex < 4096 : false)) {
            boolean bl = false;
            String string = "Index must be in range 0-4095, got " + childShapeIndex;
            throw new IllegalArgumentException(string.toString());
        }
        BlockPos relPos = this.getRelativePos(childShapeIndex);
        return this.getWorldPos(relPos);
    }

    @Nullable
    public final BlockSnapshot getBlockSnapshot(int relativeX, int relativeY, int relativeZ) {
        return this.blockSnapshots[Companion.getIndexFromRelativePos(relativeX, relativeY, relativeZ)];
    }

    @Nullable
    public final BlockSnapshot getBlockSnapshot(@NotNull BlockPos relativePos) {
        Intrinsics.checkNotNullParameter((Object)relativePos, (String)"relativePos");
        return this.getBlockSnapshot(relativePos.getX(), relativePos.getY(), relativePos.getZ());
    }

    @Nullable
    public final BlockSnapshot getBlockSnapshotFromWorld(@NotNull BlockPos worldPos) {
        Intrinsics.checkNotNullParameter((Object)worldPos, (String)"worldPos");
        BlockPos relativePos = this.getRelativePos(worldPos);
        return this.getBlockSnapshot(relativePos);
    }

    public final boolean isEmpty() {
        return this == EMPTY;
    }

    /*
     * WARNING - void declaration
     */
    public final int getBlockCount() {
        void var3_3;
        if (this.isEmpty()) {
            return 0;
        }
        BlockSnapshot[] $this$count$iv = this.blockSnapshots;
        boolean $i$f$count = false;
        int count$iv = 0;
        int n = $this$count$iv.length;
        for (int i = 0; i < n; ++i) {
            BlockSnapshot element$iv;
            BlockSnapshot it = element$iv = $this$count$iv[i];
            boolean bl = false;
            if (!(it != null)) continue;
            ++count$iv;
        }
        return (int)var3_3;
    }

    public final void forEachBlock(@NotNull Function2<? super BlockPos, ? super BlockSnapshot, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$forEachBlock = false;
        if (this.isEmpty()) {
            return;
        }
        Iterator<Integer> iterator = this.getChildShapeIndexes().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Integer> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Integer n = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"next(...)");
            int index = ((Number)n).intValue();
            BlockSnapshot snapshot = this.getBlockSnapshots()[index];
            if (snapshot == null) continue;
            BlockPos relativePos = Companion.getRelativePosFromIndex(index);
            action.invoke((Object)relativePos, (Object)snapshot);
        }
    }

    @NotNull
    public final SectionSnapshot copy() {
        return new SectionSnapshot((BlockSnapshot[])this.blockSnapshots.clone(), new ArrayList<Integer>((Collection)this.childShapeIndexes), this.pos);
    }

    @NotNull
    public static final SectionSnapshot getEMPTY() {
        return Companion.getEMPTY();
    }

    @JvmStatic
    @NotNull
    public static final SectionSnapshot snapshotFromChunk(@NotNull Level level, @NotNull LevelChunk chunk, @NotNull SectionPos pos) {
        return Companion.snapshotFromChunk(level, chunk, pos);
    }

    @JvmStatic
    public static final int getIndexFromRelativePos(int x, int y, int z) {
        return Companion.getIndexFromRelativePos(x, y, z);
    }

    @JvmStatic
    @NotNull
    public static final BlockPos getRelativePosFromIndex(int index) {
        return Companion.getRelativePosFromIndex(index);
    }

    @JvmStatic
    @NotNull
    public static final BlockPos getWorldPos(@NotNull SectionPos sectionPos, int relativeX, int relativeY, int relativeZ) {
        return Companion.getWorldPos(sectionPos, relativeX, relativeY, relativeZ);
    }

    public /* synthetic */ SectionSnapshot(BlockSnapshot[] blockSnapshots, ArrayList childShapeIndexes, SectionPos pos, DefaultConstructorMarker $constructor_marker) {
        this(blockSnapshots, childShapeIndexes, pos);
    }

    static {
        int n = 0;
        BlockSnapshot[] blockSnapshotArray = new BlockSnapshot[1];
        while (n < 1) {
            int n2 = n++;
            blockSnapshotArray[n2] = null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
        SectionPos sectionPos = SectionPos.of((int)0, (int)Integer.MIN_VALUE, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)sectionPos, (String)"of(...)");
        SectionPos sectionPos2 = sectionPos;
        ArrayList<Integer> arrayList2 = arrayList;
        BlockSnapshot[] blockSnapshotArray2 = blockSnapshotArray;
        EMPTY = new SectionSnapshot(blockSnapshotArray2, arrayList2, sectionPos2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J;\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcn/solarmoon/spark_core/physics/terrain/SectionSnapshot$BlockSnapshot;", "", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "friction", "", "rollingFriction", "restitution", "slip", "<init>", "(Lnet/minecraft/world/level/block/state/BlockState;FFFF)V", "getState", "()Lnet/minecraft/world/level/block/state/BlockState;", "getFriction", "()F", "getRollingFriction", "getRestitution", "getSlip", "setSlip", "(F)V", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "SparkCore-1.21.1-neoforge"})
    public static final class BlockSnapshot {
        @NotNull
        private final BlockState state;
        private final float friction;
        private final float rollingFriction;
        private final float restitution;
        private float slip;

        public BlockSnapshot(@NotNull BlockState state2, float friction, float rollingFriction, float restitution, float slip) {
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            this.state = state2;
            this.friction = friction;
            this.rollingFriction = rollingFriction;
            this.restitution = restitution;
            this.slip = slip;
        }

        @NotNull
        public final BlockState getState() {
            return this.state;
        }

        public final float getFriction() {
            return this.friction;
        }

        public final float getRollingFriction() {
            return this.rollingFriction;
        }

        public final float getRestitution() {
            return this.restitution;
        }

        public final float getSlip() {
            return this.slip;
        }

        public final void setSlip(float f) {
            this.slip = f;
        }

        @NotNull
        public final BlockState component1() {
            return this.state;
        }

        public final float component2() {
            return this.friction;
        }

        public final float component3() {
            return this.rollingFriction;
        }

        public final float component4() {
            return this.restitution;
        }

        public final float component5() {
            return this.slip;
        }

        @NotNull
        public final BlockSnapshot copy(@NotNull BlockState state2, float friction, float rollingFriction, float restitution, float slip) {
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            return new BlockSnapshot(state2, friction, rollingFriction, restitution, slip);
        }

        public static /* synthetic */ BlockSnapshot copy$default(BlockSnapshot blockSnapshot, BlockState blockState, float f, float f2, float f3, float f4, int n, Object object) {
            if ((n & 1) != 0) {
                blockState = blockSnapshot.state;
            }
            if ((n & 2) != 0) {
                f = blockSnapshot.friction;
            }
            if ((n & 4) != 0) {
                f2 = blockSnapshot.rollingFriction;
            }
            if ((n & 8) != 0) {
                f3 = blockSnapshot.restitution;
            }
            if ((n & 0x10) != 0) {
                f4 = blockSnapshot.slip;
            }
            return blockSnapshot.copy(blockState, f, f2, f3, f4);
        }

        @NotNull
        public String toString() {
            return "BlockSnapshot(state=" + this.state + ", friction=" + this.friction + ", rollingFriction=" + this.rollingFriction + ", restitution=" + this.restitution + ", slip=" + this.slip + ")";
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = result * 31 + Float.hashCode(this.friction);
            result = result * 31 + Float.hashCode(this.rollingFriction);
            result = result * 31 + Float.hashCode(this.restitution);
            result = result * 31 + Float.hashCode(this.slip);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlockSnapshot)) {
                return false;
            }
            BlockSnapshot blockSnapshot = (BlockSnapshot)other;
            if (!Intrinsics.areEqual((Object)this.state, (Object)blockSnapshot.state)) {
                return false;
            }
            if (Float.compare(this.friction, blockSnapshot.friction) != 0) {
                return false;
            }
            if (Float.compare(this.rollingFriction, blockSnapshot.rollingFriction) != 0) {
                return false;
            }
            if (Float.compare(this.restitution, blockSnapshot.restitution) != 0) {
                return false;
            }
            return Float.compare(this.slip, blockSnapshot.slip) == 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0007J(\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0011H\u0007R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"Lcn/solarmoon/spark_core/physics/terrain/SectionSnapshot$Companion;", "", "<init>", "()V", "EMPTY", "Lcn/solarmoon/spark_core/physics/terrain/SectionSnapshot;", "getEMPTY$annotations", "getEMPTY", "()Lcn/solarmoon/spark_core/physics/terrain/SectionSnapshot;", "snapshotFromChunk", "level", "Lnet/minecraft/world/level/Level;", "chunk", "Lnet/minecraft/world/level/chunk/LevelChunk;", "pos", "Lnet/minecraft/core/SectionPos;", "getIndexFromRelativePos", "", "x", "y", "z", "getRelativePosFromIndex", "Lnet/minecraft/core/BlockPos;", "index", "getWorldPos", "sectionPos", "relativeX", "relativeY", "relativeZ", "SparkCore-1.21.1-neoforge"})
    @SourceDebugExtension(value={"SMAP\nSectionSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SectionSnapshot.kt\ncn/solarmoon/spark_core/physics/terrain/SectionSnapshot$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n1#2:221\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SectionSnapshot getEMPTY() {
            return EMPTY;
        }

        @JvmStatic
        public static /* synthetic */ void getEMPTY$annotations() {
        }

        @JvmStatic
        @NotNull
        public final SectionSnapshot snapshotFromChunk(@NotNull Level level, @NotNull LevelChunk chunk, @NotNull SectionPos pos) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            int sectionIndex = level.getSectionIndexFromSectionY(pos.y());
            if (sectionIndex < 0 || sectionIndex >= chunk.getSections().length) {
                return this.getEMPTY();
            }
            LevelChunkSection section = chunk.getSections()[sectionIndex];
            if (section == null || section.hasOnlyAir()) {
                return this.getEMPTY();
            }
            BlockSnapshot[] blockSnapshots = new BlockSnapshot[4096];
            ArrayList<Integer> childShapeIndex = new ArrayList<Integer>(16);
            boolean hasBlocks = false;
            int i = 0;
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        int index = this.getIndexFromRelativePos(x, y, z);
                        BlockState blockState = section.getBlockState(x, y, z);
                        if (blockState.isAir() || blockState.getCollisionShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO).isEmpty()) continue;
                        Intrinsics.checkNotNull((Object)blockState);
                        blockSnapshots[index] = new BlockSnapshot(blockState, BlockCollisionUtil.getBlockFriction(chunk.getLevel(), blockState, this.getWorldPos(pos, x, y, z)), BlockCollisionUtil.getBlockRollingFriction(chunk.getLevel(), blockState, this.getWorldPos(pos, x, y, z)), BlockCollisionUtil.getRestitution((ChunkAccess)chunk, blockState, this.getWorldPos(pos, x, y, z)), BlockCollisionUtil.getSlip((ChunkAccess)chunk, blockState, this.getWorldPos(pos, x, y, z)));
                        childShapeIndex.add(index);
                        hasBlocks = true;
                        ++i;
                    }
                }
            }
            return hasBlocks ? new SectionSnapshot(blockSnapshots, childShapeIndex, pos, null) : this.getEMPTY();
        }

        /*
         * Unable to fully structure code
         */
        @JvmStatic
        public final int getIndexFromRelativePos(int x, int y, int z) {
            v0 = 0 <= x ? x < 16 : false;
            if (!v0) ** GOTO lbl-1000
            v1 = 0 <= y ? y < 16 : false;
            if (!v1) ** GOTO lbl-1000
            v2 = 0 <= z ? z < 16 : false;
            if (v2) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = false;
            }
            if (!v3) {
                $i$a$-require-SectionSnapshot$Companion$getIndexFromRelativePos$1 = false;
                var4_5 = "Coordinates must be in range 0-15, got x=" + x + ", y=" + y + ", z=" + z;
                throw new IllegalArgumentException(var4_5.toString());
            }
            return x + (y << 4) + (z << 8);
        }

        @JvmStatic
        @NotNull
        public final BlockPos getRelativePosFromIndex(int index) {
            if (!(0 <= index ? index < 4096 : false)) {
                boolean $i$a$-require-SectionSnapshot$Companion$getRelativePosFromIndex$22 = false;
                String $i$a$-require-SectionSnapshot$Companion$getRelativePosFromIndex$22 = "Index must be in range 0-4095, got " + index;
                throw new IllegalArgumentException($i$a$-require-SectionSnapshot$Companion$getRelativePosFromIndex$22.toString());
            }
            int x = index & 0xF;
            int y = index >> 4 & 0xF;
            int z = index >> 8 & 0xF;
            return new BlockPos(x, y, z);
        }

        @JvmStatic
        @NotNull
        public final BlockPos getWorldPos(@NotNull SectionPos sectionPos, int relativeX, int relativeY, int relativeZ) {
            Intrinsics.checkNotNullParameter((Object)sectionPos, (String)"sectionPos");
            BlockPos blockPos = sectionPos.origin().offset(relativeX, relativeY, relativeZ);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
            return blockPos;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

