/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.physics.terrain;

import cn.solarmoon.spark_core.physics.level.PhysicsLevel;
import cn.solarmoon.spark_core.physics.terrain.PhysicsChunkManager;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\nH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lcn/solarmoon/spark_core/physics/terrain/TerrainUpdatePayload;", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;", "sections", "", "Lnet/minecraft/core/SectionPos;", "<init>", "(Ljava/util/Set;)V", "getSections", "()Ljava/util/Set;", "type", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "Companion", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nChunkUpdatePayload.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkUpdatePayload.kt\ncn/solarmoon/spark_core/physics/terrain/TerrainUpdatePayload\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1869#2,2:65\n*S KotlinDebug\n*F\n+ 1 ChunkUpdatePayload.kt\ncn/solarmoon/spark_core/physics/terrain/TerrainUpdatePayload\n*L\n35#1:65,2\n*E\n"})
public final class TerrainUpdatePayload
implements CustomPacketPayload {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<SectionPos> sections;
    @NotNull
    private static final StreamCodec<FriendlyByteBuf, TerrainUpdatePayload> STREAM_CODEC;
    @NotNull
    private static final CustomPacketPayload.Type<TerrainUpdatePayload> TYPE;

    public TerrainUpdatePayload(@NotNull Set<? extends SectionPos> sections) {
        Intrinsics.checkNotNullParameter(sections, (String)"sections");
        this.sections = sections;
    }

    @NotNull
    public final Set<SectionPos> getSections() {
        return this.sections;
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private static final void STREAM_CODEC$lambda$1(FriendlyByteBuf buf, TerrainUpdatePayload payload) {
        buf.writeVarInt(payload.sections.size());
        Iterable $this$forEach$iv = payload.sections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SectionPos sectionPos = (SectionPos)element$iv;
            boolean bl = false;
            buf.writeVarInt(sectionPos.x());
            buf.writeVarInt(sectionPos.y());
            buf.writeVarInt(sectionPos.z());
        }
    }

    private static final TerrainUpdatePayload STREAM_CODEC$lambda$3(FriendlyByteBuf buf) {
        int sectionCount = buf.readVarInt();
        Set sections = new LinkedHashSet();
        int n = 0;
        while (n < sectionCount) {
            int it = n++;
            boolean bl = false;
            int x = buf.readVarInt();
            int y = buf.readVarInt();
            int z = buf.readVarInt();
            SectionPos sectionPos = SectionPos.of((int)x, (int)y, (int)z);
            Intrinsics.checkNotNullExpressionValue((Object)sectionPos, (String)"of(...)");
            sections.add(sectionPos);
        }
        return new TerrainUpdatePayload(sections);
    }

    @JvmStatic
    public static final void handler(@NotNull TerrainUpdatePayload payload, @NotNull IPayloadContext context) {
        Companion.handler(payload, context);
    }

    @NotNull
    public static final StreamCodec<FriendlyByteBuf, TerrainUpdatePayload> getSTREAM_CODEC() {
        return Companion.getSTREAM_CODEC();
    }

    @NotNull
    public static final CustomPacketPayload.Type<TerrainUpdatePayload> getTYPE() {
        return Companion.getTYPE();
    }

    static {
        StreamCodec streamCodec2 = StreamCodec.of(TerrainUpdatePayload::STREAM_CODEC$lambda$1, TerrainUpdatePayload::STREAM_CODEC$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec2, (String)"of(...)");
        STREAM_CODEC = streamCodec2;
        TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"spark_core", (String)"terrain_update"));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R(\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00118\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0003\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcn/solarmoon/spark_core/physics/terrain/TerrainUpdatePayload$Companion;", "", "<init>", "()V", "handler", "", "payload", "Lcn/solarmoon/spark_core/physics/terrain/TerrainUpdatePayload;", "context", "Lnet/neoforged/neoforge/network/handling/IPayloadContext;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "getSTREAM_CODEC$annotations", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "TYPE", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "getTYPE$annotations", "getTYPE", "()Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "SparkCore-1.21.1-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void handler(@NotNull TerrainUpdatePayload payload, @NotNull IPayloadContext context) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Level level = context.player().level();
            PhysicsLevel physicsLevel = level.getPhysicsLevel();
            PhysicsChunkManager terrainManager = physicsLevel.getTerrainManager();
            context.enqueueWork(() -> Companion.handler$lambda$0(terrainManager, payload));
        }

        @NotNull
        public final StreamCodec<FriendlyByteBuf, TerrainUpdatePayload> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        @JvmStatic
        public static /* synthetic */ void getSTREAM_CODEC$annotations() {
        }

        @NotNull
        public final CustomPacketPayload.Type<TerrainUpdatePayload> getTYPE() {
            return TYPE;
        }

        @JvmStatic
        public static /* synthetic */ void getTYPE$annotations() {
        }

        private static final void handler$lambda$0(PhysicsChunkManager $terrainManager, TerrainUpdatePayload $payload) {
            $terrainManager.markDirtySections($payload.getSections());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

