/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.physics.visualizer;

import cn.solarmoon.spark_core.physics.level.PhysicsLevel;
import cn.solarmoon.spark_core.physics.mesh.BoxShapeMesh;
import cn.solarmoon.spark_core.physics.visualizer.ShapeVisualizer;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JP\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcn/solarmoon/spark_core/physics/visualizer/BoxVisualizer;", "Lcn/solarmoon/spark_core/physics/visualizer/ShapeVisualizer;", "<init>", "()V", "mesh", "Lcn/solarmoon/spark_core/physics/mesh/BoxShapeMesh;", "getMesh", "()Lcn/solarmoon/spark_core/physics/mesh/BoxShapeMesh;", "render", "", "level", "Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;", "body", "Lcom/jme3/bullet/collision/PhysicsCollisionObject;", "transform", "Lorg/joml/Matrix4f;", "shape", "Lcom/jme3/bullet/collision/shapes/CollisionShape;", "mc", "Lnet/minecraft/client/Minecraft;", "camPos", "Lnet/minecraft/world/phys/Vec3;", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "partialTicks", "", "SparkCore-1.21.1-neoforge"})
public final class BoxVisualizer
implements ShapeVisualizer {
    @NotNull
    private final BoxShapeMesh mesh = new BoxShapeMesh();

    @NotNull
    public final BoxShapeMesh getMesh() {
        return this.mesh;
    }

    @Override
    public void render(@NotNull PhysicsLevel level, @NotNull PhysicsCollisionObject body, @NotNull Matrix4f transform, @NotNull CollisionShape shape, @NotNull Minecraft mc, @NotNull Vec3 camPos, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        Intrinsics.checkNotNullParameter((Object)camPos, (String)"camPos");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        if (shape instanceof BoxCollisionShape) {
            BoxShapeMesh mesh = this.mesh.update((BoxCollisionShape)shape);
            VertexConsumer buffer = bufferSource.getBuffer(RenderType.lines());
            int i = 0;
            int[] edges = mesh.getEdgesOrder();
            int n = edges.length + -1;
            int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
            if (i <= n2) {
                while (true) {
                    Vector3f from = mesh.getWorldVertexPosition(edges[i], transform).sub((Vector3fc)camPos.toVector3f(), new Vector3f());
                    Vector3f to = mesh.getWorldVertexPosition(edges[i + 1], transform).sub((Vector3fc)camPos.toVector3f(), new Vector3f());
                    Vector3f normal = to.sub((Vector3fc)from, new Vector3f()).normalize();
                    int color = body.isColliding ? Color.RED.getRGB() : Color.WHITE.getRGB();
                    buffer.addVertex(poseStack.last().pose(), from.x, from.y, from.z).setColor(color).setNormal(poseStack.last(), normal.x, normal.y, normal.z);
                    buffer.addVertex(poseStack.last().pose(), to.x, to.y, to.z).setColor(color).setNormal(poseStack.last(), normal.x, normal.y, normal.z);
                    if (i == n2) break;
                    i += 2;
                }
            }
        }
    }
}

