/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.physics.visualizer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u0005J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J8\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J8\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J8\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020%H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcn/solarmoon/spark_core/physics/visualizer/FrozenStateVisualizer;", "", "<init>", "()V", "enabled", "", "frozenEntities", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lnet/minecraft/world/entity/Entity;", "RENDER_DISTANCE", "", "UPDATE_INTERVAL", "updateCounter", "enable", "", "disable", "toggle", "onRenderLevel", "event", "Lnet/neoforged/neoforge/client/event/RenderLevelStageEvent;", "renderFrozenEntityBox", "entity", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "camX", "camY", "camZ", "renderFrozenIcon", "renderSnowflake", "matrix", "Lorg/joml/Matrix4f;", "buffer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "r", "", "g", "b", "a", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nFrozenStateVisualizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrozenStateVisualizer.kt\ncn/solarmoon/spark_core/physics/visualizer/FrozenStateVisualizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,216:1\n1869#2,2:217\n*S KotlinDebug\n*F\n+ 1 FrozenStateVisualizer.kt\ncn/solarmoon/spark_core/physics/visualizer/FrozenStateVisualizer\n*L\n81#1:217,2\n*E\n"})
public final class FrozenStateVisualizer {
    @NotNull
    public static final FrozenStateVisualizer INSTANCE = new FrozenStateVisualizer();
    private static boolean enabled;
    @NotNull
    private static final ConcurrentHashMap<Integer, Entity> frozenEntities;
    private static final double RENDER_DISTANCE = 64.0;
    private static final int UPDATE_INTERVAL = 10;
    private static int updateCounter;

    private FrozenStateVisualizer() {
    }

    public final void enable() {
        if (!enabled) {
            enabled = true;
            NeoForge.EVENT_BUS.register((Object)this);
        }
    }

    public final void disable() {
        if (enabled) {
            enabled = false;
            NeoForge.EVENT_BUS.unregister((Object)this);
            frozenEntities.clear();
        }
    }

    public final boolean toggle() {
        if (enabled) {
            this.disable();
        } else {
            this.enable();
        }
        return enabled;
    }

    @SubscribeEvent
    public final void onRenderLevel(@NotNull RenderLevelStageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!enabled || !Intrinsics.areEqual((Object)event.getStage(), (Object)RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS)) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        Camera camera = minecraft.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        Collection<Entity> collection = frozenEntities.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entity);
            Intrinsics.checkNotNull((Object)poseStack);
            Intrinsics.checkNotNull((Object)bufferSource);
            INSTANCE.renderFrozenEntityBox(entity, poseStack, (MultiBufferSource)bufferSource, cameraPos.x, cameraPos.y, cameraPos.z);
        }
        bufferSource.endBatch();
    }

    private final void renderFrozenEntityBox(Entity entity, PoseStack poseStack, MultiBufferSource bufferSource, double camX, double camY, double camZ) {
        poseStack.pushPose();
        AABB box = entity.getBoundingBox().inflate(0.05);
        Color color = new Color(0, 191, 255, 128);
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)bufferSource.getBuffer(RenderType.lines()), (AABB)box.move(-camX, -camY, -camZ), (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        this.renderFrozenIcon(entity, poseStack, bufferSource, camX, camY, camZ);
        poseStack.popPose();
    }

    private final void renderFrozenIcon(Entity entity, PoseStack poseStack, MultiBufferSource bufferSource, double camX, double camY, double camZ) {
        poseStack.pushPose();
        double x = entity.getX() - camX;
        double y = entity.getY() + entity.getBoundingBox().getYsize() + 0.5 - camY;
        double z = entity.getZ() - camZ;
        poseStack.translate(x, y, z);
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        poseStack.mulPose(camera.rotation());
        poseStack.scale(0.5f, 0.5f, 0.5f);
        Matrix4f matrix = poseStack.last().pose();
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.lines());
        float r = 0.0f;
        float g = 0.7490196f;
        float b = 1.0f;
        float a = 0.8f;
        Intrinsics.checkNotNull((Object)matrix);
        Intrinsics.checkNotNull((Object)buffer);
        this.renderSnowflake(matrix, buffer, r, g, b, a);
        poseStack.popPose();
    }

    private final void renderSnowflake(Matrix4f matrix, VertexConsumer buffer, float r, float g, float b, float a) {
        float size = 0.5f;
        int packedColor = ((int)(a * (float)255) & 0xFF) << 24 | ((int)(r * (float)255) & 0xFF) << 16 | ((int)(g * (float)255) & 0xFF) << 8 | (int)(b * (float)255) & 0xFF;
        int packedLight = 0xF000F0;
        int packedOverlay = 0;
        for (int i = 0; i < 6; ++i) {
            float angle = (float)Math.toRadians(i * 60);
            float x = size * (float)Math.cos(angle);
            float y = size * (float)Math.sin(angle);
            buffer.addVertex(0.0f, 0.0f, 0.0f, packedColor, 0.0f, 0.0f, packedOverlay, packedLight, 0.0f, 1.0f, 0.0f);
            buffer.addVertex(x, y, 0.0f, packedColor, 0.0f, 0.0f, packedOverlay, packedLight, 0.0f, 1.0f, 0.0f);
            float branchSize = size * 0.4f;
            float branchAngle1 = angle + (float)Math.toRadians(30.0);
            float branchAngle2 = angle - (float)Math.toRadians(30.0);
            float midX = x * 0.6f;
            float midY = y * 0.6f;
            float branch1X = midX + branchSize * (float)Math.cos(branchAngle1);
            float branch1Y = midY + branchSize * (float)Math.sin(branchAngle1);
            float branch2X = midX + branchSize * (float)Math.cos(branchAngle2);
            float branch2Y = midY + branchSize * (float)Math.sin(branchAngle2);
            buffer.addVertex(midX, midY, 0.0f, packedColor, 0.0f, 0.0f, packedOverlay, packedLight, 0.0f, 1.0f, 0.0f);
            buffer.addVertex(branch1X, branch1Y, 0.0f, packedColor, 0.0f, 0.0f, packedOverlay, packedLight, 0.0f, 1.0f, 0.0f);
            buffer.addVertex(midX, midY, 0.0f, packedColor, 0.0f, 0.0f, packedOverlay, packedLight, 0.0f, 1.0f, 0.0f);
            buffer.addVertex(branch2X, branch2Y, 0.0f, packedColor, 0.0f, 0.0f, packedOverlay, packedLight, 0.0f, 1.0f, 0.0f);
        }
    }

    static {
        frozenEntities = new ConcurrentHashMap();
    }
}

