/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.sound;

import cn.solarmoon.spark_core.sound.ISpreadingSoundSource;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SpreadingSoundInstance
extends AbstractTickableSoundInstance {
    @Nullable
    public final ISpreadingSoundSource ISpreadingSoundSource;
    public final SoundEvent soundEvent;
    public final ResourceLocation name;
    public final LinkedHashMap<Vec3, Float> spreadDistances = new LinkedHashMap(20);
    public final LinkedHashMap<Vec3, Vec3> speeds = new LinkedHashMap(20);
    private final LinkedHashMap<Vec3, Float> ranges = new LinkedHashMap(20);
    private final LinkedHashMap<Vec3, Float> pitches = new LinkedHashMap(20);
    private final LinkedHashMap<Vec3, Float> volumes = new LinkedHashMap(20);
    public boolean isPlaying = false;

    public SpreadingSoundInstance(SoundEvent soundEvent, SoundSource soundType, Vec3 position, Vec3 speed, float range, float pitch, float volume) {
        this(soundEvent, soundType, soundEvent.getLocation(), position, speed, range, pitch, volume);
    }

    protected SpreadingSoundInstance(SoundEvent soundEvent, SoundSource soundType, ResourceLocation name, Vec3 position, Vec3 speed, float range, float pitch, float volume) {
        super(soundEvent, soundType, SoundInstance.createUnseededRandom());
        this.ISpreadingSoundSource = null;
        this.attenuation = SoundInstance.Attenuation.NONE;
        this.soundEvent = soundEvent;
        this.name = name;
        this.x = position.x;
        this.y = position.y;
        this.z = position.z;
        this.pitch = pitch;
        this.volume = volume;
        this.spreadDistances.put(position, Float.valueOf(0.0f));
        this.speeds.put(position, speed);
        this.ranges.put(position, Float.valueOf(range));
        this.pitches.put(position, Float.valueOf(pitch));
        this.volumes.put(position, Float.valueOf(volume));
    }

    public SpreadingSoundInstance(SoundEvent soundEvent, SoundSource soundType, ISpreadingSoundSource ISpreadingSoundSource2) {
        this(soundEvent, soundType, soundEvent.getLocation(), ISpreadingSoundSource2);
    }

    protected SpreadingSoundInstance(SoundEvent soundEvent, SoundSource soundType, ResourceLocation name, ISpreadingSoundSource ISpreadingSoundSource2) {
        super(soundEvent, soundType, SoundInstance.createUnseededRandom());
        this.ISpreadingSoundSource = ISpreadingSoundSource2;
        this.attenuation = SoundInstance.Attenuation.NONE;
        this.soundEvent = soundEvent;
        this.name = name;
        this.x = ISpreadingSoundSource2.getPosition((ResourceLocation)name).x;
        this.y = ISpreadingSoundSource2.getPosition((ResourceLocation)name).y;
        this.z = ISpreadingSoundSource2.getPosition((ResourceLocation)name).z;
        this.pitch = ISpreadingSoundSource2.getPitch(name);
        this.volume = ISpreadingSoundSource2.getVolume(name);
        this.spreadDistances.put(ISpreadingSoundSource2.getPosition(name), Float.valueOf(0.0f));
        this.speeds.put(ISpreadingSoundSource2.getPosition(name), ISpreadingSoundSource2.getSpeed(name));
        this.ranges.put(ISpreadingSoundSource2.getPosition(name), Float.valueOf(ISpreadingSoundSource2.getRange(name)));
        this.pitches.put(ISpreadingSoundSource2.getPosition(name), Float.valueOf(this.pitch));
        this.volumes.put(ISpreadingSoundSource2.getPosition(name), Float.valueOf(this.volume));
    }

    public void tick() {
        Iterator<Map.Entry<Vec3, Float>> iterator = this.spreadDistances.entrySet().iterator();
        if (!this.isPlaying) {
            while (iterator.hasNext()) {
                Map.Entry<Vec3, Float> entry = iterator.next();
                Vec3 position = entry.getKey();
                float distance = entry.getValue().floatValue();
                if (distance > this.ranges.get(position).floatValue()) {
                    iterator.remove();
                }
                float speed = SpreadingSoundInstance.getSoundSpeed(position.scale(0.5).add(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().scale(0.5)), Minecraft.getInstance().level);
                this.spreadDistances.put(position, Float.valueOf(distance + speed * 0.05f));
            }
        } else if (iterator.hasNext()) {
            Vec3 position = iterator.next().getKey();
            float pitch = this.pitches.getOrDefault(position, Float.valueOf(1.0f)).floatValue();
            float volume = this.volumes.getOrDefault(position, Float.valueOf(1.0f)).floatValue();
            this.x = position.x;
            this.y = position.y;
            this.z = position.z;
            this.pitch = pitch;
            this.volume = volume;
            iterator.remove();
        }
        if (this.ISpreadingSoundSource != null) {
            this.spreadDistances.put(this.ISpreadingSoundSource.getPosition(this.name), Float.valueOf(0.0f));
            this.speeds.put(this.ISpreadingSoundSource.getPosition(this.name), this.ISpreadingSoundSource.getSpeed(this.name));
            this.pitches.put(this.ISpreadingSoundSource.getPosition(this.name), Float.valueOf(this.ISpreadingSoundSource.getPitch(this.name)));
            this.volumes.put(this.ISpreadingSoundSource.getPosition(this.name), Float.valueOf(this.ISpreadingSoundSource.getVolume(this.name)));
        }
    }

    public static float getSoundSpeed(Vec3 position, ClientLevel level) {
        return 100.0f;
    }

    public Vec3 getSpeed(Vec3 position) {
        return this.speeds.get(position);
    }

    public float getRange(Vec3 position) {
        return this.ranges.get(position).floatValue();
    }

    public float getPitch(Vec3 position) {
        return this.pitches.get(position).floatValue();
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getVolume(Vec3 position) {
        return this.volumes.get(position).floatValue();
    }

    public float getVolume() {
        return this.volume;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public boolean canStartSilent() {
        return true;
    }
}

