/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.sound.payload;

import cn.solarmoon.spark_core.sound.SpreadingSoundHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SpreadingSoundPayload(SoundEvent soundEvent, SoundSource soundSource, Vec3 position, Vec3 velocity, float range, float pitch, float volume) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SpreadingSoundPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"spark_core", (String)"play_spreading_sound_payload"));
    public static final StreamCodec<FriendlyByteBuf, SpreadingSoundPayload> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, SpreadingSoundPayload>(){

        @NotNull
        public SpreadingSoundPayload decode(@NotNull FriendlyByteBuf buffer) {
            SoundEvent soundEvent = (SoundEvent)SoundEvent.DIRECT_STREAM_CODEC.decode((Object)buffer);
            SoundSource soundSource = (SoundSource)buffer.readEnum(SoundSource.class);
            Vec3 position = buffer.readVec3();
            Vec3 velocity = buffer.readVec3();
            float range = buffer.readFloat();
            float pitch = buffer.readFloat();
            float volume = buffer.readFloat();
            return new SpreadingSoundPayload(soundEvent, soundSource, position, velocity, range, pitch, volume);
        }

        public void encode(@NotNull FriendlyByteBuf buffer, SpreadingSoundPayload value) {
            SoundEvent.DIRECT_STREAM_CODEC.encode((Object)buffer, (Object)value.soundEvent());
            buffer.writeEnum((Enum)value.soundSource());
            buffer.writeVec3(value.position());
            buffer.writeVec3(value.velocity());
            buffer.writeFloat(value.range());
            buffer.writeFloat(value.pitch());
            buffer.writeFloat(value.volume());
        }
    };

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handler(SpreadingSoundPayload payload, IPayloadContext context) {
        SpreadingSoundHelper.playSpreadingSound(context.player().level(), payload.soundEvent(), payload.soundSource(), payload.position(), payload.velocity(), payload.range(), payload.pitch(), payload.volume());
    }
}

