/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.util;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;

public class BlockCollisionUtil {
    public static float getBlockFriction(Level level, BlockState state2, BlockPos pos) {
        if (state2.isStickyBlock()) {
            return 10.0f;
        }
        return 2.0f * (1.0f - state2.getFriction((LevelReader)level, BlockPos.ZERO, null));
    }

    public static float getBlockRollingFriction(Level level, BlockState state2, BlockPos pos) {
        if (state2.isStickyBlock()) {
            return 9.0f;
        }
        if (state2.is(BlockTags.SNOW)) {
            return 7.0f;
        }
        if (state2.is(BlockTags.MINEABLE_WITH_SHOVEL)) {
            return 5.0f;
        }
        if (state2.is(BlockTags.MINEABLE_WITH_PICKAXE)) {
            return 0.5f;
        }
        if (state2.is(BlockTags.MINEABLE_WITH_AXE)) {
            return 0.9f;
        }
        if (state2.is(BlockTags.MINEABLE_WITH_HOE)) {
            return 3.0f;
        }
        return 2.0f / state2.getBlock().getSpeedFactor();
    }

    public static float getSlip(ChunkAccess chunk, BlockState state2, BlockPos pos) {
        if (state2.isStickyBlock()) {
            return 0.0f;
        }
        float result = 0.0f;
        float humidity = 0.0f;
        if (!chunk.getFluidState(pos.above()).isEmpty()) {
            humidity = 1.0f;
        } else if (Objects.requireNonNull(chunk.getLevel()).isRainingAt(pos.above())) {
            humidity = Objects.requireNonNull(chunk.getLevel()).getRainLevel(1.0f);
        }
        result = state2.is(BlockTags.SNOW) ? (result += 0.35f - 0.2f * humidity) : (state2.getBlock() instanceof ColoredFallingBlock ? (result += 0.35f + 0.3f * humidity) : (state2.getBlock() instanceof ConcretePowderBlock ? (result += 0.35f - 0.5f * humidity) : (result += (float)((int)(0.3 * (double)humidity)))));
        return Math.min(1.0f, result);
    }

    public static float getRestitution(ChunkAccess chunk, BlockState state2, BlockPos pos) {
        if (state2.is(BlockTags.MINEABLE_WITH_SHOVEL)) {
            return 0.3f;
        }
        if (state2.is(BlockTags.MINEABLE_WITH_PICKAXE)) {
            return 0.9f;
        }
        if (state2.is(BlockTags.MINEABLE_WITH_AXE)) {
            return 0.8f;
        }
        if (state2.is(BlockTags.MINEABLE_WITH_HOE)) {
            return 0.0f;
        }
        if (state2.is(BlockTags.WOOL)) {
            return 0.1f;
        }
        if (state2.isSlimeBlock()) {
            return 5.0f;
        }
        if (state2.isStickyBlock()) {
            return 0.0f;
        }
        return 0.5f;
    }
}

