/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.util;

import cn.solarmoon.spark_core.util.SerializeHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\b\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\u00062\u0010\u0010\f\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\n0\u0007J(\u0010\r\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\n0\u0007\"\b\b\u0000\u0010\n*\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\u0006R&\u0010\u0004\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcn/solarmoon/spark_core/util/CodecRegistry;", "", "<init>", "()V", "map", "", "Lkotlin/reflect/KClass;", "Lnet/minecraft/network/codec/StreamCodec;", "register", "", "T", "type", "codec", "get", "SparkCore-1.21.1-neoforge"})
public final class CodecRegistry {
    @NotNull
    public static final CodecRegistry INSTANCE = new CodecRegistry();
    @NotNull
    private static final Map<KClass<?>, StreamCodec<?, ?>> map = new LinkedHashMap();

    private CodecRegistry() {
    }

    public final <T> void register(@NotNull KClass<T> type, @NotNull StreamCodec<?, T> codec2) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(codec2, (String)"codec");
        map.put(type, codec2);
    }

    @NotNull
    public final <T> StreamCodec<?, T> get(@NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        StreamCodec<?, ?> streamCodec2 = map.get(type);
        StreamCodec<?, ?> streamCodec3 = streamCodec2 instanceof StreamCodec ? streamCodec2 : null;
        if (streamCodec3 == null) {
            throw new IllegalStateException(("\u672a\u6ce8\u518c\u7c7b\u578b " + type.getSimpleName() + " \u7684\u7f51\u7edc\u6d41\u7f16\u89e3\u7801\u5668").toString());
        }
        return streamCodec3;
    }

    static {
        KClass kClass = Reflection.getOrCreateKotlinClass(Integer.TYPE);
        StreamCodec streamCodec2 = ByteBufCodecs.INT;
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec2, (String)"INT");
        INSTANCE.register(kClass, streamCodec2);
        KClass kClass2 = Reflection.getOrCreateKotlinClass(Float.TYPE);
        StreamCodec streamCodec3 = ByteBufCodecs.FLOAT;
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec3, (String)"FLOAT");
        INSTANCE.register(kClass2, streamCodec3);
        KClass kClass3 = Reflection.getOrCreateKotlinClass(Double.TYPE);
        StreamCodec streamCodec4 = ByteBufCodecs.DOUBLE;
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec4, (String)"DOUBLE");
        INSTANCE.register(kClass3, streamCodec4);
        KClass kClass4 = Reflection.getOrCreateKotlinClass(String.class);
        StreamCodec streamCodec5 = ByteBufCodecs.STRING_UTF8;
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec5, (String)"STRING_UTF8");
        INSTANCE.register(kClass4, streamCodec5);
        KClass kClass5 = Reflection.getOrCreateKotlinClass(Boolean.TYPE);
        StreamCodec streamCodec6 = ByteBufCodecs.BOOL;
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec6, (String)"BOOL");
        INSTANCE.register(kClass5, streamCodec6);
        INSTANCE.register(Reflection.getOrCreateKotlinClass(Vector3f.class), SerializeHelper.getVECTOR3F_COMPRESSED_STREAM_CODEC());
        INSTANCE.register(Reflection.getOrCreateKotlinClass(Quaternionf.class), SerializeHelper.getQUATERNIONF_COMPRESSED_STREAM_CODEC());
    }
}

