/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.util;

import java.io.File;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcn/solarmoon/spark_core/util/ResourceExtractionUtil;", "", "<init>", "()V", "extractResourcesFromJar", "", "modMainClass", "Ljava/lang/Class;", "sourceDirInJar", "", "targetBaseRuntimeDir", "Ljava/io/File;", "targetSubDirName", "logger", "Lorg/slf4j/Logger;", "SparkCore-1.21.1-neoforge"})
public final class ResourceExtractionUtil {
    @NotNull
    public static final ResourceExtractionUtil INSTANCE = new ResourceExtractionUtil();

    private ResourceExtractionUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean extractResourcesFromJar(@NotNull Class<?> modMainClass, @NotNull String sourceDirInJar, @NotNull File targetBaseRuntimeDir, @NotNull String targetSubDirName, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter(modMainClass, (String)"modMainClass");
        Intrinsics.checkNotNullParameter((Object)sourceDirInJar, (String)"sourceDirInJar");
        Intrinsics.checkNotNullParameter((Object)targetBaseRuntimeDir, (String)"targetBaseRuntimeDir");
        Intrinsics.checkNotNullParameter((Object)targetSubDirName, (String)"targetSubDirName");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        File finalTargetDir = new File(targetBaseRuntimeDir, targetSubDirName);
        if (!finalTargetDir.exists() && !finalTargetDir.mkdirs()) {
            logger2.error("\u65e0\u6cd5\u521b\u5efa\u76ee\u6807\u76ee\u5f55: {}", (Object)finalTargetDir.getAbsolutePath());
            return false;
        }
        URL resourceRootUrl = modMainClass.getClassLoader().getResource(sourceDirInJar);
        if (resourceRootUrl == null) {
            logger2.warn("JAR \u4e2d\u672a\u627e\u5230\u6e90\u76ee\u5f55 '/{}'\u3002\u8df3\u8fc7\u63d0\u53d6\u5230 '{}'\u3002", (Object)sourceDirInJar, (Object)finalTargetDir.getPath());
            return true;
        }
        try {
            Path resourceRootPath = Paths.get(resourceRootUrl.toURI());
            AutoCloseable autoCloseable = Files.walk(resourceRootPath, new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl = false;
                stream.forEach(arg_0 -> ResourceExtractionUtil.extractResourcesFromJar$lambda$2$lambda$1(arg_0 -> ResourceExtractionUtil.extractResourcesFromJar$lambda$2$lambda$0(resourceRootPath, finalTargetDir, logger2, arg_0), arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return true;
        }
        catch (FileSystemNotFoundException e) {
            logger2.error("\u672a\u627e\u5230 URI \u7684\u6587\u4ef6\u7cfb\u7edf: {}\u3002\u5982\u679c JAR \u8def\u5f84\u672a\u6b63\u786e\u89e3\u91ca\u4e3a\u6587\u4ef6\u7cfb\u7edf\uff0c\u53ef\u80fd\u4f1a\u53d1\u751f\u6b64\u60c5\u51b5\u3002\u8bf7\u786e\u4fdd JAR \u7ed3\u6784\u6b63\u786e\u4e14\u53ef\u8bbf\u95ee\u3002", (Object)resourceRootUrl.toURI(), (Object)e);
            return false;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{sourceDirInJar, finalTargetDir.getPath(), e.getMessage(), e};
            logger2.error("\u65e0\u6cd5\u4ece '/{}' \u63d0\u53d6\u9ed8\u8ba4\u8d44\u6e90\u5230 '{}': {}", objectArray);
            return false;
        }
    }

    private static final Unit extractResourcesFromJar$lambda$2$lambda$0(Path $resourceRootPath, File $finalTargetDir, Logger $logger, Path sourcePath) {
        String relativePath = ((Object)$resourceRootPath.relativize(sourcePath)).toString();
        File destFile = new File($finalTargetDir, relativePath);
        if (Files.isDirectory(sourcePath, new LinkOption[0])) {
            if (!destFile.exists() && !destFile.mkdirs()) {
                $logger.warn("\u65e0\u6cd5\u521b\u5efa\u76ee\u5f55: {}", (Object)destFile.getAbsolutePath());
            }
        } else if (Files.isRegularFile(sourcePath, new LinkOption[0]) && !destFile.exists()) {
            try {
                File file = destFile.getParentFile();
                if (file != null) {
                    file.mkdirs();
                }
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(sourcePath, destFile.toPath(), copyOptionArray);
                $logger.info("\u5df2\u63d0\u53d6\u9ed8\u8ba4\u8d44\u6e90: {}", (Object)destFile.getPath());
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{sourcePath, destFile.getPath(), e.getMessage(), e};
                $logger.error("\u65e0\u6cd5\u5c06\u8d44\u6e90\u6587\u4ef6 '{}' \u590d\u5236\u5230 '{}': {}", objectArray);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void extractResourcesFromJar$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

