/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.util;

import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.MinecraftServer;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\u001c\u0010\b\u001a\u00020\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nH\u0007J)\u0010\f\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\r2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\r0\nH\u0007\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcn/solarmoon/spark_core/util/ServerThreading;", "", "<init>", "()V", "serverOrNull", "Lnet/minecraft/server/MinecraftServer;", "isServerThread", "", "runOnServer", "block", "Lkotlin/Function1;", "", "callOnServerBlocking", "T", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "SparkCore-1.21.1-neoforge"})
public final class ServerThreading {
    @NotNull
    public static final ServerThreading INSTANCE = new ServerThreading();

    private ServerThreading() {
    }

    @JvmStatic
    @Nullable
    public static final MinecraftServer serverOrNull() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    @JvmStatic
    public static final boolean isServerThread() {
        MinecraftServer minecraftServer = INSTANCE.serverOrNull();
        if (minecraftServer == null) {
            return false;
        }
        MinecraftServer server = minecraftServer;
        return server.isSameThread();
    }

    @JvmStatic
    public static final boolean runOnServer(@NotNull Function1<? super MinecraftServer, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        MinecraftServer minecraftServer = INSTANCE.serverOrNull();
        if (minecraftServer == null) {
            return false;
        }
        MinecraftServer server = minecraftServer;
        if (server.isSameThread()) {
            block.invoke((Object)server);
        } else {
            server.execute(() -> ServerThreading.runOnServer$lambda$0(block, server));
        }
        return true;
    }

    @JvmStatic
    @Nullable
    public static final <T> T callOnServerBlocking(@NotNull Function1<? super MinecraftServer, ? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        MinecraftServer minecraftServer = INSTANCE.serverOrNull();
        if (minecraftServer == null) {
            return null;
        }
        MinecraftServer server = minecraftServer;
        if (server.isSameThread()) {
            return (T)block.invoke((Object)server);
        }
        CompletableFuture f = new CompletableFuture();
        server.execute(() -> ServerThreading.callOnServerBlocking$lambda$1(f, block, server));
        return f.get();
    }

    private static final void runOnServer$lambda$0(Function1 $block, MinecraftServer $server) {
        $block.invoke((Object)$server);
    }

    private static final void callOnServerBlocking$lambda$1(CompletableFuture $f, Function1 $block, MinecraftServer $server) {
        try {
            $f.complete($block.invoke((Object)$server));
        }
        catch (Throwable t) {
            $f.completeExceptionally(t);
        }
    }
}

