/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.visual_effect.camera_shake;

import cn.solarmoon.spark_core.physics.level.PhysicsLevel;
import cn.solarmoon.spark_core.visual_effect.VisualEffectRenderer;
import cn.solarmoon.spark_core.visual_effect.camera_shake.CameraShakePayload;
import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007J(\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\nJ\b\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016J0\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcn/solarmoon/spark_core/visual_effect/camera_shake/CameraShaker;", "Lcn/solarmoon/spark_core/visual_effect/VisualEffectRenderer;", "<init>", "()V", "shakeTick", "", "strength", "", "frequency", "shake", "", "time", "shakeToClient", "entity", "Lnet/minecraft/world/entity/Entity;", "clear", "tick", "physTick", "physLevel", "Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;", "setupCamera", "event", "Lnet/neoforged/neoforge/client/event/ViewportEvent$ComputeCameraAngles;", "render", "mc", "Lnet/minecraft/client/Minecraft;", "camPos", "Lnet/minecraft/world/phys/Vec3;", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "partialTicks", "SparkCore-1.21.1-neoforge"})
public final class CameraShaker
extends VisualEffectRenderer {
    private int shakeTick;
    private float strength;
    private float frequency;

    public final void shake(int time, float strength, float frequency) {
        if (strength > this.strength) {
            this.strength = strength;
            this.shakeTick = time;
            this.frequency = frequency;
        }
    }

    public static /* synthetic */ void shake$default(CameraShaker cameraShaker, int n, float f, float f2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            f2 = 3.0f;
        }
        cameraShaker.shake(n, f, f2);
    }

    public final void shakeToClient(@NotNull Entity entity, int time, float strength, float frequency) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof ServerPlayer) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)entity), (CustomPacketPayload)new CameraShakePayload(time, strength, frequency), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static /* synthetic */ void shakeToClient$default(CameraShaker cameraShaker, Entity entity, int n, float f, float f2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            f2 = 3.0f;
        }
        cameraShaker.shakeToClient(entity, n, f, f2);
    }

    public final void clear() {
        this.strength = 0.0f;
        this.frequency = 0.0f;
    }

    @Override
    public void tick() {
        if (this.shakeTick > 0) {
            int n = this.shakeTick;
            this.shakeTick = n + -1;
        } else {
            this.clear();
        }
    }

    @Override
    public void physTick(@NotNull PhysicsLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
    }

    public final void setupCamera(@NotNull ViewportEvent.ComputeCameraAngles event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getCamera().getEntity();
        double partialTicks = event.getPartialTick();
        if (this.shakeTick > 0) {
            double ticksExistedDelta = (double)entity.tickCount + partialTicks;
            if (!Minecraft.getInstance().isPaused()) {
                event.setPitch((float)((double)event.getPitch() + (double)this.strength * Math.cos(ticksExistedDelta * (double)this.frequency + (double)2)));
                event.setYaw((float)((double)event.getYaw() + (double)this.strength * Math.cos(ticksExistedDelta * (double)this.frequency + 1.0)));
                event.setRoll((float)((double)event.getRoll() + (double)this.strength * Math.cos(ticksExistedDelta * (double)this.frequency)));
            }
        } else {
            this.clear();
        }
    }

    @Override
    public void render(@NotNull Minecraft mc, @NotNull Vec3 camPos, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        Intrinsics.checkNotNullParameter((Object)camPos, (String)"camPos");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
    }
}

