/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.visual_effect.shape;

import cn.solarmoon.spark_core.physics.body.PhysicsBodyExtensionKt;
import cn.solarmoon.spark_core.physics.body.PhysicsBodyState;
import cn.solarmoon.spark_core.physics.level.ClientPhysicsLevel;
import cn.solarmoon.spark_core.physics.level.PhysicsLevel;
import cn.solarmoon.spark_core.physics.visualizer.ShapeVisualizer;
import cn.solarmoon.spark_core.physics.visualizer.ShapeVisualizerRegistry;
import cn.solarmoon.spark_core.util.SparkMathKt;
import cn.solarmoon.spark_core.visual_effect.VisualEffectRenderer;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.math.Matrix4f;
import com.jme3.math.Transform;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4fc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J0\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcn/solarmoon/spark_core/visual_effect/shape/ShapeRenderer;", "Lcn/solarmoon/spark_core/visual_effect/VisualEffectRenderer;", "<init>", "()V", "tick", "", "physTick", "physLevel", "Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;", "render", "mc", "Lnet/minecraft/client/Minecraft;", "camPos", "Lnet/minecraft/world/phys/Vec3;", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "partialTicks", "", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nShapeRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShapeRenderer.kt\ncn/solarmoon/spark_core/visual_effect/shape/ShapeRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,94:1\n1869#2:95\n1870#2:98\n13472#3,2:96\n*S KotlinDebug\n*F\n+ 1 ShapeRenderer.kt\ncn/solarmoon/spark_core/visual_effect/shape/ShapeRenderer\n*L\n57#1:95\n57#1:98\n67#1:96,2\n*E\n"})
public final class ShapeRenderer
extends VisualEffectRenderer {
    @Override
    public void tick() {
    }

    @Override
    public void physTick(@NotNull PhysicsLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
    }

    @Override
    public void render(@NotNull Minecraft mc, @NotNull Vec3 camPos, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        Intrinsics.checkNotNullParameter((Object)camPos, (String)"camPos");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        ClientLevel clientLevel = mc.level;
        if (clientLevel == null) {
            return;
        }
        ClientLevel level = clientLevel;
        if (!mc.getEntityRenderDispatcher().shouldRenderHitBoxes()) {
            return;
        }
        PhysicsLevel physicsLevel = level.getPhysicsLevel();
        Intrinsics.checkNotNull((Object)physicsLevel, (String)"null cannot be cast to non-null type cn.solarmoon.spark_core.physics.level.ClientPhysicsLevel");
        ClientPhysicsLevel physLevel = (ClientPhysicsLevel)physicsLevel;
        Collection<PhysicsCollisionObject> collection = physLevel.getWorld().getPcoList();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getPcoList(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShapeVisualizer visualizer;
            PhysicsCollisionObject body = (PhysicsCollisionObject)element$iv;
            boolean bl = false;
            if (body.getCollisionGroup() == 0 || body.getCollideWithGroups() == 0 && !body.shouldShowDebugBoxWhenNonColldeWith) continue;
            CollisionShape shape = body.getCollisionShape();
            Intrinsics.checkNotNull((Object)body);
            PhysicsBodyState state2 = PhysicsBodyExtensionKt.stateOf(body);
            Transform transform = state2.getLastTransform();
            Intrinsics.checkNotNullExpressionValue((Object)transform, (String)"<get-lastTransform>(...)");
            Transform transform2 = state2.getTransform();
            Intrinsics.checkNotNullExpressionValue((Object)transform2, (String)"<get-transform>(...)");
            Matrix4f matrix4f = SparkMathKt.lerp(transform, transform2, partialTicks).toTransformMatrix();
            Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"toTransformMatrix(...)");
            org.joml.Matrix4f transform3 = SparkMathKt.toMatrix4f(matrix4f);
            if (shape instanceof CompoundCollisionShape) {
                ChildCollisionShape[] childCollisionShapeArray = ((CompoundCollisionShape)shape).listChildren();
                Intrinsics.checkNotNullExpressionValue((Object)childCollisionShapeArray, (String)"listChildren(...)");
                Object[] $this$forEach$iv2 = childCollisionShapeArray;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    ShapeVisualizer visualizer2;
                    ChildCollisionShape it = (ChildCollisionShape)element$iv2;
                    boolean bl2 = false;
                    CollisionShape collisionShape = it.getShape();
                    Intrinsics.checkNotNullExpressionValue((Object)collisionShape, (String)"getShape(...)");
                    if (ShapeVisualizerRegistry.INSTANCE.getVisualizer(collisionShape) == null) continue;
                    Matrix4f matrix4f2 = it.copyTransform(null).toTransformMatrix();
                    Intrinsics.checkNotNullExpressionValue((Object)matrix4f2, (String)"toTransformMatrix(...)");
                    org.joml.Matrix4f childTransform = SparkMathKt.toMatrix4f(matrix4f2);
                    org.joml.Matrix4f finalMatrix = transform3.mul((Matrix4fc)childTransform, new org.joml.Matrix4f());
                    PhysicsLevel physicsLevel2 = physLevel;
                    Intrinsics.checkNotNull((Object)finalMatrix);
                    CollisionShape collisionShape2 = it.getShape();
                    Intrinsics.checkNotNullExpressionValue((Object)collisionShape2, (String)"getShape(...)");
                    visualizer2.render(physicsLevel2, body, finalMatrix, collisionShape2, mc, camPos, poseStack, bufferSource, partialTicks);
                }
                continue;
            }
            Intrinsics.checkNotNull((Object)shape);
            if (ShapeVisualizerRegistry.INSTANCE.getVisualizer(shape) == null) continue;
            visualizer.render(physLevel, body, transform3, shape, mc, camPos, poseStack, bufferSource, partialTicks);
        }
    }
}

