/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.visual_effect.trail;

import cn.solarmoon.spark_core.visual_effect.trail.TrailElement;
import cn.solarmoon.spark_core.visual_effect.trail.TrailInfo;
import cn.solarmoon.spark_core.visual_effect.trail.TrailPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012J\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\nJ\u000e\u0010\"\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\nJ\u0006\u0010#\u001a\u00020\u001dJ\u000e\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u0013J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'J\u0010\u0010)\u001a\u0004\u0018\u00010\n2\u0006\u0010%\u001a\u00020\u0013J\u0016\u0010*\u001a\u00020\u00132\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\n0'H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R(\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018\u00a8\u0006,"}, d2={"Lcn/solarmoon/spark_core/visual_effect/trail/TrailMesh;", "", "info", "Lcn/solarmoon/spark_core/visual_effect/trail/TrailInfo;", "<init>", "(Lcn/solarmoon/spark_core/visual_effect/trail/TrailInfo;)V", "getInfo", "()Lcn/solarmoon/spark_core/visual_effect/trail/TrailInfo;", "mainPoints", "", "Lcn/solarmoon/spark_core/visual_effect/trail/TrailPoint;", "getMainPoints", "()Ljava/util/List;", "renderPoints", "getRenderPoints", "active", "", "dynamicStart", "Lkotlin/Function1;", "", "Lorg/joml/Vector3f;", "getDynamicStart", "()Lkotlin/jvm/functions/Function1;", "setDynamicStart", "(Lkotlin/jvm/functions/Function1;)V", "dynamicEnd", "getDynamicEnd", "setDynamicEnd", "addPoint", "", "start", "end", "addMainPoint", "point", "addRenderPoint", "tick", "frame", "partialTicks", "zipRenderPoints", "", "Lcn/solarmoon/spark_core/visual_effect/trail/TrailElement;", "generateRenderPoint", "calculateTotalLength", "points", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nTrailMesh.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrailMesh.kt\ncn/solarmoon/spark_core/visual_effect/trail/TrailMesh\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1869#2,2:115\n1740#2,3:117\n1869#2,2:120\n1740#2,3:122\n*S KotlinDebug\n*F\n+ 1 TrailMesh.kt\ncn/solarmoon/spark_core/visual_effect/trail/TrailMesh\n*L\n37#1:115,2\n38#1:117,3\n39#1:120,2\n40#1:122,3\n*E\n"})
public final class TrailMesh {
    @NotNull
    private final TrailInfo info;
    @NotNull
    private final List<TrailPoint> mainPoints;
    @NotNull
    private final List<TrailPoint> renderPoints;
    private boolean active;
    @Nullable
    private Function1<? super Float, ? extends Vector3f> dynamicStart;
    @Nullable
    private Function1<? super Float, ? extends Vector3f> dynamicEnd;

    public TrailMesh(@NotNull TrailInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.info = info;
        this.mainPoints = new ArrayList();
        this.renderPoints = new ArrayList();
    }

    @NotNull
    public final TrailInfo getInfo() {
        return this.info;
    }

    @NotNull
    public final List<TrailPoint> getMainPoints() {
        return this.mainPoints;
    }

    @NotNull
    public final List<TrailPoint> getRenderPoints() {
        return this.renderPoints;
    }

    @Nullable
    public final Function1<Float, Vector3f> getDynamicStart() {
        return this.dynamicStart;
    }

    public final void setDynamicStart(@Nullable Function1<? super Float, ? extends Vector3f> function1) {
        this.dynamicStart = function1;
    }

    @Nullable
    public final Function1<Float, Vector3f> getDynamicEnd() {
        return this.dynamicEnd;
    }

    public final void setDynamicEnd(@Nullable Function1<? super Float, ? extends Vector3f> function1) {
        this.dynamicEnd = function1;
    }

    public final void addPoint(@NotNull Function1<? super Float, ? extends Vector3f> start2, @NotNull Function1<? super Float, ? extends Vector3f> end) {
        Intrinsics.checkNotNullParameter(start2, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        this.addMainPoint(new TrailPoint((Vector3f)start2.invoke((Object)Float.valueOf(1.0f)), (Vector3f)end.invoke((Object)Float.valueOf(1.0f)), this.info));
        this.dynamicStart = start2;
        this.dynamicEnd = end;
    }

    public final void addMainPoint(@NotNull TrailPoint point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.active = true;
        this.mainPoints.add(point);
    }

    public final void addRenderPoint(@NotNull TrailPoint point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.renderPoints.add(point);
    }

    public final void tick() {
        boolean bl;
        block12: {
            boolean bl2;
            boolean $i$f$all;
            Iterable $this$all$iv;
            TrailPoint it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            block11: {
                if (!this.active) {
                    this.dynamicStart = null;
                    this.dynamicEnd = null;
                }
                $this$forEach$iv = this.mainPoints;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (TrailPoint)element$iv;
                    boolean bl3 = false;
                    it.tick();
                }
                $this$all$iv = this.mainPoints;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (TrailPoint)element$iv;
                        boolean bl4 = false;
                        if (it.isExpired()) continue;
                        bl2 = false;
                        break block11;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                this.mainPoints.clear();
            }
            $this$forEach$iv = this.renderPoints;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (TrailPoint)element$iv;
                boolean bl5 = false;
                it.tick();
            }
            $this$all$iv = this.renderPoints;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (TrailPoint)element$iv;
                    boolean bl6 = false;
                    if (it.isExpired()) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        if (bl) {
            this.renderPoints.clear();
        }
        this.active = false;
    }

    public final void frame(float partialTicks) {
        block0: {
            TrailPoint trailPoint = this.generateRenderPoint(partialTicks);
            if (trailPoint == null) break block0;
            TrailPoint it = trailPoint;
            boolean bl = false;
            this.addRenderPoint(it);
        }
    }

    @NotNull
    public final List<TrailElement> zipRenderPoints() {
        if (this.renderPoints.size() < 2) {
            return CollectionsKt.emptyList();
        }
        float totalLength = this.calculateTotalLength(this.renderPoints);
        List elements = new ArrayList();
        float accumulatedLength = 0.0f;
        int n = this.renderPoints.size() - 1;
        for (int i = 0; i < n; ++i) {
            TrailPoint pointA = this.renderPoints.get(i);
            TrailPoint pointB = this.renderPoints.get(i + 1);
            float segmentLength = pointA.getCenter().distance((Vector3fc)pointB.getCenter());
            float uStart = accumulatedLength / totalLength;
            float uEnd = (accumulatedLength + segmentLength) / totalLength;
            Vector2f uv1 = new Vector2f(uStart, 0.0f);
            Vector2f uv2 = new Vector2f(uStart, 1.0f);
            Vector2f uv3 = new Vector2f(uEnd, 0.0f);
            Vector2f uv4 = new Vector2f(uEnd, 1.0f);
            elements.add(new TrailElement(pointA, pointB, uv1, uv2, uv3, uv4));
            accumulatedLength += segmentLength;
        }
        return elements;
    }

    @Nullable
    public final TrailPoint generateRenderPoint(float partialTicks) {
        if (this.dynamicStart == null || this.dynamicEnd == null) {
            return null;
        }
        Function1<? super Float, ? extends Vector3f> function1 = this.dynamicStart;
        Intrinsics.checkNotNull(function1);
        Vector3f vector3f = (Vector3f)function1.invoke((Object)Float.valueOf(partialTicks));
        Function1<? super Float, ? extends Vector3f> function12 = this.dynamicEnd;
        Intrinsics.checkNotNull(function12);
        return new TrailPoint(vector3f, (Vector3f)function12.invoke((Object)Float.valueOf(partialTicks)), this.info);
    }

    private final float calculateTotalLength(List<TrailPoint> points) {
        float length = 0.0f;
        int n = points.size();
        for (int i = 1; i < n; ++i) {
            length += points.get(i).getCenter().distance((Vector3fc)points.get(i - 1).getCenter());
        }
        return length;
    }
}

