/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.visual_effect.trail;

import cn.solarmoon.spark_core.util.ColorUtilKt;
import cn.solarmoon.spark_core.util.SparkMathKt;
import cn.solarmoon.spark_core.visual_effect.trail.TrailInfo;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0017J\u000e\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0017J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0006H\u00c6\u0003J'\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010'\u001a\u00020\u001b2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\u000fH\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\u0013\u001a\n \u0014*\u0004\u0018\u00010\u00030\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\nR\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001c\u00a8\u0006-"}, d2={"Lcn/solarmoon/spark_core/visual_effect/trail/TrailPoint;", "", "start", "Lorg/joml/Vector3f;", "end", "info", "Lcn/solarmoon/spark_core/visual_effect/trail/TrailInfo;", "<init>", "(Lorg/joml/Vector3f;Lorg/joml/Vector3f;Lcn/solarmoon/spark_core/visual_effect/trail/TrailInfo;)V", "getStart", "()Lorg/joml/Vector3f;", "getEnd", "getInfo", "()Lcn/solarmoon/spark_core/visual_effect/trail/TrailInfo;", "value", "", "lifeTime", "getLifeTime", "()I", "center", "kotlin.jvm.PlatformType", "getCenter", "length", "", "getLength", "()F", "isExpired", "", "()Z", "tick", "", "getProgress", "partialTicks", "getColor", "Ljava/awt/Color;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "SparkCore-1.21.1-neoforge"})
public final class TrailPoint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector3f start;
    @NotNull
    private final Vector3f end;
    @NotNull
    private final TrailInfo info;
    private int lifeTime;

    public TrailPoint(@NotNull Vector3f start2, @NotNull Vector3f end, @NotNull TrailInfo info) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.start = start2;
        this.end = end;
        this.info = info;
        this.lifeTime = this.info.getLifeTime();
    }

    @NotNull
    public final Vector3f getStart() {
        return this.start;
    }

    @NotNull
    public final Vector3f getEnd() {
        return this.end;
    }

    @NotNull
    public final TrailInfo getInfo() {
        return this.info;
    }

    public final int getLifeTime() {
        return this.lifeTime;
    }

    public final Vector3f getCenter() {
        return this.start.lerp((Vector3fc)this.end, 0.5f, new Vector3f());
    }

    public final float getLength() {
        return this.start.distance((Vector3fc)this.end);
    }

    public final boolean isExpired() {
        return this.lifeTime <= 0;
    }

    public final void tick() {
        if (this.lifeTime > 0) {
            int n = this.lifeTime;
            this.lifeTime = n + -1;
        }
    }

    public final float getProgress(float partialTicks) {
        return RangesKt.coerceIn((float)(1.0f - ((float)this.lifeTime - partialTicks) / (float)this.info.getLifeTime()), (float)0.0f, (float)1.0f);
    }

    @NotNull
    public final Color getColor(float partialTicks) {
        return ColorUtilKt.setAlpha(this.info.getColor(), 1.0f - this.getProgress(partialTicks));
    }

    @NotNull
    public final Vector3f component1() {
        return this.start;
    }

    @NotNull
    public final Vector3f component2() {
        return this.end;
    }

    @NotNull
    public final TrailInfo component3() {
        return this.info;
    }

    @NotNull
    public final TrailPoint copy(@NotNull Vector3f start2, @NotNull Vector3f end, @NotNull TrailInfo info) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return new TrailPoint(start2, end, info);
    }

    public static /* synthetic */ TrailPoint copy$default(TrailPoint trailPoint, Vector3f vector3f, Vector3f vector3f2, TrailInfo trailInfo, int n, Object object) {
        if ((n & 1) != 0) {
            vector3f = trailPoint.start;
        }
        if ((n & 2) != 0) {
            vector3f2 = trailPoint.end;
        }
        if ((n & 4) != 0) {
            trailInfo = trailPoint.info;
        }
        return trailPoint.copy(vector3f, vector3f2, trailInfo);
    }

    @NotNull
    public String toString() {
        return "TrailPoint(start=" + this.start + ", end=" + this.end + ", info=" + this.info + ")";
    }

    public int hashCode() {
        int result = this.start.hashCode();
        result = result * 31 + this.end.hashCode();
        result = result * 31 + this.info.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TrailPoint)) {
            return false;
        }
        TrailPoint trailPoint = (TrailPoint)other;
        if (!Intrinsics.areEqual((Object)this.start, (Object)trailPoint.start)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.end, (Object)trailPoint.end)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.info, (Object)trailPoint.info);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0015\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0086\u0002J\u0015\u0010\u000e\u001a\u00020\f*\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0086\u0002J&\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ.\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0015"}, d2={"Lcn/solarmoon/spark_core/visual_effect/trail/TrailPoint$Companion;", "", "<init>", "()V", "catmullRomSpline", "Lcn/solarmoon/spark_core/visual_effect/trail/TrailPoint;", "prev", "now", "next", "t", "", "minus", "Lorg/joml/Vector3f;", "other", "plus", "bezierQuadratic", "p0", "p1", "p2", "bezierCubic", "p3", "SparkCore-1.21.1-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TrailPoint catmullRomSpline(@NotNull TrailPoint prev, @NotNull TrailPoint now, @NotNull TrailPoint next, float t) {
            Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
            Intrinsics.checkNotNullParameter((Object)now, (String)"now");
            Intrinsics.checkNotNullParameter((Object)next, (String)"next");
            Vector3f deltaStart = this.minus(next.getStart(), now.getStart());
            Vector3f deltaEnd = this.minus(next.getEnd(), now.getEnd());
            Vector3f nextNextStartInferred = this.plus(next.getStart(), deltaStart);
            Vector3f nextNextEndInferred = this.plus(next.getEnd(), deltaEnd);
            Vector3f interpolatedStart = SparkMathKt.catmullromVector3f(prev.getStart(), now.getStart(), next.getStart(), nextNextStartInferred, t);
            Vector3f interpolatedEnd = SparkMathKt.catmullromVector3f(prev.getEnd(), now.getEnd(), next.getEnd(), nextNextEndInferred, t);
            return new TrailPoint(interpolatedStart, interpolatedEnd, now.getInfo());
        }

        @NotNull
        public final Vector3f minus(@NotNull Vector3f $this$minus, @NotNull Vector3f other) {
            Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return new Vector3f($this$minus.x - other.x, $this$minus.y - other.y, $this$minus.z - other.z);
        }

        @NotNull
        public final Vector3f plus(@NotNull Vector3f $this$plus, @NotNull Vector3f other) {
            Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return new Vector3f($this$plus.x + other.x, $this$plus.y + other.y, $this$plus.z + other.z);
        }

        @NotNull
        public final TrailPoint bezierQuadratic(@NotNull TrailPoint p0, @NotNull TrailPoint p1, @NotNull TrailPoint p2, float t) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            Vector3f start2 = new Vector3f();
            Vector3f end = new Vector3f();
            float u = 1.0f - t;
            float tt = t * t;
            float uu = u * u;
            start2.set((Vector3fc)p0.getStart()).mul(uu).add((Vector3fc)p1.getStart().mul((float)2 * u * t, new Vector3f())).add((Vector3fc)p2.getStart().mul(tt, new Vector3f()));
            end.set((Vector3fc)p0.getEnd()).mul(uu).add((Vector3fc)p1.getEnd().mul((float)2 * u * t, new Vector3f())).add((Vector3fc)p2.getEnd().mul(tt, new Vector3f()));
            return new TrailPoint(start2, end, p2.getInfo());
        }

        @NotNull
        public final TrailPoint bezierCubic(@NotNull TrailPoint p0, @NotNull TrailPoint p1, @NotNull TrailPoint p2, @NotNull TrailPoint p3, float t) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
            Vector3f start2 = new Vector3f();
            Vector3f end = new Vector3f();
            float u = 1.0f - t;
            float tt = t * t;
            float uu = u * u;
            float uuu = uu * u;
            float ttt = tt * t;
            start2.set((Vector3fc)p0.getStart()).mul(uuu).add((Vector3fc)p1.getStart().mul((float)3 * uu * t, new Vector3f())).add((Vector3fc)p2.getStart().mul((float)3 * u * tt, new Vector3f())).add((Vector3fc)p3.getStart().mul(ttt, new Vector3f()));
            end.set((Vector3fc)p0.getEnd()).mul(uuu).add((Vector3fc)p1.getEnd().mul((float)3 * uu * t, new Vector3f())).add((Vector3fc)p2.getEnd().mul((float)3 * u * tt, new Vector3f())).add((Vector3fc)p3.getEnd().mul(ttt, new Vector3f()));
            return new TrailPoint(start2, end, p3.getInfo());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

