/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.visual_effect.trail;

import cn.solarmoon.spark_core.physics.level.PhysicsLevel;
import cn.solarmoon.spark_core.registry.client.SparkShaders;
import cn.solarmoon.spark_core.visual_effect.VisualEffectRenderer;
import cn.solarmoon.spark_core.visual_effect.trail.TrailElement;
import cn.solarmoon.spark_core.visual_effect.trail.TrailInfo;
import cn.solarmoon.spark_core.visual_effect.trail.TrailMesh;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J0\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J&\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bJ(\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001eH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006&"}, d2={"Lcn/solarmoon/spark_core/visual_effect/trail/TrailRenderer;", "Lcn/solarmoon/spark_core/visual_effect/VisualEffectRenderer;", "<init>", "()V", "meshes", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcn/solarmoon/spark_core/visual_effect/trail/TrailMesh;", "getMeshes", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "createMesh", "info", "Lcn/solarmoon/spark_core/visual_effect/trail/TrailInfo;", "physTick", "", "physLevel", "Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;", "tick", "render", "mc", "Lnet/minecraft/client/Minecraft;", "camPos", "Lnet/minecraft/world/phys/Vec3;", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "partialTicks", "", "renderMesh", "mesh", "Lorg/joml/Vector3f;", "buffer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "calculateNormal", "v0", "v1", "v2", "v3", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nTrailRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrailRenderer.kt\ncn/solarmoon/spark_core/visual_effect/trail/TrailRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n1869#2,2:147\n1869#2,2:149\n1869#2,2:151\n*S KotlinDebug\n*F\n+ 1 TrailRenderer.kt\ncn/solarmoon/spark_core/visual_effect/trail/TrailRenderer\n*L\n37#1:147,2\n49#1:149,2\n82#1:151,2\n*E\n"})
public final class TrailRenderer
extends VisualEffectRenderer {
    @NotNull
    private final ConcurrentLinkedQueue<TrailMesh> meshes = new ConcurrentLinkedQueue();

    @NotNull
    public final ConcurrentLinkedQueue<TrailMesh> getMeshes() {
        return this.meshes;
    }

    @NotNull
    public final TrailMesh createMesh(@NotNull TrailInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        TrailMesh mesh = new TrailMesh(info);
        this.meshes.add(mesh);
        return mesh;
    }

    @Override
    public void physTick(@NotNull PhysicsLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
    }

    @Override
    public void tick() {
        Iterable $this$forEach$iv = this.meshes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrailMesh it = (TrailMesh)element$iv;
            boolean bl = false;
            it.tick();
        }
    }

    @Override
    public void render(@NotNull Minecraft mc, @NotNull Vec3 camPos, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        Intrinsics.checkNotNullParameter((Object)camPos, (String)"camPos");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        Iterable $this$forEach$iv = this.meshes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrailMesh mesh = (TrailMesh)element$iv;
            boolean bl = false;
            RenderSystem.enableDepthTest();
            RenderSystem.disableCull();
            RenderSystem.setShaderTexture((int)0, (int)Minecraft.getInstance().getMainRenderTarget().getColorTextureId());
            RenderSystem.setShaderTexture((int)1, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"spark_core", (String)"textures/test.png"));
            RenderSystem.setShader(TrailRenderer::render$lambda$3$lambda$1);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.NEW_ENTITY);
            mesh.frame(partialTicks);
            Intrinsics.checkNotNull((Object)mesh);
            Vector3f vector3f = camPos.toVector3f();
            Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"toVector3f(...)");
            Intrinsics.checkNotNull((Object)builder);
            this.renderMesh(mesh, vector3f, (VertexConsumer)builder, partialTicks);
            if (builder.build() != null) {
                MeshData meshData;
                MeshData $this$render_u24lambda_u243_u24lambda_u242 = meshData;
                boolean bl2 = false;
                BufferUploader.drawWithShader((MeshData)$this$render_u24lambda_u243_u24lambda_u242);
            }
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
        }
    }

    public final void renderMesh(@NotNull TrailMesh mesh, @NotNull Vector3f camPos, @NotNull VertexConsumer buffer, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)mesh, (String)"mesh");
        Intrinsics.checkNotNullParameter((Object)camPos, (String)"camPos");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int light = 0xF000F0;
        int overlay = OverlayTexture.NO_OVERLAY;
        Iterable $this$forEach$iv = mesh.zipRenderPoints();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrailElement element = (TrailElement)element$iv;
            boolean bl = false;
            Vector3f v0 = element.getP1().getStart().sub((Vector3fc)camPos, new Vector3f());
            Vector3f v1 = element.getP1().getEnd().sub((Vector3fc)camPos, new Vector3f());
            Vector3f v2 = element.getP2().getStart().sub((Vector3fc)camPos, new Vector3f());
            Vector3f v3 = element.getP2().getEnd().sub((Vector3fc)camPos, new Vector3f());
            Vector2f uv0 = element.getUv1();
            Vector2f uv1 = element.getUv2();
            Vector2f uv2 = element.getUv3();
            Vector2f uv3 = element.getUv4();
            Vector3f normal = new Vector3f(0.0f, 1.0f, 0.0f);
            int color1 = element.getP1().getColor(partialTicks).getRGB();
            int color2 = element.getP2().getColor(partialTicks).getRGB();
            buffer.addVertex(v0.x, v0.y, v0.z).setColor(color1).setUv(uv0.x, uv0.y).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            buffer.addVertex(v1.x, v1.y, v1.z).setColor(color1).setUv(uv1.x, uv1.y).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            buffer.addVertex(v3.x, v3.y, v3.z).setColor(color2).setUv(uv3.x, uv3.y).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            buffer.addVertex(v2.x, v2.y, v2.z).setColor(color2).setUv(uv2.x, uv2.y).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
        }
    }

    private final Vector3f calculateNormal(Vector3f v0, Vector3f v1, Vector3f v2, Vector3f v3) {
        Vector3f edge1 = new Vector3f(v1.x - v0.x, v1.y - v0.y, v1.z - v0.z);
        Vector3f edge2 = new Vector3f(v2.x - v0.x, v2.y - v0.y, v2.z - v0.z);
        Vector3f normal = edge1.cross((Vector3fc)edge2);
        Vector3f vector3f = normal.normalize();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"normalize(...)");
        return vector3f;
    }

    private static final ShaderInstance render$lambda$3$lambda$1() {
        return SparkShaders.getSTATIC_DISTORT();
    }
}

