/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.jme3.bullet.MultiBodyLink;
import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.objects.MultiBodyCollider;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class MultiBody
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(MultiBody.class.getName());
    private int numConfigured = 0;
    private MultiBodyCollider baseCollider = null;
    private final MultiBodyLink[] links;

    public MultiBody(int numLinks, float baseMass, Vector3f baseInertia, boolean fixedBase, boolean canSleep) {
        Validate.nonNegative(numLinks, "number of links");
        Validate.positive(baseMass, "base mass");
        Validate.positive(baseInertia, "base inertia");
        long nativeId = this.create(numLinks, baseMass, baseInertia, fixedBase, canSleep);
        super.setNativeId(nativeId);
        assert (MultiBody.getNumLinks(nativeId) == numLinks);
        MultiBody.finalizeMultiDof(nativeId);
        this.links = new MultiBodyLink[numLinks];
    }

    public MultiBodyCollider addBaseCollider(CollisionShape shape) {
        Validate.nonNull(shape, "shape");
        assert (this.baseCollider == null) : this.baseCollider;
        this.baseCollider = new MultiBodyCollider(this, -1);
        long multiBodyId = this.nativeId();
        long colliderId = this.baseCollider.nativeId();
        MultiBody.setBaseCollider(multiBodyId, colliderId);
        this.baseCollider.attachShape(shape);
        assert (MultiBody.getBaseCollider(multiBodyId) == colliderId);
        return this.baseCollider;
    }

    public void addBaseForce(Vector3f force) {
        Validate.finite(force, "force");
        long multiBodyId = this.nativeId();
        MultiBody.addBaseForce(multiBodyId, force);
    }

    public void addBaseTorque(Vector3f torque) {
        Validate.finite(torque, "torque");
        long multiBodyId = this.nativeId();
        MultiBody.addBaseTorque(multiBodyId, torque);
    }

    public float angularDamping() {
        long multiBodyId = this.nativeId();
        float result = MultiBody.getAngularDamping(multiBodyId);
        return result;
    }

    public Vector3f baseAngularVelocity(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long multiBodyId = this.nativeId();
        MultiBody.getBaseOmega(multiBodyId, result);
        return result;
    }

    public Vector3f baseForce(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long multiBodyId = this.nativeId();
        MultiBody.getBaseForce(multiBodyId, result);
        return result;
    }

    public Vector3f baseInertia(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long multiBodyId = this.nativeId();
        MultiBody.getBaseInertia(multiBodyId, result);
        return result;
    }

    public Vector3f baseLocation(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long multiBodyId = this.nativeId();
        MultiBody.getBasePos(multiBodyId, result);
        return result;
    }

    public float baseMass() {
        long multiBodyId = this.nativeId();
        float result = MultiBody.getBaseMass(multiBodyId);
        return result;
    }

    public Quaternion baseOrientation(Quaternion storeResult) {
        Quaternion result = storeResult == null ? new Quaternion() : storeResult;
        long multiBodyId = this.nativeId();
        MultiBody.getWorldToBaseRot(multiBodyId, result);
        return result;
    }

    public Vector3f baseTorque(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long multiBodyId = this.nativeId();
        MultiBody.getBaseTorque(multiBodyId, result);
        return result;
    }

    public Transform baseTransform(Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        long multiBodyId = this.nativeId();
        MultiBody.getBaseWorldTransform(multiBodyId, result);
        return result;
    }

    public Vector3f baseVelocity(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long multiBodyId = this.nativeId();
        MultiBody.getBaseVel(multiBodyId, result);
        return result;
    }

    public boolean canSleep() {
        long multiBodyId = this.nativeId();
        boolean result = MultiBody.getCanSleep(multiBodyId);
        return result;
    }

    public boolean canWakeup() {
        long multiBodyId = this.nativeId();
        boolean result = MultiBody.getCanWakeup(multiBodyId);
        return result;
    }

    public void clearConstraintForces() {
        long multiBodyId = this.nativeId();
        MultiBody.clearConstraintForces(multiBodyId);
    }

    public void clearForcesAndTorques() {
        long multiBodyId = this.nativeId();
        MultiBody.clearForcesAndTorques(multiBodyId);
    }

    public void clearVelocities() {
        long multiBodyId = this.nativeId();
        MultiBody.clearVelocities(multiBodyId);
    }

    public int collideWithGroups() {
        long multiBodyId = this.nativeId();
        int result = MultiBody.getCollideWithGroups(multiBodyId);
        return result;
    }

    public int collisionGroup() {
        long multiBodyId = this.nativeId();
        int result = MultiBody.getCollisionGroup(multiBodyId);
        assert (Integer.bitCount(result) == 1) : result;
        return result;
    }

    public MultiBodyLink configureFixedLink(float mass, Vector3f inertia, MultiBodyLink parent, Quaternion orientation, Vector3f parent2Pivot, Vector3f pivot2Link) {
        Validate.positive(mass, "mass");
        Validate.positive(inertia, "inertia");
        Validate.nonNull(orientation, "orientation");
        Validate.nonNull(parent2Pivot, "parent to pivot offset");
        Validate.nonNull(pivot2Link, "pivot to link offset");
        assert (this.numConfigured < this.links.length);
        long multiBodyId = this.nativeId();
        int parentIndex = parent == null ? -1 : parent.index();
        MultiBody.setupFixed(multiBodyId, this.numConfigured, mass, inertia, parentIndex, orientation, parent2Pivot, pivot2Link);
        MultiBodyLink result = this.configureLink();
        return result;
    }

    public MultiBodyLink configurePlanarLink(float mass, Vector3f inertia, MultiBodyLink parent, Quaternion orientation, Vector3f axis, Vector3f parent2Link, boolean disableCollision) {
        Validate.positive(mass, "mass");
        Validate.positive(inertia, "inertia");
        Validate.nonNull(orientation, "orientation");
        Validate.nonNull(axis, "axis");
        Validate.nonNull(parent2Link, "parent to link offset");
        assert (this.numConfigured < this.links.length);
        long multiBodyId = this.nativeId();
        int parentIndex = parent == null ? -1 : parent.index();
        MultiBody.setupPlanar(multiBodyId, this.numConfigured, mass, inertia, parentIndex, orientation, axis, parent2Link, disableCollision);
        MultiBodyLink result = this.configureLink();
        return result;
    }

    public MultiBodyLink configurePrismaticLink(float mass, Vector3f inertia, MultiBodyLink parent, Quaternion orientation, Vector3f axis, Vector3f parent2Pivot, Vector3f pivot2Link, boolean disableCollision) {
        Validate.positive(mass, "mass");
        Validate.positive(inertia, "inertia");
        Validate.nonNull(orientation, "orientation");
        Validate.nonNull(axis, "axis");
        Validate.nonNull(parent2Pivot, "parent to pivot offset");
        Validate.nonNull(pivot2Link, "pivot to link offset");
        assert (this.numConfigured < this.links.length);
        long multiBodyId = this.nativeId();
        int parentIndex = parent == null ? -1 : parent.index();
        MultiBody.setupPrismatic(multiBodyId, this.numConfigured, mass, inertia, parentIndex, orientation, axis, parent2Pivot, pivot2Link, disableCollision);
        MultiBodyLink result = this.configureLink();
        return result;
    }

    public MultiBodyLink configureRevoluteLink(float mass, Vector3f inertia, MultiBodyLink parent, Quaternion orientation, Vector3f axis, Vector3f parent2Pivot, Vector3f pivot2Link, boolean disableCollision) {
        Validate.positive(mass, "mass");
        Validate.positive(inertia, "inertia");
        Validate.nonNull(orientation, "orientation");
        Validate.nonNull(axis, "axis");
        Validate.nonNull(parent2Pivot, "parent to pivot offset");
        Validate.nonNull(pivot2Link, "pivot to link offset");
        assert (this.numConfigured < this.links.length);
        long multiBodyId = this.nativeId();
        int parentIndex = parent == null ? -1 : parent.index();
        MultiBody.setupRevolute(multiBodyId, this.numConfigured, mass, inertia, parentIndex, orientation, axis, parent2Pivot, pivot2Link, disableCollision);
        MultiBodyLink result = this.configureLink();
        return result;
    }

    public MultiBodyLink configureSphericalLink(float mass, Vector3f inertia, MultiBodyLink parent, Quaternion orientation, Vector3f parent2Pivot, Vector3f pivot2Link, boolean disableCollision) {
        Validate.positive(mass, "mass");
        Validate.positive(inertia, "inertia");
        Validate.nonNull(orientation, "orientation");
        Validate.nonNull(parent2Pivot, "parent to pivot offset");
        Validate.nonNull(pivot2Link, "pivot to link offset");
        assert (this.numConfigured < this.links.length);
        long multiBodyId = this.nativeId();
        int parentIndex = parent == null ? -1 : parent.index();
        MultiBody.setupSpherical(multiBodyId, this.numConfigured, mass, inertia, parentIndex, orientation, parent2Pivot, pivot2Link, disableCollision);
        MultiBodyLink result = this.configureLink();
        return result;
    }

    public boolean contains(MultiBodyCollider collider) {
        boolean result = false;
        for (MultiBodyLink link : this.links) {
            if (link == null || link.getCollider() != collider) continue;
            result = true;
            break;
        }
        if (!result && collider == this.baseCollider) {
            result = true;
        }
        return result;
    }

    public int countConfiguredLinks() {
        assert (this.numConfigured >= 0) : this.numConfigured;
        return this.numConfigured;
    }

    public int countDofs() {
        long multiBodyId = this.nativeId();
        int result = MultiBody.getNumDofs(multiBodyId);
        return result;
    }

    public int countPositionVariables() {
        long multiBodyId = this.nativeId();
        int result = MultiBody.getNumPosVars(multiBodyId);
        return result;
    }

    public MultiBodyCollider getBaseCollider() {
        assert (this.baseCollider != null ? MultiBody.getBaseCollider(this.nativeId()) == this.baseCollider.nativeId() : MultiBody.getBaseCollider(this.nativeId()) == 0L);
        return this.baseCollider;
    }

    public MultiBodyLink getLink(int linkIndex) {
        Validate.inRange(linkIndex, "link index", 0, this.numConfigured - 1);
        MultiBodyLink result = this.links[linkIndex];
        assert (result != null);
        return result;
    }

    public boolean hasFixedBase() {
        long multiBodyId = this.nativeId();
        boolean result = MultiBody.hasFixedBase(multiBodyId);
        return result;
    }

    public boolean isUsingGlobalVelocities() {
        long multiBodyId = this.nativeId();
        boolean result = MultiBody.isUsingGlobalVelocities(multiBodyId);
        return result;
    }

    public boolean isUsingGyroTerm() {
        long multiBodyId = this.nativeId();
        boolean result = MultiBody.getUseGyroTerm(multiBodyId);
        return result;
    }

    public boolean isUsingRK4() {
        long multiBodyId = this.nativeId();
        boolean result = MultiBody.isUsingRK4Integration(multiBodyId);
        return result;
    }

    public float linearDamping() {
        long multiBodyId = this.nativeId();
        float result = MultiBody.getLinearDamping(multiBodyId);
        return result;
    }

    public List<MultiBodyCollider> listColliders() {
        int capacity = this.numConfigured + 1;
        ArrayList<MultiBodyCollider> result = new ArrayList<MultiBodyCollider>(capacity);
        if (this.baseCollider != null) {
            result.add(this.baseCollider);
        }
        for (MultiBodyLink link : this.links) {
            MultiBodyCollider collider;
            if (link == null || (collider = link.getCollider()) == null) continue;
            result.add(collider);
        }
        return result;
    }

    public float maxAppliedImpulse() {
        long multiBodyId = this.nativeId();
        float result = MultiBody.getMaxAppliedImpulse(multiBodyId);
        return result;
    }

    public float maxCoordinateVelocity() {
        long multiBodyId = this.nativeId();
        float result = MultiBody.getMaxCoordinateVelocity(multiBodyId);
        return result;
    }

    public void setBaseAngularVelocity(Vector3f angularVelocity) {
        Validate.finite(angularVelocity, "angular velocity");
        long multiBodyId = this.nativeId();
        MultiBody.setBaseOmega(multiBodyId, angularVelocity);
    }

    public void setBaseLocation(Vector3f location) {
        Validate.finite(location, "location");
        long multiBodyId = this.nativeId();
        MultiBody.setBasePos(multiBodyId, location);
    }

    public void setBaseOrientation(Quaternion orientation) {
        Validate.nonNull(orientation, "orientation");
        long multiBodyId = this.nativeId();
        MultiBody.setWorldToBaseRot(multiBodyId, orientation);
    }

    public void setBaseTransform(Transform transform) {
        Validate.nonNull(transform, "transform");
        long multiBodyId = this.nativeId();
        MultiBody.setBaseWorldTransform(multiBodyId, transform);
    }

    public void setBaseVelocity(Vector3f velocity) {
        Validate.finite(velocity, "velocity");
        long multiBodyId = this.nativeId();
        MultiBody.setBaseVel(multiBodyId, velocity);
    }

    public void setCollideWithGroups(int groups) {
        long multiBodyId = this.nativeId();
        MultiBody.setCollideWithGroups(multiBodyId, groups);
    }

    public void setCollisionGroup(int group) {
        Validate.require(Integer.bitCount(group) == 1, "exactly one bit set");
        long multiBodyId = this.nativeId();
        MultiBody.setCollisionGroup(multiBodyId, group);
    }

    public void setUserIndex(int index) {
        long multiBodyId = this.nativeId();
        MultiBody.setUserIndex(multiBodyId, index);
    }

    public void setUserIndex2(int index) {
        long multiBodyId = this.nativeId();
        MultiBody.setUserIndex2(multiBodyId, index);
    }

    public long spaceId() {
        long multiBodyId = this.nativeId();
        long spaceId = MultiBody.getSpace(multiBodyId);
        return spaceId;
    }

    public void useGlobalVelocities(boolean setting) {
        long multiBodyId = this.nativeId();
        MultiBody.useGlobalVelocities(multiBodyId, setting);
    }

    public void useRK4(boolean setting) {
        long multiBodyId = this.nativeId();
        MultiBody.useRK4Integration(multiBodyId, setting);
    }

    public int userIndex() {
        long multiBodyId = this.nativeId();
        int result = MultiBody.getUserIndex(multiBodyId);
        return result;
    }

    public int userIndex2() {
        long multiBodyId = this.nativeId();
        int result = MultiBody.getUserIndex2(multiBodyId);
        return result;
    }

    private MultiBodyLink configureLink() {
        MultiBodyLink result;
        int linkIndex = this.numConfigured++;
        long multiBodyId = this.nativeId();
        MultiBody.finalizeMultiDof(multiBodyId);
        this.links[linkIndex] = result = new MultiBodyLink(this, linkIndex);
        return result;
    }

    private static void freeNativeObject(long multiBodyId) {
        assert (multiBodyId != 0L);
        MultiBody.finalizeNative(multiBodyId);
    }

    private static native void addBaseForce(long var0, Vector3f var2);

    private static native void addBaseTorque(long var0, Vector3f var2);

    private static native void clearConstraintForces(long var0);

    private static native void clearForcesAndTorques(long var0);

    private static native void clearVelocities(long var0);

    private native long create(int var1, float var2, Vector3f var3, boolean var4, boolean var5);

    private static native void finalizeMultiDof(long var0);

    private static native void finalizeNative(long var0);

    private static native float getAngularDamping(long var0);

    private static native long getBaseCollider(long var0);

    private static native void getBaseForce(long var0, Vector3f var2);

    private static native void getBaseInertia(long var0, Vector3f var2);

    private static native float getBaseMass(long var0);

    private static native void getBaseOmega(long var0, Vector3f var2);

    private static native void getBasePos(long var0, Vector3f var2);

    private static native void getBaseTorque(long var0, Vector3f var2);

    private static native void getBaseVel(long var0, Vector3f var2);

    private static native void getBaseWorldTransform(long var0, Transform var2);

    private static native boolean getCanSleep(long var0);

    private static native boolean getCanWakeup(long var0);

    private static native int getCollideWithGroups(long var0);

    private static native int getCollisionGroup(long var0);

    private static native float getLinearDamping(long var0);

    private static native float getMaxAppliedImpulse(long var0);

    private static native float getMaxCoordinateVelocity(long var0);

    private static native int getNumDofs(long var0);

    private static native int getNumLinks(long var0);

    private static native int getNumPosVars(long var0);

    private static native long getSpace(long var0);

    private static native boolean getUseGyroTerm(long var0);

    private static native int getUserIndex(long var0);

    private static native int getUserIndex2(long var0);

    private static native void getWorldToBaseRot(long var0, Quaternion var2);

    private static native boolean hasFixedBase(long var0);

    private static native boolean isUsingGlobalVelocities(long var0);

    private static native boolean isUsingRK4Integration(long var0);

    private static native void setBaseCollider(long var0, long var2);

    private static native void setBaseOmega(long var0, Vector3f var2);

    private static native void setBasePos(long var0, Vector3f var2);

    private static native void setBaseVel(long var0, Vector3f var2);

    private static native void setBaseWorldTransform(long var0, Transform var2);

    private static native void setCollideWithGroups(long var0, int var2);

    private static native void setCollisionGroup(long var0, int var2);

    private static native void setupFixed(long var0, int var2, float var3, Vector3f var4, int var5, Quaternion var6, Vector3f var7, Vector3f var8);

    private static native void setupPlanar(long var0, int var2, float var3, Vector3f var4, int var5, Quaternion var6, Vector3f var7, Vector3f var8, boolean var9);

    private static native void setupPrismatic(long var0, int var2, float var3, Vector3f var4, int var5, Quaternion var6, Vector3f var7, Vector3f var8, Vector3f var9, boolean var10);

    private static native void setupRevolute(long var0, int var2, float var3, Vector3f var4, int var5, Quaternion var6, Vector3f var7, Vector3f var8, Vector3f var9, boolean var10);

    private static native void setupSpherical(long var0, int var2, float var3, Vector3f var4, int var5, Quaternion var6, Vector3f var7, Vector3f var8, boolean var9);

    private static native void setUserIndex(long var0, int var2);

    private static native void setUserIndex2(long var0, int var2);

    private static native void setWorldToBaseRot(long var0, Quaternion var2);

    private static native void useGlobalVelocities(long var0, boolean var2);

    private static native void useRK4Integration(long var0, boolean var2);
}

