/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.jme3.bullet.MultiBody;
import com.jme3.bullet.MultiBodyJointType;
import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.objects.MultiBodyCollider;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class MultiBodyLink
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(MultiBodyLink.class.getName());
    private final int linkIndex;
    private final int numDofs;
    private final long multiBodyId;
    private final MultiBody multiBody;
    private MultiBodyCollider collider = null;
    private final MultiBodyLink parentLink;

    MultiBodyLink(MultiBody multiBody, int index) {
        Validate.nonNull(multiBody, "multibody");
        Validate.nonNegative(index, "index");
        this.linkIndex = index;
        this.multiBody = multiBody;
        this.multiBodyId = multiBody.nativeId();
        long linkId = MultiBodyLink.getLinkId(this.multiBodyId, index);
        super.setNativeIdNotTracked(linkId);
        this.numDofs = MultiBodyLink.getDofCount(linkId);
        int parentIndex = MultiBodyLink.getParentIndex(linkId);
        this.parentLink = parentIndex == -1 ? null : multiBody.getLink(parentIndex);
    }

    public MultiBodyCollider addCollider(CollisionShape shape) {
        Validate.nonNull(shape, "shape");
        assert (this.collider == null) : this.collider;
        this.collider = new MultiBodyCollider(this.multiBody, this.linkIndex);
        long linkId = this.nativeId();
        long colliderId = this.collider.nativeId();
        MultiBodyLink.setCollider(linkId, colliderId);
        this.collider.attachShape(shape);
        return this.collider;
    }

    public void addConstraintForce(Vector3f force) {
        Validate.finite(force, "force");
        long linkId = this.nativeId();
        MultiBodyLink.addConstraintForce(linkId, force);
    }

    public void addConstraintTorque(Vector3f torque) {
        Validate.finite(torque, "torque");
        long linkId = this.nativeId();
        MultiBodyLink.addConstraintTorque(linkId, torque);
    }

    public void addForce(Vector3f force) {
        Validate.finite(force, "force");
        long linkId = this.nativeId();
        MultiBodyLink.addForce(linkId, force);
    }

    public void addJointTorque(int dofIndex, float torque) {
        Validate.inRange(dofIndex, "DOF index", 0, this.numDofs - 1);
        long linkId = this.nativeId();
        MultiBodyLink.addJointTorque(linkId, dofIndex, torque);
    }

    public void addTorque(Vector3f torque) {
        Validate.finite(torque, "torque");
        long linkId = this.nativeId();
        MultiBodyLink.addTorque(linkId, torque);
    }

    public Vector3f appliedForce(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long linkId = this.nativeId();
        MultiBodyLink.getAppliedForce(linkId, result);
        return result;
    }

    public Vector3f appliedTorque(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long linkId = this.nativeId();
        MultiBodyLink.getAppliedTorque(linkId, result);
        return result;
    }

    public Vector3f axis(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        MultiBodyJointType jointType = this.jointType();
        long linkId = this.nativeId();
        switch (jointType) {
            case Planar: 
            case Revolute: {
                MultiBodyLink.getAxisTop(linkId, 0, result);
                break;
            }
            case Prismatic: {
                MultiBodyLink.getAxisBottom(linkId, 0, result);
                break;
            }
            default: {
                throw new IllegalStateException("jointType = " + String.valueOf((Object)jointType));
            }
        }
        return result;
    }

    public Vector3f constraintForce(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long linkId = this.nativeId();
        MultiBodyLink.getConstraintForce(linkId, result);
        return result;
    }

    public Vector3f constraintTorque(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long linkId = this.nativeId();
        MultiBodyLink.getConstraintTorque(linkId, result);
        return result;
    }

    public int countDofs() {
        assert (this.numDofs == MultiBodyLink.getDofCount(this.nativeId()));
        return this.numDofs;
    }

    public int countPositionVariables() {
        long linkId = this.nativeId();
        int result = MultiBodyLink.getPosVarCount(linkId);
        return result;
    }

    public MultiBodyCollider getCollider() {
        if (this.collider == null ? !$assertionsDisabled && MultiBodyLink.getCollider(this.multiBodyId, this.linkIndex) != 0L : !$assertionsDisabled && MultiBodyLink.getCollider(this.multiBodyId, this.linkIndex) != this.collider.nativeId()) {
            throw new AssertionError();
        }
        return this.collider;
    }

    public MultiBody getMultiBody() {
        assert (this.multiBody != null);
        return this.multiBody;
    }

    public MultiBodyLink getParentLink() {
        return this.parentLink;
    }

    public int index() {
        assert (this.linkIndex >= 0) : this.linkIndex;
        return this.linkIndex;
    }

    public Vector3f inertia(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long linkId = this.nativeId();
        MultiBodyLink.getInertiaLocal(linkId, result);
        return result;
    }

    public boolean isCollisionWithParent() {
        int disableParentCollision;
        long linkId = this.nativeId();
        int flags = MultiBodyLink.getFlags(linkId);
        return (flags & (disableParentCollision = 1)) == 0;
    }

    public float jointPosition(int dofIndex) {
        Validate.inRange(dofIndex, "DOF index", 0, this.numDofs - 1);
        long linkId = this.nativeId();
        float result = MultiBodyLink.getJointPos(linkId, dofIndex);
        return result;
    }

    public float jointTorque(int dofIndex) {
        Validate.inRange(dofIndex, "DOF index", 0, this.numDofs - 1);
        long linkId = this.nativeId();
        float result = MultiBodyLink.getJointTorque(linkId, dofIndex);
        return result;
    }

    public MultiBodyJointType jointType() {
        long linkId = this.nativeId();
        int ordinal = MultiBodyLink.getJointType(linkId);
        MultiBodyJointType result = MultiBodyJointType.values()[ordinal];
        return result;
    }

    public float jointVelocity(int dofIndex) {
        Validate.inRange(dofIndex, "DOF index", 0, this.numDofs - 1);
        float result = MultiBodyLink.getJointVel(this.multiBodyId, this.linkIndex, dofIndex);
        return result;
    }

    public Vector3f location(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult.zero();
        MultiBodyLink.localPosToWorld(this.multiBodyId, this.linkIndex, result);
        return result;
    }

    public float mass() {
        long linkId = this.nativeId();
        float result = MultiBodyLink.getMass(linkId);
        return result;
    }

    public Quaternion orientation(Quaternion storeResult) {
        Quaternion result = storeResult == null ? new Quaternion() : storeResult;
        long linkId = this.nativeId();
        MultiBodyLink.getQ0Parent2LinkRotation(linkId, result);
        return result;
    }

    public Vector3f parent2Link(Vector3f storeResult) {
        Vector3f result;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        assert (this.jointType() == MultiBodyJointType.Planar);
        long linkId = this.nativeId();
        MultiBodyLink.getEVector(linkId, result);
        return result;
    }

    public Vector3f parent2Pivot(Vector3f storeResult) {
        Vector3f result;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        assert (this.jointType() != MultiBodyJointType.Planar);
        long linkId = this.nativeId();
        MultiBodyLink.getEVector(linkId, result);
        return result;
    }

    public Vector3f pivot2Link(Vector3f storeResult) {
        Vector3f result;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        assert (this.jointType() != MultiBodyJointType.Planar);
        long linkId = this.nativeId();
        MultiBodyLink.getDVector(linkId, result);
        return result;
    }

    public void setJointPosition(int dofIndex, float position) {
        Validate.inRange(dofIndex, "DOF index", 0, this.numDofs - 1);
        MultiBodyLink.setJointPos(this.multiBodyId, this.linkIndex, dofIndex, position);
    }

    public void setJointVelocity(int dofIndex, float velocity) {
        Validate.inRange(dofIndex, "DOF index", 0, this.numDofs - 1);
        MultiBodyLink.setJointVel(this.multiBodyId, this.linkIndex, dofIndex, velocity);
    }

    public Transform worldTransform(Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        long linkId = this.nativeId();
        MultiBodyLink.getWorldTransform(linkId, result);
        return result;
    }

    private static native void addConstraintForce(long var0, Vector3f var2);

    private static native void addConstraintTorque(long var0, Vector3f var2);

    private static native void addForce(long var0, Vector3f var2);

    private static native void addJointTorque(long var0, int var2, float var3);

    private static native void addTorque(long var0, Vector3f var2);

    private static native void getAppliedForce(long var0, Vector3f var2);

    private static native void getAppliedTorque(long var0, Vector3f var2);

    private static native void getAxisBottom(long var0, int var2, Vector3f var3);

    private static native void getAxisTop(long var0, int var2, Vector3f var3);

    private static native long getCollider(long var0, int var2);

    private static native void getConstraintForce(long var0, Vector3f var2);

    private static native void getConstraintTorque(long var0, Vector3f var2);

    private static native int getDofCount(long var0);

    private static native void getDVector(long var0, Vector3f var2);

    private static native void getEVector(long var0, Vector3f var2);

    private static native int getFlags(long var0);

    private static native void getInertiaLocal(long var0, Vector3f var2);

    private static native float getJointPos(long var0, int var2);

    private static native float getJointTorque(long var0, int var2);

    private static native int getJointType(long var0);

    private static native float getJointVel(long var0, int var2, int var3);

    private static native long getLinkId(long var0, int var2);

    private static native float getMass(long var0);

    private static native void getParent2LinkRotation(long var0, Quaternion var2);

    private static native int getParentIndex(long var0);

    private static native int getPosVarCount(long var0);

    private static native void getQ0Parent2LinkRotation(long var0, Quaternion var2);

    private static native void getWorldTransform(long var0, Transform var2);

    private static native void localFrameToWorld(long var0, int var2, Matrix3f var3);

    private static native void localPosToWorld(long var0, int var2, Vector3f var3);

    private static native void setCollider(long var0, long var2);

    private static native void setJointPos(long var0, int var2, int var3, float var4);

    private static native void setJointVel(long var0, int var2, int var3, float var4);

    private static native void worldPosToLocal(long var0, int var2, Vector3f var3);
}

