/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import java.util.ArrayList;
import java.util.logging.Logger;

public final class SolverMode {
    public static final int RandomOrder = 1;
    public static final int Separate = 2;
    public static final int WarmStart = 4;
    public static final int Use2Directions = 16;
    public static final int CacheDirection = 32;
    public static final int NoVelocityDependent = 64;
    public static final int CacheFriendly = 128;
    public static final int SIMD = 256;
    public static final int Interleave = 512;
    public static final int AllowZeroLength = 1024;
    public static final int NoCone = 2048;
    public static final int ArticulatedWarmStart = 4096;
    public static final Logger logger = Logger.getLogger(SolverMode.class.getName());

    private SolverMode() {
    }

    public static String describe(int flags) {
        ArrayList<String> flagList = new ArrayList<String>(12);
        if ((flags & 1) != 0) {
            flagList.add("RandomOrder");
        }
        if ((flags & 2) != 0) {
            flagList.add("Separate");
        }
        if ((flags & 4) != 0) {
            flagList.add("WarmStart");
        }
        if ((flags & 0x10) != 0) {
            flagList.add("Use2Directions");
        }
        if ((flags & 0x40) == 0) {
            flagList.add("VelocityDependent");
        }
        if ((flags & 0x80) != 0) {
            flagList.add("CacheFriendly");
        }
        if ((flags & 0x100) != 0) {
            flagList.add("SIMD");
        }
        if ((flags & 0x200) != 0) {
            flagList.add("Interleave");
        }
        if ((flags & 0x400) != 0) {
            flagList.add("AllowZeroLength");
        }
        if ((flags & 0x800) == 0) {
            flagList.add("Cone");
        }
        if ((flags & 0x1000) != 0) {
            flagList.add("ArticulatedWarmStart");
        }
        StringBuilder result = new StringBuilder(40);
        boolean addSeparators = false;
        for (String flagName : flagList) {
            if (addSeparators) {
                result.append(',');
            } else {
                addSeparators = true;
            }
            result.append(flagName);
        }
        return result.toString();
    }
}

