/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bounding.BoundingBox;
import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.simsilica.mathd.Vec3d;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;
import jme3utilities.minie.MyShape;

public abstract class CollisionShape
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(CollisionShape.class.getName());
    private static final Quaternion rotateIdentity = new Quaternion();
    private static final Transform transformIdentity = new Transform();
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    protected boolean enableContactFilter = false;
    private static float defaultMargin = 0.04f;
    protected float margin = defaultMargin;
    protected Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);

    protected CollisionShape() {
    }

    public Vector3f aabbCenter(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        BoundingBox aabb = this.boundingBox(translateIdentity, rotateIdentity, null);
        aabb.getCenter(result);
        return result;
    }

    public BoundingBox boundingBox(Vector3f translation, Matrix3f rotation, BoundingBox storeResult) {
        Validate.finite(translation, "translation");
        Validate.nonNull(rotation, "rotation");
        BoundingBox result = storeResult == null ? new BoundingBox() : storeResult;
        this.recalculateAabb();
        long shapeId = this.nativeId();
        Vector3f maxima = new Vector3f();
        Vector3f minima = new Vector3f();
        CollisionShape.getAabb(shapeId, translation, rotation, minima, maxima);
        result.setMinMax(minima, maxima);
        return result;
    }

    public BoundingBox boundingBoxWithoutRecalculate(Vector3f translation, Matrix3f rotation, BoundingBox storeResult) {
        Validate.finite(translation, "translation");
        Validate.nonNull(rotation, "rotation");
        BoundingBox result = storeResult == null ? new BoundingBox() : storeResult;
        long shapeId = this.nativeId();
        Vector3f maxima = new Vector3f();
        Vector3f minima = new Vector3f();
        CollisionShape.getAabb(shapeId, translation, rotation, minima, maxima);
        result.setMinMax(minima, maxima);
        return result;
    }

    public BoundingBox boundingBox(Vector3f translation, Quaternion rotation, BoundingBox storeResult) {
        Validate.finite(translation, "translation");
        Validate.nonNull(rotation, "rotation");
        BoundingBox result = storeResult == null ? new BoundingBox() : storeResult;
        this.recalculateAabb();
        long shapeId = this.nativeId();
        Matrix3f basisMatrix = new Matrix3f().set(rotation);
        Vector3f maxima = new Vector3f();
        Vector3f minima = new Vector3f();
        CollisionShape.getAabb(shapeId, translation, basisMatrix, minima, maxima);
        result.setMinMax(minima, maxima);
        return result;
    }

    public boolean canScale(Vector3f scale) {
        boolean result = scale == null ? false : MyVector3f.isAllNonNegative(scale);
        return result;
    }

    public boolean canSplit() {
        return false;
    }

    public static float getDefaultMargin() {
        assert (defaultMargin > 0.0f) : defaultMargin;
        return defaultMargin;
    }

    public float getMargin() {
        assert (this.margin >= 0.0f) : this.margin;
        assert (this.margin == this.nativeMargin()) : this.margin + " != " + this.nativeMargin();
        return this.margin;
    }

    public Vector3f getScale(Vector3f storeResult) {
        Vector3f result;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        assert (this.checkScale(result));
        result.set(this.scale);
        return result;
    }

    public Vec3d getScaleDp(Vec3d storeResult) {
        long shapeId = this.nativeId();
        Vec3d result = storeResult == null ? new Vec3d() : storeResult;
        CollisionShape.getLocalScalingDp(shapeId, result);
        return result;
    }

    public int getShapeType() {
        long shapeId = this.nativeId();
        int result = CollisionShape.getShapeType(shapeId);
        return result;
    }

    public boolean isConcave() {
        long shapeId = this.nativeId();
        boolean result = CollisionShape.isConcave(shapeId);
        return result;
    }

    public boolean isContactFilterEnabled() {
        assert (this.enableContactFilter == CollisionShape.isContactFilterEnabled(this.nativeId())) : "copy of flag = " + this.enableContactFilter;
        return this.enableContactFilter;
    }

    public boolean isConvex() {
        long shapeId = this.nativeId();
        boolean result = CollisionShape.isConvex(shapeId);
        return result;
    }

    public boolean isInfinite() {
        long shapeId = this.nativeId();
        boolean result = CollisionShape.isInfinite(shapeId);
        return result;
    }

    public boolean isNonMoving() {
        long shapeId = this.nativeId();
        boolean result = CollisionShape.isNonMoving(shapeId);
        return result;
    }

    public boolean isPolyhedral() {
        long shapeId = this.nativeId();
        boolean result = CollisionShape.isPolyhedral(shapeId);
        return result;
    }

    public float maxRadius() {
        float result = DebugShapeFactory.maxDistance(this, transformIdentity, 0);
        return result;
    }

    public float scaledVolume() {
        throw new UnsupportedOperationException("Not implemented for: " + String.valueOf(this));
    }

    public void setContactFilterEnabled(boolean setting) {
        long shapeId = this.nativeId();
        CollisionShape.setContactFilterEnabled(shapeId, setting);
        this.enableContactFilter = setting;
    }

    public static void setDefaultMargin(float margin) {
        Validate.positive(margin, "margin");
        defaultMargin = margin;
    }

    public void setMargin(float margin) {
        Validate.positive(margin, "margin");
        long shapeId = this.nativeId();
        CollisionShape.setMargin(shapeId, margin);
        logger.log(Level.FINE, "Margining {0}.", this);
        this.margin = margin;
    }

    public void setScale(float factor) {
        assert (Validate.nonNegative(factor, "factor"));
        Vector3f scaleVector = new Vector3f(factor, factor, factor);
        this.setScale(scaleVector);
    }

    public void setScale(Vector3f scale) {
        if (!this.canScale(scale)) {
            String typeName = this.getClass().getCanonicalName();
            String message = String.format("%s cannot be scaled to (%s,%s,%s)", typeName, Float.valueOf(scale.x), Float.valueOf(scale.y), Float.valueOf(scale.z));
            throw new IllegalArgumentException(message);
        }
        this.scale.set(scale);
        long shapeId = this.nativeId();
        CollisionShape.setLocalScaling(shapeId, scale);
        logger.log(Level.FINE, "Scaling {0}.", this);
    }

    public void setUserIndex(int index) {
        long shapeId = this.nativeId();
        CollisionShape.setUserIndex(shapeId, index);
    }

    public void setUserIndex2(int index) {
        long shapeId = this.nativeId();
        CollisionShape.setUserIndex2(shapeId, index);
    }

    public CollisionShape toSplittableShape() {
        if (this.canSplit()) {
            return this;
        }
        throw new IllegalArgumentException("this = " + String.valueOf(this));
    }

    public int userIndex() {
        long shapeId = this.nativeId();
        int result = CollisionShape.getUserIndex(shapeId);
        return result;
    }

    public int userIndex2() {
        long shapeId = this.nativeId();
        int result = CollisionShape.getUserIndex2(shapeId);
        return result;
    }

    protected static final native int getShapeType(long var0);

    protected final float nativeMargin() {
        long shapeId = this.nativeId();
        float result = CollisionShape.getMargin(shapeId);
        assert (result >= 0.0f) : result;
        return result;
    }

    protected void recalculateAabb() {
    }

    protected void updateScale() {
        long shapeId = this.nativeId();
        CollisionShape.getLocalScaling(shapeId, this.scale);
    }

    @Override
    protected void setNativeId(long shapeId) {
        super.setNativeId(shapeId);
        logger.log(Level.FINE, "Created {0}.", this);
    }

    @Override
    public String toString() {
        Object result = MyShape.describeType(this);
        long shapeId = this.nativeId();
        result = (String)result + "#" + Long.toHexString(shapeId);
        return result;
    }

    private boolean checkScale(Vector3f storeVector) {
        assert (storeVector != null);
        long shapeId = this.nativeId();
        CollisionShape.getLocalScaling(shapeId, storeVector);
        boolean result = this.scale.equals(storeVector);
        if (!result) {
            logger.log(Level.WARNING, "mismatch detected: shape={0} copy={1} native={2}", new Object[]{this, this.scale, storeVector});
        }
        return result;
    }

    private static void freeNativeObject(long shapeId) {
        assert (shapeId != 0L);
        CollisionShape.finalizeNative(shapeId);
    }

    private static native void finalizeNative(long var0);

    private static native void getAabb(long var0, Vector3f var2, Matrix3f var3, Vector3f var4, Vector3f var5);

    private static native void getLocalScaling(long var0, Vector3f var2);

    private static native void getLocalScalingDp(long var0, Vec3d var2);

    private static native float getMargin(long var0);

    private static native int getUserIndex(long var0);

    private static native int getUserIndex2(long var0);

    private static native boolean isConcave(long var0);

    private static native boolean isContactFilterEnabled(long var0);

    private static native boolean isConvex(long var0);

    private static native boolean isInfinite(long var0);

    private static native boolean isNonMoving(long var0);

    private static native boolean isPolyhedral(long var0);

    private static native void setContactFilterEnabled(long var0, boolean var2);

    private static native void setLocalScaling(long var0, Vector3f var2);

    private static native void setMargin(long var0, float var2);

    private static native void setUserIndex(long var0, int var2);

    private static native void setUserIndex2(long var0, int var2);
}

