/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.MyVolume;

public class ConeCollisionShape
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(ConeCollisionShape.class.getName());
    private final float height;
    private final float radius;
    private final int axis;

    public ConeCollisionShape(float radius, float height, int axisIndex) {
        Validate.nonNegative(radius, "radius");
        Validate.nonNegative(height, "height");
        Validate.axisIndex(axisIndex, "axis index");
        this.radius = radius;
        this.height = height;
        this.axis = axisIndex;
        this.createShape();
    }

    public ConeCollisionShape(float radius, float height) {
        Validate.nonNegative(radius, "radius");
        Validate.nonNegative(height, "height");
        this.radius = radius;
        this.height = height;
        this.axis = 1;
        this.createShape();
    }

    public int getAxis() {
        assert (this.axis == 0 || this.axis == 1 || this.axis == 2) : this.axis;
        return this.axis;
    }

    public float getHeight() {
        assert (this.height >= 0.0f) : this.height;
        return this.height;
    }

    public float getRadius() {
        assert (this.radius >= 0.0f) : this.radius;
        return this.radius;
    }

    public float unscaledVolume() {
        float result = MyVolume.coneVolume(this.radius, this.height);
        assert (result >= 0.0f) : result;
        return result;
    }

    @Override
    public boolean canScale(Vector3f scale) {
        boolean canScale = super.canScale(scale) && MyVector3f.isScaleUniform(scale);
        return canScale;
    }

    @Override
    public float maxRadius() {
        float result = MyMath.hypotenuse(this.radius, this.height / 2.0f) * this.scale.x;
        return result += this.margin;
    }

    private void createShape() {
        assert (this.axis == 0 || this.axis == 1 || this.axis == 2) : this.axis;
        assert (this.radius >= 0.0f) : this.radius;
        assert (this.height >= 0.0f) : this.height;
        long shapeId = ConeCollisionShape.createShape(this.axis, this.radius, this.height);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShape(int var0, float var1, float var2);
}

