/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class ConicalFrustum
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(ConicalFrustum.class.getName());
    private final float unscaledA;
    private final float unscaledB;
    private final float unscaledHeight;

    public ConicalFrustum(float a, float b, float height) {
        Validate.positive(a, "A radius");
        Validate.positive(b, "B radius");
        Validate.positive(height, "height");
        this.unscaledA = a;
        this.unscaledB = b;
        this.unscaledHeight = height;
        this.createShape();
    }

    public float aRadius() {
        assert (this.unscaledA > 0.0f) : this.unscaledA;
        return this.unscaledA;
    }

    public float bRadius() {
        assert (this.unscaledB > 0.0f) : this.unscaledB;
        return this.unscaledB;
    }

    public float height() {
        assert (this.unscaledHeight > 0.0f) : this.unscaledHeight;
        return this.unscaledHeight;
    }

    @Override
    public boolean canScale(Vector3f scale) {
        boolean result = super.canScale(scale) && scale.x == scale.z;
        return result;
    }

    @Override
    public float maxRadius() {
        long shapeId = this.nativeId();
        float result = ConicalFrustum.maxRadius(shapeId);
        return result;
    }

    @Override
    public float scaledVolume() {
        long shapeId = this.nativeId();
        float result = ConicalFrustum.scaledVolume(shapeId);
        return result;
    }

    private void createShape() {
        long shapeId = ConicalFrustum.createShapeNative(this.unscaledA, this.unscaledB, this.unscaledHeight);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShapeNative(float var0, float var1, float var2);

    private static native float maxRadius(long var0);

    private static native float scaledVolume(long var0);
}

