/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.math.Vector3f;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class Convex2dShape
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(Convex2dShape.class.getName());
    private final ConvexShape base;

    public Convex2dShape(ConvexShape base2) {
        Validate.nonNull(base2, "base");
        this.base = base2;
        this.createShape();
    }

    public Convex2dShape(FloatBuffer flippedBuffer) {
        Validate.nonNull(flippedBuffer, "flipped buffer");
        int numFloats = flippedBuffer.limit();
        Validate.positive(numFloats, "buffer limit");
        Validate.require(numFloats % 3 == 0, "buffer limit a multiple of 3");
        this.base = new HullCollisionShape(flippedBuffer);
        this.createShape();
    }

    public ConvexShape getBaseShape() {
        assert (this.base != null);
        return this.base;
    }

    @Override
    public boolean canScale(Vector3f scale) {
        boolean result = this.base.canScale(scale);
        return result;
    }

    @Override
    public void setScale(Vector3f scale) {
        super.setScale(scale);
        this.base.updateScale();
    }

    private void createShape() {
        long childId = this.base.nativeId();
        long shapeId = Convex2dShape.createShape(childId);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShape(long var0);
}

