/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;

public abstract class CustomConvexShape
extends ConvexShape {
    public static final Logger loggerY = Logger.getLogger(CustomConvexShape.class.getName());
    protected static final ThreadLocal<Vector3f> threadTmpVector = new ThreadLocal<Vector3f>(){

        @Override
        protected Vector3f initialValue() {
            return new Vector3f();
        }
    };
    private final Vector3f halfExtents;
    private final Vector3f inertia = new Vector3f();

    protected CustomConvexShape(float xHalfExtent, float yHalfExtent, float zHalfExtent) {
        Validate.positive(xHalfExtent, "X half extent");
        Validate.positive(yHalfExtent, "Y half extent");
        Validate.positive(zHalfExtent, "Z half extent");
        this.halfExtents = new Vector3f(xHalfExtent, yHalfExtent, zHalfExtent);
        this.createShape();
    }

    protected CustomConvexShape(Vector3f halfExtents) {
        if (halfExtents == null) {
            this.halfExtents = null;
        } else {
            Validate.positive(halfExtents, "half extents");
            this.halfExtents = halfExtents.clone();
        }
        this.createShape();
    }

    protected abstract Vector3f locateSupport(float var1, float var2, float var3);

    protected void setScaledInertia(float ix, float iy, float iz) {
        Validate.positive(ix, "X-axis inertia");
        Validate.positive(iy, "Y-axis inertia");
        Validate.positive(iz, "Z-axis inertia");
        this.inertia.set(ix, iy, iz);
        long shapeId = this.nativeId();
        CustomConvexShape.setScaledInertia(shapeId, ix, iy, iz);
    }

    private void createShape() {
        long shapeId = this.createShapeNative(this.halfExtents);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setMargin(this.margin);
    }

    private native long createShapeNative(Vector3f var1);

    private static native void setScaledInertia(long var0, float var2, float var3, float var4);
}

