/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.MeshCollisionShape;
import com.jme3.bullet.collision.shapes.infos.IndexedMesh;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public class HeightfieldCollisionShape
extends CollisionShape {
    public static final Logger logger2 = Logger.getLogger(HeightfieldCollisionShape.class.getName());
    private static final Vector3f scaleIdentity = new Vector3f(1.0f, 1.0f, 1.0f);
    private boolean flipQuadEdges = true;
    private boolean flipTriangleWinding = false;
    private boolean useDiamond = false;
    private boolean useZigzag = false;
    private float maxHeight;
    private float minHeight;
    private float[] heightfieldData;
    private FloatBuffer directBuffer;
    private int heightStickLength;
    private int heightStickWidth;
    private int upAxis = 1;

    public HeightfieldCollisionShape(float[] heightArray) {
        Validate.nonEmpty(heightArray, "height array");
        Validate.inRange(heightArray.length, "number of heights", 4, Integer.MAX_VALUE);
        this.createCollisionHeightfield(heightArray, scaleIdentity);
    }

    public HeightfieldCollisionShape(float[] heightArray, Vector3f scale) {
        Validate.nonEmpty(heightArray, "height array");
        Validate.inRange(heightArray.length, "number of heights", 4, Integer.MAX_VALUE);
        Validate.nonNegative(scale, "scale");
        this.createCollisionHeightfield(heightArray, scale);
    }

    public HeightfieldCollisionShape(int stickLength, int stickWidth, float[] heightmap, Vector3f scale, int upAxis, boolean flipQuadEdges, boolean flipTriangleWinding, boolean useDiamond, boolean useZigzag) {
        Validate.inRange(stickLength, "stick length", 2, Integer.MAX_VALUE);
        Validate.inRange(stickWidth, "stick width", 2, Integer.MAX_VALUE);
        Validate.nonEmpty(heightmap, "heightmap");
        assert (heightmap.length >= stickLength * stickWidth) : heightmap.length;
        Validate.nonNegative(scale, "scale");
        Validate.axisIndex(upAxis, "up axis");
        this.heightStickLength = stickLength;
        this.heightStickWidth = stickWidth;
        this.heightfieldData = (float[])heightmap.clone();
        this.scale.set(scale);
        this.upAxis = upAxis;
        this.flipQuadEdges = flipQuadEdges;
        this.flipTriangleWinding = flipTriangleWinding;
        this.useDiamond = useDiamond;
        this.useZigzag = useZigzag;
        this.calculateMinAndMax();
        this.createShape();
    }

    public int countColumns() {
        assert (this.heightStickWidth >= 2) : this.heightStickWidth;
        return this.heightStickWidth;
    }

    public int countMeshVertices() {
        int count = this.heightfieldData.length;
        assert (count >= 4) : count;
        return count;
    }

    public int countRows() {
        assert (this.heightStickLength >= 2) : this.heightStickLength;
        return this.heightStickLength;
    }

    public int upAxis() {
        assert (this.upAxis == 0 || this.upAxis == 1 || this.upAxis == 2) : this.upAxis;
        return this.upAxis;
    }

    @Override
    public CollisionShape toSplittableShape() {
        FloatBuffer buffer = DebugShapeFactory.getDebugTriangles(this, 0);
        IndexedMesh nativeMesh = new IndexedMesh(buffer);
        MeshCollisionShape result = new MeshCollisionShape(true, nativeMesh);
        return result;
    }

    private void calculateMinAndMax() {
        int elements = this.heightStickLength * this.heightStickWidth;
        assert (elements == this.heightfieldData.length) : this.heightfieldData.length;
        float min = this.heightfieldData[0];
        float max = this.heightfieldData[0];
        for (float height : this.heightfieldData) {
            if (height < min) {
                min = height;
            }
            if (!(height > max)) continue;
            max = height;
        }
        if (max < 0.0f) {
            max = -min;
        } else if (Math.abs(max) > Math.abs(min)) {
            min = -max;
        } else {
            max = -min;
        }
        this.minHeight = min;
        this.maxHeight = max;
    }

    private void createCollisionHeightfield(float[] heightArray, Vector3f worldScale) {
        this.scale.set(worldScale);
        this.heightfieldData = (float[])heightArray.clone();
        this.heightStickWidth = (int)FastMath.sqrt(this.heightfieldData.length);
        assert (this.heightStickWidth > 1) : this.heightStickWidth;
        this.heightStickLength = this.heightStickWidth;
        this.calculateMinAndMax();
        this.createShape();
    }

    private void createShape() {
        this.directBuffer = BufferUtils.createFloatBuffer(this.heightfieldData.length);
        for (float height : this.heightfieldData) {
            if (!MyMath.isFinite(height)) {
                throw new IllegalArgumentException("illegal height: " + height);
            }
            this.directBuffer.put(height);
        }
        float heightScale = 1.0f;
        long shapeId = HeightfieldCollisionShape.createShape2(this.heightStickWidth, this.heightStickLength, this.directBuffer, heightScale, this.minHeight, this.maxHeight, this.upAxis, this.flipQuadEdges, this.flipTriangleWinding, this.useDiamond, this.useZigzag);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static void freeNativeObject(long shapeId) {
        assert (shapeId != 0L);
        HeightfieldCollisionShape.finalizeNative(shapeId);
    }

    private static native long createShape2(int var0, int var1, FloatBuffer var2, float var3, float var4, float var5, int var6, boolean var7, boolean var8, boolean var9, boolean var10);

    private static native void finalizeNative(long var0);
}

