/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.math.FastMath;
import com.jme3.math.Plane;
import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.RectangularSolid;
import jme3utilities.math.VectorSetUsingBuffer;
import vhacd.VHACDHull;
import vhacd4.Vhacd4Hull;

public class HullCollisionShape
extends ConvexShape {
    private static final int numAxes = 3;
    public static final Logger logger2 = Logger.getLogger(HullCollisionShape.class.getName());
    private FloatBuffer directBuffer;
    private final float[] points;

    public HullCollisionShape(Collection<Vector3f> locations) {
        Validate.nonEmpty(locations, "locations");
        int numLocations = locations.size();
        this.points = new float[3 * numLocations];
        int j = 0;
        for (Vector3f location : locations) {
            if (!Vector3f.isValidVector(location)) {
                throw new IllegalArgumentException("illegal coordinates: " + String.valueOf(location));
            }
            this.points[j + 0] = location.x;
            this.points[j + 1] = location.y;
            this.points[j + 2] = location.z;
            j += 3;
        }
        this.createShape();
    }

    public HullCollisionShape(float ... coordinates) {
        Validate.nonEmpty(coordinates, "coordinates");
        Validate.require(coordinates.length % 3 == 0, "length a multiple of 3");
        this.points = (float[])coordinates.clone();
        this.createShape();
    }

    public HullCollisionShape(FloatBuffer flippedBuffer) {
        Validate.nonNull(flippedBuffer, "flipped buffer");
        int numFloats = flippedBuffer.limit();
        Validate.positive(numFloats, "limit");
        Validate.require(numFloats % 3 == 0, "limit a multiple of 3");
        this.points = new float[numFloats];
        for (int i = 0; i < numFloats; ++i) {
            float f = flippedBuffer.get(i);
            if (!Float.isFinite(f)) {
                throw new IllegalArgumentException("illegal coordinate: " + f);
            }
            this.points[i] = f;
        }
        this.createShape();
    }

    public HullCollisionShape(RectangularSolid rectangularSolid) {
        Vector3f maxima = rectangularSolid.maxima(null);
        Vector3f minima = rectangularSolid.minima(null);
        ArrayList<Vector3f> cornerLocations = new ArrayList<Vector3f>(8);
        cornerLocations.add(new Vector3f(maxima.x, maxima.y, maxima.z));
        cornerLocations.add(new Vector3f(maxima.x, maxima.y, minima.z));
        cornerLocations.add(new Vector3f(maxima.x, minima.y, maxima.z));
        cornerLocations.add(new Vector3f(maxima.x, minima.y, minima.z));
        cornerLocations.add(new Vector3f(minima.x, maxima.y, maxima.z));
        cornerLocations.add(new Vector3f(minima.x, maxima.y, minima.z));
        cornerLocations.add(new Vector3f(minima.x, minima.y, maxima.z));
        cornerLocations.add(new Vector3f(minima.x, minima.y, minima.z));
        int numFloats = 3 * cornerLocations.size();
        this.points = new float[numFloats];
        int floatIndex = 0;
        Vector3f tempVector = new Vector3f();
        for (Vector3f location : cornerLocations) {
            rectangularSolid.localToWorld(location, tempVector);
            this.points[floatIndex + 0] = tempVector.x;
            this.points[floatIndex + 1] = tempVector.y;
            this.points[floatIndex + 2] = tempVector.z;
            floatIndex += 3;
        }
        this.createShape();
    }

    public HullCollisionShape(Vector3f ... locations) {
        Validate.nonEmpty(locations, "locations");
        int numFloats = 3 * locations.length;
        this.points = new float[numFloats];
        int floatIndex = 0;
        for (Vector3f location : locations) {
            if (!Vector3f.isValidVector(location)) {
                throw new IllegalArgumentException("illegal coordinates: " + String.valueOf(location));
            }
            this.points[floatIndex + 0] = location.x;
            this.points[floatIndex + 1] = location.y;
            this.points[floatIndex + 2] = location.z;
            floatIndex += 3;
        }
        this.createShape();
    }

    public HullCollisionShape(Vhacd4Hull vhacd4Hull) {
        Validate.nonNull(vhacd4Hull, "V-HACD hull");
        this.points = vhacd4Hull.clonePositions();
        this.createShape();
    }

    public HullCollisionShape(VHACDHull vhacdHull) {
        Validate.nonNull(vhacdHull, "V-HACD hull");
        this.points = vhacdHull.clonePositions();
        this.createShape();
    }

    public float aabbVolume() {
        Vector3f maxima = new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        Vector3f minima = new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        Vector3f location = new Vector3f();
        for (int floatI = 0; floatI < this.points.length; floatI += 3) {
            float x = this.points[floatI + 0];
            float y = this.points[floatI + 1];
            float z = this.points[floatI + 2];
            location.set(x, y, z);
            MyVector3f.accumulateMinima(minima, location);
            MyVector3f.accumulateMaxima(maxima, location);
        }
        float dx = maxima.x - minima.x;
        float dy = maxima.y - minima.y;
        float dz = maxima.z - minima.z;
        float volume = dx * dy * dz;
        assert (volume >= 0.0f) : volume;
        assert (MyMath.isFinite(volume)) : volume;
        return volume;
    }

    public float[] copyHullVertices() {
        long shapeId = this.nativeId();
        int numHullVertices = this.countHullVertices();
        FloatBuffer buffer = BufferUtils.createFloatBuffer(numHullVertices * 3);
        HullCollisionShape.getHullVerticesF(shapeId, buffer);
        float[] result = new float[numHullVertices * 3];
        for (int floatI = 0; floatI < numHullVertices * 3; ++floatI) {
            result[floatI] = buffer.get(floatI);
        }
        return result;
    }

    public int countHullVertices() {
        long shapeId = this.nativeId();
        int result = HullCollisionShape.countHullVertices(shapeId);
        return result;
    }

    public int countMeshVertices() {
        int length = this.points.length;
        assert (length % 3 == 0) : length;
        int result = length / 3;
        assert (result > 0) : result;
        return result;
    }

    public Vector3f getHalfExtents(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.zero();
        for (int i = 0; i < this.points.length; i += 3) {
            float z;
            float y;
            float x = FastMath.abs(this.points[i + 0]);
            if (x > result.x) {
                result.x = x;
            }
            if ((y = FastMath.abs(this.points[i + 1])) > result.y) {
                result.y = y;
            }
            if (!((z = FastMath.abs(this.points[i + 2])) > result.z)) continue;
            result.z = z;
        }
        assert (MyVector3f.isAllNonNegative(result)) : result;
        return result;
    }

    public ChildCollisionShape[] split(Triangle splittingTriangle) {
        Validate.nonNull(splittingTriangle, "splitting triangle");
        int numVertices = this.countHullVertices();
        int numFloats = 3 * numVertices;
        FloatBuffer originalHull = BufferUtils.createFloatBuffer(numFloats);
        long shapeId = this.nativeId();
        HullCollisionShape.getHullVerticesF(shapeId, originalHull);
        Vector3f normal = splittingTriangle.getNormal();
        Plane splittingPlane = new Plane(normal, splittingTriangle.get3());
        VectorSetUsingBuffer minusSet = new VectorSetUsingBuffer(numVertices, true);
        VectorSetUsingBuffer plusSet = new VectorSetUsingBuffer(numVertices, true);
        Vector3f tmpVertex = new Vector3f();
        for (int vertexI = 0; vertexI < numVertices; ++vertexI) {
            int startPosition = 3 * vertexI;
            MyBuffer.get(originalHull, startPosition, tmpVertex);
            float pseudoDistance = splittingPlane.pseudoDistance(tmpVertex);
            if (pseudoDistance <= 0.0f) {
                minusSet.add(tmpVertex);
            }
            if (!(pseudoDistance >= 0.0f)) continue;
            plusSet.add(tmpVertex);
        }
        ChildCollisionShape[] result = new ChildCollisionShape[2];
        int numMinus = minusSet.numVectors();
        int numPlus = plusSet.numVectors();
        if (numMinus == 0 || numPlus == 0) {
            ChildCollisionShape child = new ChildCollisionShape(new Vector3f(), this);
            if (numMinus > 0) {
                result[0] = child;
            } else if (numPlus > 0) {
                result[1] = child;
            }
            return result;
        }
        FloatBuffer minusBuffer = minusSet.toBuffer();
        VectorSetUsingBuffer newMinusSet = new VectorSetUsingBuffer(numVertices, true);
        for (int jNegative = 0; jNegative < numMinus; ++jNegative) {
            MyBuffer.get(minusBuffer, 3 * jNegative, tmpVertex);
            newMinusSet.add(tmpVertex);
        }
        FloatBuffer plusBuffer = plusSet.toBuffer();
        VectorSetUsingBuffer newPlusSet = new VectorSetUsingBuffer(numVertices, true);
        Vector3f tmp2 = new Vector3f();
        for (int plusI = 0; plusI < numPlus; ++plusI) {
            MyBuffer.get(plusBuffer, 3 * plusI, tmpVertex);
            newPlusSet.add(tmpVertex);
            float pd = splittingPlane.pseudoDistance(tmpVertex);
            for (int minusI = 0; minusI < numMinus; ++minusI) {
                MyBuffer.get(minusBuffer, 3 * minusI, tmp2);
                float md = splittingPlane.pseudoDistance(tmp2);
                float denominator = pd - md;
                if (denominator == 0.0f) continue;
                float t = -md / denominator;
                MyVector3f.lerp(t, tmp2, tmpVertex, tmp2);
                newMinusSet.add(tmp2);
                newPlusSet.add(tmp2);
            }
        }
        Vector3f max = tmpVertex;
        Vector3f min = tmp2;
        Vector3f offset = tmpVertex;
        newMinusSet.maxMin(max, min);
        Vector3f minusCenter = MyVector3f.midpoint(max, min, null);
        offset.set(minusCenter).negateLocal();
        FloatBuffer flippedBuffer = newMinusSet.toBuffer();
        MyBuffer.translate(flippedBuffer, 0, flippedBuffer.limit(), offset);
        HullCollisionShape minusShape = new HullCollisionShape(flippedBuffer);
        minusShape.setScale(this.scale);
        result[0] = new ChildCollisionShape(minusCenter, minusShape);
        newPlusSet.maxMin(max, min);
        Vector3f plusCenter = MyVector3f.midpoint(max, min, null);
        offset.set(plusCenter).negateLocal();
        flippedBuffer = newPlusSet.toBuffer();
        MyBuffer.translate(flippedBuffer, 0, flippedBuffer.limit(), offset);
        HullCollisionShape plusShape = new HullCollisionShape(flippedBuffer);
        plusShape.setScale(this.scale);
        result[1] = new ChildCollisionShape(plusCenter, plusShape);
        return result;
    }

    @Override
    public boolean canSplit() {
        return true;
    }

    @Override
    public float maxRadius() {
        int numHullVertices = this.countHullVertices();
        FloatBuffer buffer = BufferUtils.createFloatBuffer(numHullVertices * 3);
        long shapeId = this.nativeId();
        HullCollisionShape.getHullVerticesF(shapeId, buffer);
        double maxSquaredDistance = 0.0;
        for (int vertexI = 0; vertexI < numHullVertices; ++vertexI) {
            int startOffset = 3 * vertexI;
            float x = this.scale.x * buffer.get(startOffset + 0);
            float y = this.scale.y * buffer.get(startOffset + 1);
            float z = this.scale.z * buffer.get(startOffset + 2);
            float[] fArray = new float[]{x, y, z};
            double lengthSquared = MyMath.sumOfSquares(fArray);
            if (!(lengthSquared > maxSquaredDistance)) continue;
            maxSquaredDistance = lengthSquared;
        }
        float result = this.margin + (float)Math.sqrt(maxSquaredDistance);
        return result;
    }

    @Override
    protected void recalculateAabb() {
        long shapeId = this.nativeId();
        HullCollisionShape.recalcAabb(shapeId);
    }

    private void createShape() {
        assert (this.directBuffer == null) : this.directBuffer;
        int numFloats = this.points.length;
        assert (numFloats != 0);
        assert (numFloats % 3 == 0) : numFloats;
        int numVertices = numFloats / 3;
        this.directBuffer = BufferUtils.createFloatBuffer(numFloats);
        for (float f : this.points) {
            if (!MyMath.isFinite(f)) {
                throw new IllegalArgumentException("illegal coordinate: " + f);
            }
            this.directBuffer.put(f);
        }
        long shapeId = HullCollisionShape.createShapeF(this.directBuffer, numVertices);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native int countHullVertices(long var0);

    private static native long createShapeF(FloatBuffer var0, int var1);

    private static native void getHullVerticesF(long var0, FloatBuffer var2);

    private static native void recalcAabb(long var0);
}

