/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.infos.BoundingValueHierarchy;
import com.jme3.bullet.collision.shapes.infos.CompoundMesh;
import com.jme3.bullet.collision.shapes.infos.IndexedMesh;
import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import java.util.Collection;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class MeshCollisionShape
extends CollisionShape {
    public static final int maxSubmeshes = 1024;
    public static final int maxTrianglesInAnySubmesh = 0x1FFFFF;
    public static final Logger logger2 = Logger.getLogger(MeshCollisionShape.class.getName());
    private final boolean useCompression;
    private BoundingValueHierarchy bvh;
    private final CompoundMesh nativeMesh;

    public MeshCollisionShape(boolean useCompression, Collection<IndexedMesh> meshes) {
        Validate.nonEmpty(meshes, "meshes");
        this.nativeMesh = new CompoundMesh();
        for (IndexedMesh submesh : meshes) {
            this.nativeMesh.add(submesh);
        }
        Validate.require(this.nativeMesh.countTriangles() > 0, "at least one triangle");
        this.useCompression = useCompression;
        this.createShape();
    }

    public MeshCollisionShape(boolean useCompression, CompoundMesh mesh) {
        Validate.require(mesh.countTriangles() > 0, "at least one triangle");
        this.nativeMesh = new CompoundMesh(mesh);
        this.useCompression = useCompression;
        this.createShape();
    }

    public MeshCollisionShape(boolean useCompression, IndexedMesh ... submeshes) {
        Validate.nonEmpty(submeshes, "submeshes");
        this.nativeMesh = new CompoundMesh();
        for (IndexedMesh submesh : submeshes) {
            this.nativeMesh.add(submesh);
        }
        Validate.require(this.nativeMesh.countTriangles() > 0, "at least one triangle");
        this.useCompression = useCompression;
        this.createShape();
    }

    public MeshCollisionShape(byte[] bvhBytes, IndexedMesh ... submeshes) {
        Validate.nonNull(bvhBytes, "BVH data");
        Validate.nonEmpty(submeshes, "submeshes");
        this.nativeMesh = new CompoundMesh();
        for (IndexedMesh submesh : submeshes) {
            this.nativeMesh.add(submesh);
        }
        Validate.require(this.nativeMesh.countTriangles() > 0, "at least one triangle");
        this.useCompression = true;
        this.bvh = new BoundingValueHierarchy(bvhBytes);
        this.createShape();
    }

    public int countMeshTriangles() {
        int result = this.nativeMesh.countTriangles();
        return result;
    }

    public int countMeshVertices() {
        int numVertices = this.nativeMesh.countVertices();
        return numVertices;
    }

    public int countSubmeshes() {
        int result = this.nativeMesh.countSubmeshes();
        return result;
    }

    public BoundingValueHierarchy getBvh() {
        return this.bvh;
    }

    public IndexedMesh getSubmesh(int index) {
        int numSubmeshes = this.nativeMesh.countSubmeshes();
        Validate.inRange(index, "submesh index", 0, numSubmeshes - 1);
        IndexedMesh result = this.nativeMesh.getSubmesh(index);
        return result;
    }

    public byte[] serializeBvh() {
        byte[] result = this.bvh.serialize();
        return result;
    }

    public MeshCollisionShape[] split(Triangle splittingTriangle) {
        int numPlus;
        Validate.nonNull(splittingTriangle, "splitting triangle");
        CompoundMesh[] mp = this.nativeMesh.split(splittingTriangle);
        MeshCollisionShape[] result = new MeshCollisionShape[2];
        int numMinus = mp[0] == null ? 0 : mp[0].countTriangles();
        int n = numPlus = mp[1] == null ? 0 : mp[1].countTriangles();
        if (numMinus == 0 || numPlus == 0) {
            if (numMinus > 0) {
                result[0] = this;
            } else if (numPlus > 0) {
                result[1] = this;
            }
        } else {
            result[0] = new MeshCollisionShape(this.useCompression, mp[0]);
            result[0].setScale(this.scale);
            result[1] = new MeshCollisionShape(this.useCompression, mp[1]);
            result[1].setScale(this.scale);
        }
        return result;
    }

    @Override
    public boolean canSplit() {
        return true;
    }

    @Override
    protected void recalculateAabb() {
        long shapeId = this.nativeId();
        MeshCollisionShape.recalcAabb(shapeId);
    }

    @Override
    public void setScale(Vector3f scale) {
        super.setScale(scale);
        long shapeId = this.nativeId();
        if (MeshCollisionShape.hasBvh(shapeId)) {
            this.bvh = new BoundingValueHierarchy(this);
        }
    }

    private void createShape() {
        int numTriangles = this.nativeMesh.countTriangles();
        assert (numTriangles > 0) : numTriangles;
        if (this.useCompression) {
            int numSubmeshes = this.nativeMesh.countSubmeshes();
            if (numSubmeshes > 1024) {
                throw new IllegalArgumentException("Too many submeshes: " + numSubmeshes);
            }
            for (int submeshI = 0; submeshI < numSubmeshes; ++submeshI) {
                IndexedMesh submesh = this.nativeMesh.getSubmesh(submeshI);
                int count = submesh.countTriangles();
                if (count <= 0x1FFFFF) continue;
                throw new IllegalArgumentException("Submesh has too many triangles: " + count);
            }
        }
        boolean buildBvh = false;
        long meshId = this.nativeMesh.nativeId();
        long shapeId = MeshCollisionShape.createShape(this.useCompression, buildBvh, meshId);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
        assert (!MeshCollisionShape.hasBvh(shapeId));
        if (this.bvh == null) {
            this.bvh = new BoundingValueHierarchy(this);
        } else {
            long bvhId = this.bvh.nativeId();
            MeshCollisionShape.setOptimizedBvh(shapeId, bvhId, this.scale);
        }
        assert (MeshCollisionShape.hasBvh(shapeId));
        assert (this.bvh.isCompressed() == this.useCompression) : this.bvh.isCompressed() + " != " + this.useCompression;
    }

    private static native long createShape(boolean var0, boolean var1, long var2);

    private static native boolean hasBvh(long var0);

    private static native void recalcAabb(long var0);

    private static native void setOptimizedBvh(long var0, long var2, Vector3f var4);
}

