/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.math.Vector3f;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public class MinkowskiSum
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(MinkowskiSum.class.getName());
    private final ConvexShape shapeA;
    private final ConvexShape shapeB;

    public MinkowskiSum(ConvexShape shapeA, ConvexShape shapeB) {
        Validate.nonNull(shapeA, "shape A");
        Validate.nonNull(shapeA, "shape B");
        this.shapeA = shapeA;
        this.shapeB = shapeB;
        this.createShape();
    }

    public ConvexShape getShapeA() {
        assert (this.shapeA != null);
        return this.shapeA;
    }

    public ConvexShape getShapeB() {
        assert (this.shapeB != null);
        return this.shapeB;
    }

    @Override
    public boolean canScale(Vector3f scale) {
        boolean canScale = super.canScale(scale) && MyVector3f.isScaleIdentity(scale);
        return canScale;
    }

    @Override
    public float getMargin() {
        this.margin = this.shapeA.nativeMargin() + this.shapeB.nativeMargin();
        float result = super.getMargin();
        return result;
    }

    @Override
    public void setMargin(float margin) {
        logger2.log(Level.WARNING, "Cannot directly alter the margin of a MinkowskiSum");
    }

    private void createShape() {
        long shapeAId = this.shapeA.nativeId();
        long shapeBId = this.shapeB.nativeId();
        long shapeId = MinkowskiSum.createShape(shapeAId, shapeBId);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.margin = this.shapeA.getMargin() + this.shapeB.getMargin();
    }

    private static native long createShape(long var0, long var2);
}

