/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.MyVolume;

public class SimplexCollisionShape
extends ConvexShape {
    private static final int numAxes = 3;
    public static final Logger logger2 = Logger.getLogger(SimplexCollisionShape.class.getName());
    private final Vector3f[] locations;

    public SimplexCollisionShape(Vector3f location) {
        this.locations = new Vector3f[1];
        this.locations[0] = location.clone();
        this.createShape();
    }

    public SimplexCollisionShape(Vector3f point1, Vector3f point2) {
        this.locations = new Vector3f[2];
        this.locations[0] = point1.clone();
        this.locations[1] = point2.clone();
        this.createShape();
    }

    public SimplexCollisionShape(Vector3f vertex1, Vector3f vertex2, Vector3f vertex3) {
        this.locations = new Vector3f[3];
        this.locations[0] = vertex1.clone();
        this.locations[1] = vertex2.clone();
        this.locations[2] = vertex3.clone();
        this.createShape();
    }

    public SimplexCollisionShape(Vector3f vertex1, Vector3f vertex2, Vector3f vertex3, Vector3f vertex4) {
        this.locations = new Vector3f[4];
        this.locations[0] = vertex1.clone();
        this.locations[1] = vertex2.clone();
        this.locations[2] = vertex3.clone();
        this.locations[3] = vertex4.clone();
        this.createShape();
    }

    public SimplexCollisionShape(FloatBuffer buffer, int startPosition, int endPosition) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition - 3);
        Validate.inRange(endPosition, "end position", startPosition + 3, buffer.capacity());
        int numFloats = endPosition - startPosition;
        Validate.require(numFloats % 3 == 0, "range a multiple of 3");
        int numVertices = numFloats / 3;
        assert (numVertices >= 1) : numVertices;
        assert (numVertices <= 4) : numVertices;
        this.locations = new Vector3f[numVertices];
        for (int vertexIndex = 0; vertexIndex < numVertices; ++vertexIndex) {
            this.locations[vertexIndex] = new Vector3f();
            MyBuffer.get(buffer, startPosition + vertexIndex * 3, this.locations[vertexIndex]);
        }
        this.createShape();
    }

    public SimplexCollisionShape(Vector3f[] vertices) {
        Validate.nonEmpty(vertices, "vertices");
        int numVertices = vertices.length;
        assert (numVertices <= 4) : numVertices;
        this.locations = new Vector3f[numVertices];
        for (int vertexIndex = 0; vertexIndex < numVertices; ++vertexIndex) {
            this.locations[vertexIndex] = vertices[vertexIndex].clone();
        }
        this.createShape();
    }

    public Vector3f copyVertex(int index, Vector3f storeResult) {
        int numVertices = this.locations.length;
        Validate.inRange(index, "index", 0, numVertices - 1);
        Vector3f result = storeResult == null ? this.locations[index].clone() : storeResult.set(this.locations[index]);
        return result;
    }

    public float[] copyVertices() {
        int numVertices = this.locations.length;
        float[] result = new float[numVertices * 3];
        for (int vertexIndex = 0; vertexIndex < numVertices; ++vertexIndex) {
            int floatIndex = vertexIndex * 3;
            Vector3f location = this.locations[vertexIndex];
            result[floatIndex + 0] = location.x;
            result[floatIndex + 1] = location.y;
            result[floatIndex + 2] = location.z;
        }
        return result;
    }

    public int countMeshVertices() {
        int result = this.locations.length;
        assert (result >= 1) : result;
        assert (result <= 4) : result;
        return result;
    }

    public Vector3f getHalfExtents(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.zero();
        for (Vector3f location : this.locations) {
            float z;
            float y;
            float x = FastMath.abs(location.x);
            if (x > result.x) {
                result.x = x;
            }
            if ((y = FastMath.abs(location.y)) > result.y) {
                result.y = y;
            }
            if (!((z = FastMath.abs(location.z)) > result.z)) continue;
            result.z = z;
        }
        assert (MyVector3f.isAllNonNegative(result)) : result;
        return result;
    }

    public float unscaledVolume() {
        float volume = 0.0f;
        if (this.locations.length > 3) {
            volume = (float)MyVolume.tetrahedronVolume(this.locations[0], this.locations[1], this.locations[2], this.locations[3]);
        }
        assert (volume >= 0.0f) : volume;
        return volume;
    }

    @Override
    public boolean canScale(Vector3f scale) {
        boolean canScale = super.canScale(scale) && MyVector3f.isScaleIdentity(scale);
        return canScale;
    }

    @Override
    public float maxRadius() {
        double maxLengthSquared = 0.0;
        for (Vector3f location : this.locations) {
            double lengthSquared = MyVector3f.lengthSquared(location);
            if (!(lengthSquared > maxLengthSquared)) continue;
            maxLengthSquared = lengthSquared;
        }
        float result = this.margin + (float)Math.sqrt(maxLengthSquared);
        return result;
    }

    @Override
    protected void recalculateAabb() {
        long shapeId = this.nativeId();
        SimplexCollisionShape.recalcAabb(shapeId);
    }

    @Override
    public HullCollisionShape toHullShape() {
        assert (MyVector3f.isScaleIdentity(this.scale)) : this.scale;
        HullCollisionShape result = new HullCollisionShape(this.locations);
        result.setMargin(this.margin);
        return result;
    }

    private void createShape() {
        int numVertices = this.locations.length;
        this.setNativeId(switch (numVertices) {
            case 1 -> SimplexCollisionShape.createShape(this.locations[0]);
            case 2 -> SimplexCollisionShape.createShape(this.locations[0], this.locations[1]);
            case 3 -> SimplexCollisionShape.createShape(this.locations[0], this.locations[1], this.locations[2]);
            case 4 -> SimplexCollisionShape.createShape(this.locations[0], this.locations[1], this.locations[2], this.locations[3]);
            default -> {
                String message = "numVertices = " + numVertices;
                throw new IllegalArgumentException(message);
            }
        });
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShape(Vector3f var0);

    private static native long createShape(Vector3f var0, Vector3f var1);

    private static native long createShape(Vector3f var0, Vector3f var1, Vector3f var2);

    private static native long createShape(Vector3f var0, Vector3f var1, Vector3f var2, Vector3f var3);

    private static native void recalcAabb(long var0);
}

