/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.math.Vector3f;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.MyVolume;

public class SphereCollisionShape
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(SphereCollisionShape.class.getName());
    private final float radius;

    public SphereCollisionShape(FloatBuffer buffer, int startPosition, int endPosition) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        this.radius = MyBuffer.maxLength(buffer, startPosition, endPosition);
        this.createShape();
    }

    public SphereCollisionShape(float radius) {
        Validate.nonNegative(radius, "radius");
        this.radius = radius;
        this.createShape();
    }

    public float getRadius() {
        assert (this.radius >= 0.0f) : this.radius;
        return this.radius;
    }

    public float unscaledVolume() {
        float result = MyVolume.sphereVolume(this.radius);
        assert (result >= 0.0f) : result;
        return result;
    }

    @Override
    public boolean canScale(Vector3f scale) {
        boolean canScale = super.canScale(scale) && MyVector3f.isScaleUniform(scale);
        return canScale;
    }

    @Override
    public float getMargin() {
        return 0.0f;
    }

    @Override
    public float maxRadius() {
        float result = this.scale.x * this.radius;
        return result;
    }

    @Override
    public float scaledVolume() {
        float result = this.unscaledVolume() * this.scale.x * this.scale.y * this.scale.z;
        return result;
    }

    @Override
    public void setMargin(float margin) {
        logger2.log(Level.WARNING, "Cannot alter the margin of a SphereCollisionShape.");
    }

    @Override
    public HullCollisionShape toHullShape() {
        HullCollisionShape result;
        float effectiveRadius = this.scale.x * this.radius;
        float defaultMargin = SphereCollisionShape.getDefaultMargin();
        if (effectiveRadius > defaultMargin) {
            SphereCollisionShape shrunkenSphere = new SphereCollisionShape(effectiveRadius - defaultMargin);
            FloatBuffer buffer = DebugShapeFactory.debugVertices(shrunkenSphere, 0);
            buffer.rewind();
            buffer.limit(buffer.capacity());
            result = new HullCollisionShape(buffer);
        } else {
            result = new HullCollisionShape(0.0f, 0.0f, 0.0f);
            if (effectiveRadius <= 1.0E-9f) {
                result.setMargin(1.0E-9f);
            } else {
                result.setMargin(effectiveRadius);
            }
        }
        return result;
    }

    private void createShape() {
        assert (this.radius >= 0.0f) : this.radius;
        long shapeId = SphereCollisionShape.createShape(this.radius);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.margin = 0.0f;
    }

    private static native long createShape(float var0);
}

