/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public class SphericalSegment
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(SphericalSegment.class.getName());
    private final float unscaledRadius;
    private final float unscaledYMax;
    private final float unscaledYMin;

    public SphericalSegment(float radius) {
        this(radius, radius, 0.0f);
    }

    public SphericalSegment(float radius, float yMax, float yMin) {
        Validate.positive(radius, "radius");
        Validate.inRange(yMax, "yMax", yMin, radius);
        Validate.inRange(yMin, "yMin", -radius, yMax);
        this.unscaledRadius = radius;
        this.unscaledYMax = yMax;
        this.unscaledYMin = yMin;
        this.createShape();
    }

    public float getHeight() {
        float result = this.unscaledYMax - this.unscaledYMin;
        assert (result >= 0.0f) : result;
        return result;
    }

    public float sphereRadius() {
        assert (this.unscaledRadius > 0.0f) : this.unscaledRadius;
        return this.unscaledRadius;
    }

    public float yMax() {
        assert (this.unscaledYMax >= -this.unscaledRadius);
        assert (this.unscaledYMax <= this.unscaledRadius);
        return this.unscaledYMax;
    }

    public float yMin() {
        assert (this.unscaledYMin >= -this.unscaledRadius);
        assert (this.unscaledYMin <= this.unscaledRadius);
        return this.unscaledYMin;
    }

    @Override
    public boolean canScale(Vector3f scale) {
        boolean canScale = super.canScale(scale) && MyVector3f.isScaleUniform(scale);
        return canScale;
    }

    @Override
    public float maxRadius() {
        long shapeId = this.nativeId();
        float result = SphericalSegment.maxRadius(shapeId);
        return result;
    }

    @Override
    public float scaledVolume() {
        long shapeId = this.nativeId();
        float result = SphericalSegment.scaledVolume(shapeId);
        return result;
    }

    private void createShape() {
        long shapeId = SphericalSegment.createShapeNative(this.unscaledRadius, this.unscaledYMax, this.unscaledYMin);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShapeNative(float var0, float var1, float var2);

    private static native float maxRadius(long var0);

    private static native float scaledVolume(long var0);
}

