/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes.infos;

import com.jme3.bounding.BoundingBox;
import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.collision.shapes.MeshCollisionShape;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class BoundingValueHierarchy
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(BoundingValueHierarchy.class.getName());

    public BoundingValueHierarchy(MeshCollisionShape meshShape) {
        Validate.nonNull(meshShape, "mesh shape");
        long shapeId = meshShape.nativeId();
        long bvhId = BoundingValueHierarchy.getOptimizedBvh(shapeId);
        super.setNativeIdNotTracked(bvhId);
    }

    public BoundingValueHierarchy(byte[] bytes) {
        Validate.nonNull(bytes, "bytes");
        long bvhId = BoundingValueHierarchy.deSerialize(bytes);
        super.setNativeId(bvhId);
    }

    public BoundingBox copyAabb(BoundingBox storeResult) {
        BoundingBox result = storeResult == null ? new BoundingBox() : storeResult;
        long bvhId = this.nativeId();
        Vector3f maxima = new Vector3f();
        Vector3f minima = new Vector3f();
        BoundingValueHierarchy.getAabb(bvhId, minima, maxima);
        result.setMinMax(minima, maxima);
        return result;
    }

    public Vector3f copyQuantization(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long bvhId = this.nativeId();
        BoundingValueHierarchy.getQuantization(bvhId, result);
        return result;
    }

    public int countLeafNodes() {
        long bvhId = this.nativeId();
        int result = BoundingValueHierarchy.getNumLeafNodes(bvhId);
        assert (result >= 0) : result;
        return result;
    }

    public int countNodes() {
        long bvhId = this.nativeId();
        int result = BoundingValueHierarchy.getNumNodes(bvhId);
        assert (result >= 0) : result;
        return result;
    }

    public int countSubtreeHeaders() {
        long bvhId = this.nativeId();
        int result = BoundingValueHierarchy.getNumSubtreeHeaders(bvhId);
        assert (result >= 0) : result;
        return result;
    }

    public int escapeIndex(int nodeIndex) {
        long bvhId = this.nativeId();
        int lastNode = BoundingValueHierarchy.getNumNodes(bvhId) - 1;
        Validate.inRange(nodeIndex, "node index", 0, lastNode);
        int result = BoundingValueHierarchy.getEscapeIndex(bvhId, nodeIndex);
        assert (result >= -1) : result;
        return result;
    }

    public boolean isCompressed() {
        long bvhId = this.nativeId();
        boolean result = BoundingValueHierarchy.isCompressed(bvhId);
        return result;
    }

    public boolean isLeafNode(int nodeIndex) {
        long bvhId = this.nativeId();
        int lastNode = BoundingValueHierarchy.getNumNodes(bvhId) - 1;
        Validate.inRange(nodeIndex, "node index", 0, lastNode);
        boolean result = BoundingValueHierarchy.isLeafNode(bvhId, nodeIndex);
        return result;
    }

    public int partId(int nodeIndex) {
        long bvhId = this.nativeId();
        int lastNode = BoundingValueHierarchy.getNumNodes(bvhId) - 1;
        Validate.inRange(nodeIndex, "node index", 0, lastNode);
        int result = BoundingValueHierarchy.getPartId(bvhId, nodeIndex);
        assert (result >= -1) : result;
        return result;
    }

    public byte[] serialize() {
        long bvhId = this.nativeId();
        byte[] result = BoundingValueHierarchy.serialize(bvhId);
        assert (result != null);
        return result;
    }

    public void setTraversalMode(int mode) {
        Validate.inRange(mode, "mode", 0, 2);
        long bvhId = this.nativeId();
        BoundingValueHierarchy.setTraversalMode(bvhId, mode);
    }

    public int traversalMode() {
        long bvhId = this.nativeId();
        int result = BoundingValueHierarchy.getTraversalMode(bvhId);
        assert (result >= 0 && result <= 2) : result;
        return result;
    }

    public int triangleIndex(int nodeIndex) {
        long bvhId = this.nativeId();
        int lastNode = BoundingValueHierarchy.getNumNodes(bvhId) - 1;
        Validate.inRange(nodeIndex, "node index", 0, lastNode);
        int result = BoundingValueHierarchy.getTriangleIndex(bvhId, nodeIndex);
        assert (result >= -1) : result;
        return result;
    }

    private static void freeNativeObject(long bvhId) {
        assert (bvhId != 0L);
        BoundingValueHierarchy.finalizeNative(bvhId);
    }

    private static native long deSerialize(byte[] var0);

    private static native void finalizeNative(long var0);

    private static native void getAabb(long var0, Vector3f var2, Vector3f var3);

    private static native int getEscapeIndex(long var0, int var2);

    private static native int getNumLeafNodes(long var0);

    private static native int getNumNodes(long var0);

    private static native int getNumSubtreeHeaders(long var0);

    private static native long getOptimizedBvh(long var0);

    private static native int getPartId(long var0, int var2);

    private static native void getQuantization(long var0, Vector3f var2);

    private static native int getTraversalMode(long var0);

    private static native int getTriangleIndex(long var0, int var2);

    private static native boolean isCompressed(long var0);

    private static native boolean isLeafNode(long var0, int var2);

    private static native byte[] serialize(long var0);

    private static native void setTraversalMode(long var0, int var2);
}

