/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes.infos;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.collision.shapes.infos.IndexedMesh;
import com.jme3.math.Plane;
import com.jme3.math.Transform;
import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyVector3f;

public class CompoundMesh
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(CompoundMesh.class.getName());
    private final ArrayList<IndexedMesh> submeshes = new ArrayList(4);
    private final Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);

    public CompoundMesh() {
        this.createEmpty();
    }

    public CompoundMesh(CompoundMesh original) {
        this.createEmpty();
        for (IndexedMesh submesh : original.submeshes) {
            this.add(submesh);
        }
        this.setScale(original.scale);
    }

    public CompoundMesh(CompoundMesh base2, Vector3f offset) {
        this.createEmpty();
        Transform transform = new Transform();
        transform.getScale().set(this.scale);
        transform.setTranslation(offset);
        for (IndexedMesh oldSubmesh : base2.submeshes) {
            FloatBuffer positions = oldSubmesh.copyVertexPositions();
            MyBuffer.transform(positions, 0, positions.capacity(), transform);
            IntBuffer indices = oldSubmesh.copyIndices();
            IndexedMesh newSubmesh = new IndexedMesh(positions, indices);
            this.add(newSubmesh);
        }
    }

    public final void add(IndexedMesh submesh) {
        Validate.nonNull(submesh, "submesh");
        this.submeshes.add(submesh);
        long compoundMeshId = this.nativeId();
        long submeshId = submesh.nativeId();
        CompoundMesh.addIndexedMesh(compoundMeshId, submeshId);
    }

    public int countSubmeshes() {
        int result = this.submeshes.size();
        assert (result >= 0) : result;
        return result;
    }

    public int countTriangles() {
        int numTriangles = 0;
        for (IndexedMesh submesh : this.submeshes) {
            numTriangles += submesh.countTriangles();
        }
        assert (numTriangles >= 0) : numTriangles;
        return numTriangles;
    }

    public int countVertices() {
        int numVertices = 0;
        for (IndexedMesh submesh : this.submeshes) {
            numVertices += submesh.countVertices();
        }
        assert (numVertices >= 0) : numVertices;
        return numVertices;
    }

    public Vector3f getScale(Vector3f storeResult) {
        Vector3f result;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        assert (this.checkScale(result));
        result.set(this.scale);
        return result;
    }

    public IndexedMesh getSubmesh(int index) {
        Validate.inRange(index, "index", 0, this.submeshes.size() - 1);
        IndexedMesh result = this.submeshes.get(index);
        return result;
    }

    public void maxMin(Vector3f storeMaxima, Vector3f storeMinima) {
        storeMaxima.set(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        storeMinima.set(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        Vector3f max = new Vector3f();
        Vector3f min = new Vector3f();
        for (IndexedMesh submesh : this.submeshes) {
            submesh.maxMin(max, min);
            MyVector3f.accumulateMinima(storeMinima, min);
            MyVector3f.accumulateMaxima(storeMaxima, max);
        }
        storeMaxima.multLocal(this.scale);
        storeMinima.multLocal(this.scale);
    }

    public void setScale(Vector3f scale) {
        long compoundMeshId = this.nativeId();
        CompoundMesh.setScaling(compoundMeshId, scale.x, scale.y, scale.z);
        logger.log(Level.FINE, "Scaled {0}", this);
        this.scale.set(scale);
    }

    public CompoundMesh[] split(Triangle scaledTriangle) {
        Validate.nonNull(scaledTriangle, "scaled triangle");
        Triangle descaledTriangle = new Triangle();
        Vector3f tmpVector = new Vector3f();
        for (int vertexIndex = 0; vertexIndex < 3; ++vertexIndex) {
            Vector3f inputVector = scaledTriangle.get(vertexIndex);
            tmpVector.set(inputVector);
            tmpVector.divideLocal(this.scale);
            descaledTriangle.set(vertexIndex, tmpVector);
        }
        Vector3f normal = descaledTriangle.getNormal();
        Vector3f location = descaledTriangle.get3();
        Plane splittingPlane = new Plane(normal, location);
        CompoundMesh[] result = new CompoundMesh[2];
        for (IndexedMesh submesh : this.submeshes) {
            IndexedMesh[] mp = submesh.split(splittingPlane);
            for (int sideI = 0; sideI < 2; ++sideI) {
                IndexedMesh newMesh = mp[sideI];
                if (newMesh == null) continue;
                if (result[sideI] == null) {
                    result[sideI] = new CompoundMesh();
                }
                result[sideI].add(newMesh);
            }
        }
        return result;
    }

    private boolean checkScale(Vector3f tempVector) {
        assert (tempVector != null);
        long compoundMeshId = this.nativeId();
        CompoundMesh.getScaling(compoundMeshId, tempVector);
        boolean result = this.scale.equals(tempVector);
        return result;
    }

    private void createEmpty() {
        long compoundMeshId = CompoundMesh.createEmptyTiva();
        this.setNativeId(compoundMeshId);
        logger.log(Level.FINE, "Created {0}", this);
    }

    private static void freeNativeObject(long compoundMeshId) {
        assert (compoundMeshId != 0L);
        CompoundMesh.finalizeNative(compoundMeshId);
    }

    private static native void addIndexedMesh(long var0, long var2);

    private static native long createEmptyTiva();

    private static native void finalizeNative(long var0);

    private static native void getScaling(long var0, Vector3f var2);

    private static native void setScaling(long var0, float var2, float var3, float var4);
}

