/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public class GearJoint
extends Constraint {
    public static final Logger logger2 = Logger.getLogger(GearJoint.class.getName());
    private final Vector3f axisA;
    private final Vector3f axisB;
    private float ratio;

    public GearJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f axisInA, Vector3f axisInB) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, Vector3f.ZERO, Vector3f.ZERO);
        Validate.nonZero(axisInA, "axis in body A");
        Validate.nonZero(axisInB, "axis in body B");
        this.axisA = axisInA.normalize();
        this.axisB = axisInB.normalize();
        this.ratio = 1.0f;
        this.createJoint();
    }

    public GearJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f axisInA, Vector3f axisInB, float ratio) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, Vector3f.ZERO, Vector3f.ZERO);
        Validate.nonZero(axisInA, "axis in body A");
        Validate.nonZero(axisInB, "axis in body B");
        this.axisA = axisInA.normalize();
        this.axisB = axisInB.normalize();
        this.ratio = ratio;
        this.createJoint();
    }

    public Vector3f getAxisA(Vector3f storeResult) {
        assert (this.checkAxisA());
        Vector3f result = storeResult == null ? this.axisA.clone() : storeResult.set(this.axisA);
        return result;
    }

    public Vector3f getAxisB(Vector3f storeResult) {
        assert (this.checkAxisB());
        Vector3f result = storeResult == null ? this.axisB.clone() : storeResult.set(this.axisB);
        return result;
    }

    public float getRatio() {
        assert (this.ratio == GearJoint.getRatio(this.nativeId())) : this.ratio;
        return this.ratio;
    }

    public void setAxisA(Vector3f axisInA) {
        Validate.nonZero(axisInA, "axis in body A");
        this.axisA.set(axisInA);
        MyVector3f.normalizeLocal(this.axisA);
        long constraintId = this.nativeId();
        GearJoint.setAxisA(constraintId, this.axisA);
    }

    public void setAxisB(Vector3f axisInB) {
        Validate.nonZero(axisInB, "axis in body B");
        this.axisB.set(axisInB);
        MyVector3f.normalizeLocal(this.axisB);
        long constraintId = this.nativeId();
        GearJoint.setAxisB(constraintId, this.axisB);
    }

    public void setRatio(float ratio) {
        this.ratio = ratio;
        long constraintId = this.nativeId();
        GearJoint.setRatio(constraintId, ratio);
    }

    private boolean checkAxisA() {
        long constraintId = this.nativeId();
        Vector3f tmpVector = new Vector3f();
        GearJoint.getAxisA(constraintId, tmpVector);
        boolean result = this.axisA.equals(tmpVector);
        return result;
    }

    private boolean checkAxisB() {
        long constraintId = this.nativeId();
        Vector3f tmpVector = new Vector3f();
        GearJoint.getAxisB(constraintId, tmpVector);
        boolean result = this.axisB.equals(tmpVector);
        return result;
    }

    private void createJoint() {
        PhysicsRigidBody a = this.getBodyA();
        long aId = a.nativeId();
        assert (!MyVector3f.isZero(this.axisA));
        PhysicsRigidBody b = this.getBodyB();
        long bId = b.nativeId();
        assert (!MyVector3f.isZero(this.axisB));
        long constraintId = GearJoint.createJoint(aId, bId, this.axisA, this.axisB, this.ratio);
        assert (GearJoint.getConstraintType(constraintId) == 10);
        this.setNativeId(constraintId);
    }

    private static native long createJoint(long var0, long var2, Vector3f var4, Vector3f var5, float var6);

    private static native void getAxisA(long var0, Vector3f var2);

    private static native void getAxisB(long var0, Vector3f var2);

    private static native float getRatio(long var0);

    private static native void setAxisA(long var0, Vector3f var2);

    private static native void setAxisB(long var0, Vector3f var2);

    private static native void setRatio(long var0, float var2);
}

