/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.objects.PhysicsBody;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;

public abstract class PhysicsJoint
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(PhysicsJoint.class.getName());
    private PhysicsBody bodyA = null;
    private PhysicsBody bodyB = null;
    private PhysicsSpace space = null;

    protected PhysicsJoint() {
    }

    public int countEnds() {
        if (this.bodyA == null || this.bodyB == null) {
            return 1;
        }
        return 2;
    }

    public void destroy() {
        if (this.bodyA != null) {
            this.bodyA.removeJoint(this);
        }
        if (this.bodyB != null) {
            this.bodyB.removeJoint(this);
        }
    }

    public JointEnd findEnd(PhysicsBody body) {
        Validate.nonNull(body, "body");
        if (body == this.bodyA) {
            return JointEnd.A;
        }
        if (body == this.bodyB) {
            return JointEnd.B;
        }
        return null;
    }

    public PhysicsBody findOtherBody(PhysicsBody body) {
        Validate.nonNull(body, "body");
        assert (this.bodyA != this.bodyB);
        if (body == this.bodyA) {
            return this.bodyB;
        }
        if (body == this.bodyB) {
            return this.bodyA;
        }
        return null;
    }

    public PhysicsBody getBody(JointEnd end) {
        Validate.nonNull((Object)end, "end");
        switch (end) {
            case A: {
                return this.bodyA;
            }
            case B: {
                return this.bodyB;
            }
        }
        throw new IllegalArgumentException("end = " + String.valueOf((Object)end));
    }

    public PhysicsBody getBodyA() {
        return this.bodyA;
    }

    public PhysicsBody getBodyB() {
        return this.bodyB;
    }

    public PhysicsSpace getPhysicsSpace() {
        PhysicsSpace result = this.space;
        return result;
    }

    public abstract boolean isEnabled();

    public void setPhysicsSpace(PhysicsSpace physicsSpace) {
        this.space = physicsSpace;
    }

    protected final void setBodyA(PhysicsBody body) {
        assert (body != null);
        assert (this.bodyA == null) : this.bodyA;
        this.bodyA = body;
    }

    protected final void setBodyB(PhysicsBody body) {
        assert (body != null);
        assert (this.bodyB == null) : this.bodyB;
        this.bodyB = body;
    }

    @Override
    protected void setNativeId(long jointId) {
        super.setNativeId(jointId);
        logger.log(Level.FINE, "Created {0}.", this);
    }

    @Override
    public String toString() {
        Object result = this.getClass().getSimpleName();
        result = ((String)result).replace("Joint", "");
        result = ((String)result).replace("Physics", "");
        result = ((String)result).replace("Point", "P");
        result = ((String)result).replace("Six", "6");
        if (this.hasAssignedNativeObject()) {
            long jointId = this.nativeId();
            result = (String)result + "#" + Long.toHexString(jointId);
        } else {
            result = (String)result + "#unassigned";
        }
        return result;
    }
}

