/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.joints.motors.RotationalLimitMotor;
import com.jme3.bullet.joints.motors.TranslationalLimitMotor;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public class SixDofJoint
extends Constraint {
    private static final int numAxes = 3;
    public static final Logger logger2 = Logger.getLogger(SixDofJoint.class.getName());
    private final Matrix3f rotA;
    private final Matrix3f rotB;
    private final boolean useLinearReferenceFrameA;
    private RotationalLimitMotor[] rotationalMotors;
    private TranslationalLimitMotor translationalMotor;
    private final Vector3f angularUpperLimit = new Vector3f(0.0f, 0.0f, 0.0f);
    private final Vector3f angularLowerLimit = new Vector3f(0.0f, 0.0f, 0.0f);
    private final Vector3f linearUpperLimit = new Vector3f(0.0f, 0.0f, 0.0f);
    private final Vector3f linearLowerLimit = new Vector3f(0.0f, 0.0f, 0.0f);

    public SixDofJoint(PhysicsRigidBody rigidBodyB, Vector3f pivotInB, Vector3f pivotInWorld, Matrix3f rotInB, Matrix3f rotInWorld, JointEnd linearReferenceFrame) {
        super(rigidBodyB, JointEnd.B, pivotInB, pivotInWorld);
        this.useLinearReferenceFrameA = linearReferenceFrame == JointEnd.A;
        this.rotA = rotInWorld.clone();
        this.rotB = rotInB.clone();
        this.createJoint();
    }

    public SixDofJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB, Matrix3f rotInA, Matrix3f rotInB, boolean useLinearReferenceFrameA) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, pivotInA, pivotInB);
        this.useLinearReferenceFrameA = useLinearReferenceFrameA;
        this.rotA = rotInA.clone();
        this.rotB = rotInB.clone();
        this.createJoint();
    }

    public SixDofJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB, boolean useLinearReferenceFrameA) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, pivotInA, pivotInB);
        this.useLinearReferenceFrameA = useLinearReferenceFrameA;
        this.rotA = new Matrix3f();
        this.rotB = new Matrix3f();
        this.createJoint();
    }

    public Vector3f getAngles(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long constraintId = this.nativeId();
        SixDofJoint.getAngles(constraintId, result);
        return result;
    }

    public Vector3f getAngularLowerLimit(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.angularLowerLimit.clone() : storeResult.set(this.angularLowerLimit);
        return result;
    }

    public Vector3f getAngularUpperLimit(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.angularUpperLimit.clone() : storeResult.set(this.angularUpperLimit);
        return result;
    }

    public Transform getFrameTransform(JointEnd end, Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        long constraintId = this.nativeId();
        switch (end) {
            case A: {
                SixDofJoint.getFrameOffsetA(constraintId, result);
                break;
            }
            case B: {
                SixDofJoint.getFrameOffsetB(constraintId, result);
                break;
            }
            default: {
                String message = "end = " + String.valueOf((Object)end);
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public Vector3f getLinearLowerLimit(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.linearLowerLimit.clone() : storeResult.set(this.linearLowerLimit);
        return result;
    }

    public Vector3f getLinearUpperLimit(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.linearUpperLimit.clone() : storeResult.set(this.linearUpperLimit);
        return result;
    }

    public Vector3f getPivotOffset(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long constraintId = this.nativeId();
        SixDofJoint.getPivotOffset(constraintId, result);
        return result;
    }

    public RotationalLimitMotor getRotationalLimitMotor(int axisIndex) {
        Validate.axisIndex(axisIndex, "axis index");
        return this.rotationalMotors[axisIndex];
    }

    public TranslationalLimitMotor getTranslationalLimitMotor() {
        return this.translationalMotor;
    }

    public void setAngularLowerLimit(Vector3f limits) {
        Validate.inRange(limits.x, "limits.x", (float)(-Math.PI), (float)Math.PI);
        Validate.inRange(limits.y, "limits.y", -1.5707964f, 1.5707964f);
        Validate.inRange(limits.z, "limits.z", (float)(-Math.PI), (float)Math.PI);
        this.angularLowerLimit.set(limits);
        long constraintId = this.nativeId();
        SixDofJoint.setAngularLowerLimit(constraintId, limits);
    }

    public void setAngularUpperLimit(Vector3f limits) {
        Validate.inRange(limits.x, "limits.x", (float)(-Math.PI), (float)Math.PI);
        Validate.inRange(limits.y, "limits.y", -1.5707964f, 1.5707964f);
        Validate.inRange(limits.z, "limits.z", (float)(-Math.PI), (float)Math.PI);
        this.angularUpperLimit.set(limits);
        long constraintId = this.nativeId();
        SixDofJoint.setAngularUpperLimit(constraintId, limits);
    }

    public void setLinearLowerLimit(Vector3f vector) {
        this.linearLowerLimit.set(vector);
        long constraintId = this.nativeId();
        SixDofJoint.setLinearLowerLimit(constraintId, vector);
    }

    public void setLinearUpperLimit(Vector3f vector) {
        this.linearUpperLimit.set(vector);
        long constraintId = this.nativeId();
        SixDofJoint.setLinearUpperLimit(constraintId, vector);
    }

    protected native long createJoint(long var1, long var3, Vector3f var5, Matrix3f var6, Vector3f var7, Matrix3f var8, boolean var9);

    protected native long createJoint1(long var1, Vector3f var3, Matrix3f var4, boolean var5);

    private void createJoint() {
        long constraintId;
        PhysicsRigidBody a = this.getBodyA();
        assert (this.pivotA != null);
        assert (this.rotA != null);
        PhysicsRigidBody b = this.getBodyB();
        long bId = b.nativeId();
        assert (this.pivotB != null);
        assert (this.rotB != null);
        if (a == null) {
            Transform jInWorld = new Transform();
            jInWorld.getRotation().fromRotationMatrix(this.rotA);
            jInWorld.setTranslation(this.pivotA);
            Transform jInB = new Transform();
            jInB.getRotation().fromRotationMatrix(this.rotB);
            jInB.setTranslation(this.pivotB);
            Transform bToWorld = jInB.invert();
            MyMath.combine(bToWorld, jInWorld, bToWorld);
            Vector3f saveLocation = b.getPhysicsLocation(null);
            Quaternion saveRotation = b.getPhysicsRotation(null);
            b.setPhysicsLocation(bToWorld.getTranslation());
            b.setPhysicsRotation(bToWorld.getRotation());
            boolean useLinearReferenceFrameB = !this.useLinearReferenceFrameA;
            constraintId = this.createJoint1(bId, this.pivotB, this.rotB, useLinearReferenceFrameB);
            b.setPhysicsLocation(saveLocation);
            b.setPhysicsRotation(saveRotation);
        } else {
            long aId = a.nativeId();
            constraintId = this.createJoint(aId, bId, this.pivotA, this.rotA, this.pivotB, this.rotB, this.useLinearReferenceFrameA);
        }
        int constraintType = SixDofJoint.getConstraintType(constraintId);
        assert (constraintType == 6 || constraintType == 9);
        this.setNativeId(constraintId);
        this.gatherMotors();
    }

    private void gatherMotors() {
        assert (this.rotationalMotors == null);
        assert (this.translationalMotor == null);
        long constraintId = this.nativeId();
        this.rotationalMotors = new RotationalLimitMotor[3];
        for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
            long motorId = SixDofJoint.getRotationalLimitMotor(constraintId, axisIndex);
            this.rotationalMotors[axisIndex] = new RotationalLimitMotor(motorId);
        }
        long motorId = SixDofJoint.getTranslationalLimitMotor(constraintId);
        this.translationalMotor = new TranslationalLimitMotor(motorId);
    }

    private static native void getAngles(long var0, Vector3f var2);

    private static native void getFrameOffsetA(long var0, Transform var2);

    private static native void getFrameOffsetB(long var0, Transform var2);

    private static native void getPivotOffset(long var0, Vector3f var2);

    private static native long getRotationalLimitMotor(long var0, int var2);

    private static native long getTranslationalLimitMotor(long var0);

    private static native void setAngularLowerLimit(long var0, Vector3f var2);

    private static native void setAngularUpperLimit(long var0, Vector3f var2);

    private static native void setLinearLowerLimit(long var0, Vector3f var2);

    private static native void setLinearUpperLimit(long var0, Vector3f var2);
}

